/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Map;
import java.util.Set;

public abstract class LocalDomainCommand
extends CLICommand {
    protected File domainsDir;
    protected File domainRootDir;
    protected String domainName;
    protected String localPassword;
    private static final String DOMAIN_ROOT_KEY = "Domain-Root_value";
    private static final LocalStringsImpl strings = new LocalStringsImpl(LocalDomainCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        this.initDomain();
    }

    protected void initDomain() throws CommandException {
        String domaindir;
        if (!this.operands.isEmpty()) {
            this.domainName = (String)this.operands.get(0);
        }
        this.domainsDir = LocalDomainCommand.ok(domaindir = this.getOption("domaindir")) ? new File(domaindir) : new File(this.getSystemProperty("com.sun.aas.domainsRoot"));
        if (!this.domainsDir.isDirectory()) {
            throw new CommandException(strings.get("Domain.badDomainsDir", new Object[]{this.domainsDir}));
        }
        if (this.domainName != null) {
            this.domainRootDir = new File(this.domainsDir, this.domainName);
        } else {
            this.domainRootDir = this.getTheOneAndOnlyDomain(this.domainsDir);
            this.domainName = this.domainRootDir.getName();
        }
        if (!this.domainRootDir.isDirectory()) {
            throw new CommandException(strings.get("Domain.badDomainDir", new Object[]{this.domainRootDir}));
        }
        this.domainRootDir = SmartFile.sanitize((File)this.domainRootDir);
        this.domainsDir = SmartFile.sanitize((File)this.domainsDir);
        this.getDomainXml();
        this.initializeLocalPassword(this.domainRootDir);
    }

    private File getTheOneAndOnlyDomain(File parent) throws CommandException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandException(strings.get("Domain.noDomainDirs", new Object[]{parent}));
        }
        if (files.length > 1) {
            throw new CommandException(strings.get("Domain.tooManyDomainDirs", new Object[]{parent}));
        }
        return files[0];
    }

    protected File getDomainXml() throws CommandException {
        File domainXml = new File(new File(this.domainRootDir, "config"), "domain.xml");
        if (!domainXml.canRead()) {
            throw new CommandException(strings.get("Domain.noDomainXml", new Object[]{domainXml}));
        }
        return domainXml;
    }

    protected File getMasterPasswordFile() {
        File mp = new File(this.domainRootDir, "master-password");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeLocalPassword(File domainRootDir) {
        File localPasswordFile = new File(new File(domainRootDir, "config"), "local-password");
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(localPasswordFile));
            String pwd = r.readLine();
            if (LocalDomainCommand.ok(pwd)) {
                logger.printDebugMessage("Using local password");
                this.programOpts.setPassword(pwd, ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
                this.localPassword = pwd;
            }
        }
        catch (IOException ex) {
            logger.printDebugMessage("IOException reading local password: " + ex);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    protected File getJKS() {
        File mp = new File(new File(this.domainRootDir, "config"), "keystore.jks");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean verifyMasterPassword(String mpv) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.getJKS());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(fis, mpv.toCharArray());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.printDebugMessage(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    protected String readFromMasterPasswordFile() {
        File mpf = this.getMasterPasswordFile();
        if (mpf == null) {
            return null;
        }
        try {
            PasswordAdapter pw = new PasswordAdapter(mpf.getAbsolutePath(), "master-password".toCharArray());
            return pw.getPasswordForAlias("master-password");
        }
        catch (Exception e) {
            logger.printDebugMessage("master password file reading error: " + e.getMessage());
            return null;
        }
    }

    protected int getAdminPort(File domainXml) throws CommandException {
        try {
            MiniXmlParser parser = new MiniXmlParser(domainXml);
            Set portsSet = parser.getAdminPorts();
            Integer[] ports = portsSet.toArray(new Integer[portsSet.size()]);
            return ports[0];
        }
        catch (MiniXmlParserException ex) {
            throw new CommandException("admin port not found", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRunning(int port) {
        Socket server = null;
        try {
            String host = null;
            server = new Socket(host, port);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.printDebugMessage("\nisRunning got exception: " + ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    protected boolean isThisDAS(File domainDir) {
        try {
            domainDir = SmartFile.sanitize((File)domainDir).getCanonicalFile();
        }
        catch (IOException ioex) {
            // empty catch block
        }
        logger.printDebugMessage("Check if server is at location " + domainDir);
        try {
            RemoteCommand cmd = new RemoteCommand("__locations", this.programOpts, this.env);
            Map<String, String> attrs = cmd.executeAndReturnAttributes("__locations");
            String rdr = attrs.get(DOMAIN_ROOT_KEY);
            logger.printDebugMessage("Remote server has domain root " + rdr);
            if (rdr != null) {
                File rf = SmartFile.sanitize((File)new File(rdr));
                return rf.equals(domainDir);
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

