/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private Map<String, String> optionsMap = new HashMap<String, String>();
    private List<String> operands = new ArrayList<String>();
    private Set<ValidOption> options;
    private boolean ignoreUnknown;
    private static final LocalStringsImpl strings = new LocalStringsImpl(Parser.class);

    public Parser(String[] args, int start, Set<ValidOption> options, boolean ignoreUnknown) throws CommandValidationException {
        this.options = options;
        this.ignoreUnknown = ignoreUnknown;
        this.parseCommandLine(args, start);
    }

    private void parseCommandLine(String[] argv, int start) throws CommandValidationException {
        block0: for (int si = start; si < argv.length; ++si) {
            String arg = argv[si];
            if (arg.equals("--")) {
                if (!this.ignoreUnknown) {
                    ++si;
                }
                while (si < argv.length) {
                    this.operands.add(argv[si++]);
                }
                break;
            }
            if (!arg.startsWith("-") || arg.length() <= 1) {
                this.operands.add(arg);
                if (this.ignoreUnknown) continue;
                ++si;
                while (si < argv.length) {
                    this.operands.add(argv[si++]);
                }
                break;
            }
            ValidOption opt = null;
            String name = null;
            String value = null;
            if (arg.charAt(1) == '-') {
                int ne;
                int ns = 2;
                boolean sawno = false;
                if (arg.startsWith("--no-")) {
                    sawno = true;
                    value = "false";
                    ns = 5;
                }
                if ((ne = arg.indexOf(61)) < 0) {
                    name = arg.substring(ns);
                } else {
                    if (value != null) {
                        throw new CommandValidationException(strings.get("parser.noValueAllowed", new Object[]{arg}));
                    }
                    name = arg.substring(ns, ne);
                    value = arg.substring(ne + 1);
                }
                opt = this.lookupLongOption(name);
                if (sawno && Parser.optionRequiresOperand(opt)) {
                    throw new CommandValidationException(strings.get("parser.illegalNo", new Object[]{opt.getName()}));
                }
            } else if (arg.length() <= 2) {
                opt = this.lookupShortOption(arg.charAt(1));
                name = arg.substring(1);
            } else if (arg.charAt(2) == '=') {
                opt = this.lookupShortOption(arg.charAt(1));
                value = arg.substring(3);
            } else {
                for (int i = 1; i < arg.length(); ++i) {
                    opt = this.lookupShortOption(arg.charAt(i));
                    if (opt == null) {
                        if (!this.ignoreUnknown) {
                            throw new CommandValidationException(strings.get("parser.invalidOption", new Object[]{Character.toString(arg.charAt(i))}));
                        }
                        this.operands.add(arg);
                        continue block0;
                    }
                    if (!opt.getType().equals("BOOLEAN")) {
                        throw new CommandValidationException(strings.get("parser.nonbooleanNotAllowed", new Object[]{Character.toString(arg.charAt(i)), arg}));
                    }
                    this.setOption(opt, "true");
                }
                continue;
            }
            if (opt == null) {
                if (!this.ignoreUnknown) {
                    throw new CommandValidationException(strings.get("parser.invalidOption", new Object[]{arg}));
                }
                this.operands.add(arg);
                continue;
            }
            if (value == null) {
                String val;
                if (this.options == null) {
                    if (si + 1 < argv.length && !argv[si + 1].startsWith("-")) {
                        value = argv[++si];
                    } else {
                        opt.setType("BOOLEAN");
                    }
                } else if (Parser.optionRequiresOperand(opt)) {
                    if (++si >= argv.length) {
                        throw new CommandValidationException(strings.get("parser.missingValue", new Object[]{name}));
                    }
                    value = argv[si];
                } else if (opt.getType().equals("BOOLEAN") && si + 1 < argv.length && ((val = argv[si + 1]).equalsIgnoreCase("true") || val.equalsIgnoreCase("false"))) {
                    ++si;
                    value = val;
                }
            }
            this.setOption(opt, value);
        }
    }

    public Map<String, String> getOptions() {
        return this.optionsMap;
    }

    public List<String> getOperands() {
        return this.operands;
    }

    public String toString() {
        return "CLI parser: Options = " + this.optionsMap + "; Operands = " + this.operands;
    }

    private ValidOption lookupLongOption(String s) {
        if (this.options == null) {
            return new ValidOption(s, "STRING", 2, null);
        }
        for (ValidOption od : this.options) {
            if (!od.getName().equals(s)) continue;
            return od;
        }
        return null;
    }

    private ValidOption lookupShortOption(char c) {
        if (this.options == null) {
            return null;
        }
        String sc = Character.toString(c);
        for (ValidOption od : this.options) {
            if (!od.getShortNames().contains(sc)) continue;
            return od;
        }
        return null;
    }

    private static boolean optionRequiresOperand(ValidOption opt) {
        return opt != null && !opt.getType().equals("BOOLEAN");
    }

    private void setOption(ValidOption opt, String value) throws CommandValidationException {
        String name = opt.getName();
        if (opt == null) {
            throw new NullPointerException("null option name");
        }
        if (value != null) {
            value = value.trim();
        }
        if (opt.getType().equals("FILE")) {
            File f = new File(value);
            if (!f.isFile() && !f.canRead()) {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(f);
                }
                catch (IOException ioex) {
                    throw new CommandValidationException(strings.get("parser.invalidFileEx", new Object[]{name, ioex.toString()}));
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException cex) {}
                    }
                }
                throw new CommandValidationException(strings.get("parser.invalidFile", new Object[]{name, value}));
            }
        } else if (opt.getType().equals("BOOLEAN")) {
            if (value == null) {
                value = "true";
            } else if (!value.toLowerCase(Locale.ENGLISH).equals("true") && !value.toLowerCase(Locale.ENGLISH).equals("false")) {
                throw new CommandValidationException(strings.get("parser.invalidBoolean", new Object[]{name, value}));
            }
        } else if (opt.getType().equals("PASSWORD")) {
            throw new CommandValidationException(strings.get("parser.passwordNotAllowed", new Object[]{opt.getName()}));
        }
        if (this.optionsMap.containsKey(name)) {
            throw new CommandValidationException(strings.get("parser.noRepeats", new Object[]{name}));
        }
        this.optionsMap.put(name, value);
    }
}

