/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.RemoteAcknowledgeException;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.Transaction;
import com.sun.messaging.jmq.jmsclient.XAResourceForJMQ;
import com.sun.messaging.jmq.jmsclient.XAResourceForRA;
import com.sun.messaging.jmq.jmsclient.XAResourceMap;
import com.sun.messaging.jmq.util.JMQXid;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource,
XAResourceForJMQ {
    private SessionImpl _session;
    private ConnectionImpl _connection;
    private Transaction _transaction = null;
    private long resourceManagerId = 0L;
    private int transactionTimeout = 0;
    protected static Hashtable xaTable = new Hashtable();
    public static final Integer XA_START = 0;
    public static final Integer XA_END = 1;
    public static final Integer XA_PREPARE = 2;
    public static final Integer XA_ROLLBACK_ONLY = 4;
    public static boolean turnOffXATracking = Boolean.getBoolean("imq.ra.turnOffXATracking");
    public static boolean XATracking = !turnOffXATracking;
    private static Map<XAResourceImpl, JMQXid> lastInternalRBCache = Collections.synchronizedMap(new LinkedHashMap());
    private boolean lastInternalRB = false;
    private ConnectionConsumerImpl connectionConsumer = null;
    JMQXid currentJMQXid = null;
    private static final transient String _className = "com.sun.messaging.jmq.jmsclient.XAResourceImpl";
    private static final transient String _lgrName = "com.sun.messaging.jmq.jmsclient.XAResourceImpl";
    private static final transient Logger _logger = Logger.getLogger("com.sun.messaging.jmq.jmsclient.XAResourceImpl");
    private static final transient String _lgrPrefix = "XAResourceImpl: ";

    public XAResourceImpl(SessionImpl sessionImpl) throws JMSException {
        this._session = sessionImpl;
        this._connection = sessionImpl.connection;
        this.resourceManagerId = this._connection.protocolHandler.generateUID();
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:new:RMId=" + this.resourceManagerId);
        }
    }

    protected void setConnectionConsumer(ConnectionConsumerImpl connectionConsumerImpl) {
        this.connectionConsumer = connectionConsumerImpl;
    }

    protected ConnectionConsumerImpl getConnectionConsumer() {
        return this.connectionConsumer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        boolean bl2;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("XAResourceImpl: (" + this.hashCode() + ") Commit  " + this.printXid(xid) + " (onePhase=" + bl + ")");
        }
        JMQXid jMQXid = new JMQXid(xid);
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:commit:onePhase=" + bl + "\txid=\n" + jMQXid.toString());
        }
        if (this._session.isRollbackOnly) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:prepare:forcing Rollback due to:" + this._session.rollbackCause.getMessage());
            XAException xAException = new XAException(-7);
            xAException.initCause(this._session.rollbackCause);
            throw xAException;
        }
        try {
            try {
                try {
                    this._connection.openConnectionFromRA(true);
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    this._connection.openConnectionFromRA(true);
                }
                if (this._transaction == null) {
                    if (Debug.debug) {
                        Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:commit:using 0 as txnID");
                    }
                    if (this._connection.isConnectedToHABroker) {
                        this.HACommit(xid, jMQXid, bl);
                    } else {
                        this._connection.getProtocolHandler().commit(0L, bl ? 0x40000000 : 0, jMQXid);
                    }
                } else {
                    if (Debug.debug) {
                        Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:commit:using real txnID");
                    }
                    this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                    if (!this._session.isClosed) {
                        this._session.setInSyncState();
                        this._session.receiveCommit();
                    }
                    if (this._connection.isConnectedToHABroker) {
                        this.HACommit(xid, jMQXid, bl);
                        this._session.clearUnackedMessageQ();
                    } else {
                        this._transaction.commitXATransaction(jMQXid, bl);
                    }
                }
                this._connection.closeConnectionFromRA();
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                XAException xAException = new XAException(-7);
                xAException.initCause(exception);
                throw xAException;
            }
            Object var7_9 = null;
            bl2 = false;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            boolean bl3 = false;
            XAResourceImpl[] xAResourceImplArray = XAResourceMap.getXAResources(jMQXid, bl3);
            int i = 0;
            while (true) {
                if (i >= xAResourceImplArray.length) {
                    XAResourceMap.unregister(jMQXid);
                    this._session.releaseInSyncState();
                    throw throwable;
                }
                XAResourceImpl xAResourceImpl = xAResourceImplArray[i];
                xAResourceImpl.finishCommit();
                ++i;
            }
        }
        XAResourceImpl[] xAResourceImplArray = XAResourceMap.getXAResources(jMQXid, bl2);
        for (int i = 0; i < xAResourceImplArray.length; ++i) {
            XAResourceImpl xAResourceImpl = xAResourceImplArray[i];
            xAResourceImpl.finishCommit();
        }
        XAResourceMap.unregister(jMQXid);
        this._session.releaseInSyncState();
    }

    protected void close() {
        if (this.currentJMQXid != null) {
            SessionImpl.sessionLogger.log(Level.INFO, "Closing XA session with a transaction pending");
            XAResourceMap.unregisterResource(this, this.currentJMQXid);
            this.currentJMQXid = null;
        }
        this.connectionConsumer = null;
    }

    protected void finishCommit() {
        this._session.switchOffXATransaction();
        this.currentJMQXid = null;
        this.connectionConsumer = null;
    }

    protected void finishRollback() {
        this._session.failoverOccurred = false;
        this._session.switchOffXATransaction();
        this._session.isRollbackOnly = false;
        this._session.rollbackCause = null;
        this.currentJMQXid = null;
        this.connectionConsumer = null;
    }

    public void end(Xid xid, int n) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("XAResourceImpl: XAResourceImpl (" + this.hashCode() + ") End     " + this.printXid(xid) + this.printFlags(n));
        }
        JMQXid jMQXid = new JMQXid(xid);
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:end:flags=" + n + "\txid=\n" + jMQXid.toString());
        }
        try {
            this._session.transaction.endXATransaction(n, jMQXid);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace(jMSException);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
    }

    public void forget(Xid xid) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        XAResourceMap.unregister(jMQXid);
        if (this.currentJMQXid != null && this.currentJMQXid.equals(jMQXid)) {
            this.currentJMQXid = null;
            this.connectionConsumer = null;
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (xAResource instanceof XAResourceImpl) {
            return this.isSameJMQRM((XAResourceForJMQ)((Object)xAResource));
        }
        return false;
    }

    public boolean isSameJMQRM(XAResourceForJMQ xAResourceForJMQ) {
        boolean bl = this.getBrokerSessionID() != 0L && this.getBrokerSessionID() == xAResourceForJMQ.getBrokerSessionID();
        if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
            long l = this.getBrokerSessionID();
            long l2 = xAResourceForJMQ.getBrokerSessionID();
            SessionImpl.sessionLogger.log(Level.FINE, "myBrokerSessionID=" + l + " herBrokerSessionID=" + l2 + " isSameRM()=" + bl);
        }
        return bl;
    }

    public long getBrokerSessionID() {
        return this._connection.getBrokerSessionID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepare(Xid xid, boolean bl) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("XAResourceImpl: XAResourceImpl (" + this.hashCode() + ") Prepare     " + this.printXid(xid));
        }
        int n = 0;
        JMQXid jMQXid = new JMQXid(xid);
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:prepare:txid=\n" + jMQXid.toString());
        }
        try {
            if (this._session.isRollbackOnly) {
                Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:prepare:forcing Rollback due to:" + this._session.rollbackCause.getMessage());
                if (this.connectionConsumer != null && this._session.rollbackCause instanceof RemoteAcknowledgeException) {
                    throw this._session.rollbackCause;
                }
                XAException xAException = new XAException(-7);
                xAException.initCause(this._session.rollbackCause);
                throw xAException;
            }
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            if (this._transaction == null) {
                this._connection.getProtocolHandler().prepare(0L, jMQXid, bl);
            } else {
                this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                if (bl) {
                    this._connection.getProtocolHandler().prepare(0L, jMQXid, bl);
                } else {
                    this._transaction.prepareXATransaction(jMQXid);
                }
            }
            this._connection.closeConnectionFromRA();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            if (throwable instanceof XAException) {
                throw (XAException)throwable;
            }
            XAException xAException = new XAException(-7);
            xAException.initCause(throwable);
            if (throwable instanceof RemoteAcknowledgeException) {
                if (this.connectionConsumer != null) {
                    ConnectionConsumerImpl connectionConsumerImpl = this.connectionConsumer;
                    if (!connectionConsumerImpl.canRecreate()) {
                        throw xAException;
                    }
                    try {
                        try {
                            this.rollback(xid);
                            xAException = new XAException(100);
                            xAException.initCause(throwable);
                            lastInternalRBCache.put(this, jMQXid);
                            this.lastInternalRB = true;
                        }
                        catch (Throwable throwable2) {
                            SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on rollback transaction " + jMQXid + " after prepared failed with remote exception", throwable2);
                            Object var10_15 = null;
                            connectionConsumerImpl.notifyRecreation((RemoteAcknowledgeException)throwable);
                        }
                        Object var10_14 = null;
                        connectionConsumerImpl.notifyRecreation((RemoteAcknowledgeException)throwable);
                    }
                    catch (Throwable throwable3) {
                        Object var10_16 = null;
                        connectionConsumerImpl.notifyRecreation((RemoteAcknowledgeException)throwable);
                        throw throwable3;
                    }
                } else if (this._session.isRemoteException((RemoteAcknowledgeException)throwable)) {
                    try {
                        this.rollback(xid);
                        xAException = new XAException(100);
                        xAException.initCause(throwable);
                        lastInternalRBCache.put(this, jMQXid);
                        this.lastInternalRB = true;
                    }
                    catch (Throwable throwable4) {
                        SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on rollback transaction " + jMQXid + " after prepare failed with remote exception", throwable4);
                    }
                    try {
                        this._session.setInSyncState();
                    }
                    catch (Throwable throwable5) {
                        SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on setting sync state after prepare " + jMQXid + " failed with remote exception", throwable5);
                        throw xAException;
                    }
                    try {
                        try {
                            this._session.recreateConsumers(true);
                        }
                        catch (Throwable throwable6) {
                            SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on recreating consumers after prepare " + jMQXid + " failed with remote exception", throwable6);
                            throw xAException;
                        }
                        Object var12_19 = null;
                        this._session.releaseInSyncState();
                    }
                    catch (Throwable throwable7) {
                        Object var12_20 = null;
                        this._session.releaseInSyncState();
                        throw throwable7;
                    }
                }
            }
            throw xAException;
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray = null;
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:recover:flags=" + n);
        }
        try {
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            xidArray = this._connection.getProtocolHandler().recover(n);
            this._connection.closeConnectionFromRA();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        return xidArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback(Xid xid) throws XAException {
        boolean bl;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("XAResourceImpl: (" + this.hashCode() + ") Rollback  " + this.printXid(xid) + ")");
        }
        JMQXid jMQXid = new JMQXid(xid);
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:rollback:txid=\n" + jMQXid.toString());
        }
        try {
            try {
                block24: {
                    try {
                        this._connection.openConnectionFromRA(true);
                    }
                    catch (Exception exception) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        this._connection.openConnectionFromRA(true);
                    }
                    if (this._transaction == null) {
                        try {
                            if (this._connection.isConnectedToHABroker) {
                                this.HARollback(jMQXid, false);
                                break block24;
                            }
                            this._connection.getProtocolHandler().rollback(0L, jMQXid);
                        }
                        catch (JMSException jMSException) {
                            this.checkInternalRB(jMSException, jMQXid);
                        }
                    } else {
                        this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                        if (!this._session.isClosed) {
                            this._session.setInSyncState();
                            this._session.receiveRollback();
                        }
                        try {
                            if (this._connection.isConnectedToHABroker) {
                                this.HARollback(jMQXid, false);
                            } else {
                                this._transaction.rollbackXATransaction(jMQXid);
                            }
                        }
                        catch (JMSException jMSException) {
                            this.checkInternalRB(jMSException, jMQXid);
                        }
                    }
                }
                this._connection.closeConnectionFromRA();
            }
            catch (JMSException jMSException) {
                Debug.printStackTrace(jMSException);
                XAException xAException = new XAException(-7);
                xAException.initCause(jMSException);
                throw xAException;
            }
            Object var6_10 = null;
            bl = false;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            boolean bl2 = false;
            XAResourceImpl[] xAResourceImplArray = XAResourceMap.getXAResources(jMQXid, bl2);
            int i = 0;
            while (true) {
                if (i >= xAResourceImplArray.length) {
                    XAResourceMap.unregister(jMQXid);
                    this._session.releaseInSyncState();
                    throw throwable;
                }
                XAResourceImpl xAResourceImpl = xAResourceImplArray[i];
                xAResourceImpl.finishRollback();
                ++i;
            }
        }
        XAResourceImpl[] xAResourceImplArray = XAResourceMap.getXAResources(jMQXid, bl);
        for (int i = 0; i < xAResourceImplArray.length; ++i) {
            XAResourceImpl xAResourceImpl = xAResourceImplArray[i];
            xAResourceImpl.finishRollback();
        }
        XAResourceMap.unregister(jMQXid);
        this._session.releaseInSyncState();
    }

    private void checkInternalRB(JMSException jMSException, JMQXid jMQXid) throws JMSException {
        Exception exception;
        if (jMSException.getErrorCode().equals("C4036") && (exception = jMSException.getLinkedException()) != null && exception instanceof JMSException && ((JMSException)exception).getErrorCode().equals(Status.getString(404)) && lastInternalRBCache.containsValue(jMQXid)) {
            ConnectionImpl.connectionLogger.log(Level.INFO, "Transaction " + jMQXid + " has already been rolled back");
            lastInternalRBCache.remove(this);
            this.lastInternalRB = false;
            return;
        }
        throw jMSException;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public void start(Xid xid, int n) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("XAResourceImpl: (" + this.hashCode() + ") Start   " + this.printXid(xid) + this.printFlags(n));
        }
        JMQXid jMQXid = new JMQXid(xid);
        if (this.lastInternalRB) {
            lastInternalRBCache.remove(this);
            this.lastInternalRB = false;
        }
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:start:flags=" + n + "\txid=\n" + jMQXid.toString());
        }
        try {
            this._session.switchOnXATransaction();
            this._transaction = this._session.transaction;
            this._transaction.startXATransaction(n, jMQXid);
            if (!this.isResume(n)) {
                XAResourceMap.register(jMQXid, this, this.isJoin(n));
            }
            this.currentJMQXid = jMQXid;
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace(jMSException);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
    }

    public long getResourceManagerId() {
        return this.resourceManagerId;
    }

    protected static synchronized void setState(Object object, Object object2) {
        xaTable.put(object, object2);
    }

    protected static synchronized Integer getState(Object object) {
        return (Integer)xaTable.get(object);
    }

    protected static synchronized Object removeXid(Object object) {
        return xaTable.remove(object);
    }

    protected static synchronized boolean isPrepared(Object object) {
        boolean bl = false;
        Integer n = (Integer)xaTable.get(object);
        if (n != null && n.intValue() == XA_PREPARE.intValue()) {
            bl = true;
        }
        return bl;
    }

    protected static synchronized boolean isRollbackOnly(Object object) {
        boolean bl = false;
        Integer n = (Integer)xaTable.get(object);
        if (n != null && n.intValue() == XA_ROLLBACK_ONLY.intValue()) {
            bl = true;
        }
        return bl;
    }

    public synchronized int prepare(Xid xid) throws XAException {
        int n = 0;
        JMQXid jMQXid = null;
        if (this._connection.isConnectedToHABroker) {
            jMQXid = new JMQXid(xid);
        }
        try {
            this.prepare(xid, false);
        }
        catch (XAException xAException) {
            if (this._connection.isConnectedToHABroker) {
                this.checkPrepareStatus(xAException, jMQXid);
            }
            throw xAException;
        }
        if (this.isXATracking()) {
            xaTable.put(jMQXid, XA_PREPARE);
        }
        return n;
    }

    private boolean isXATracking() {
        return this._connection.isConnectedToHABroker() && XATracking;
    }

    private void checkPrepareStatus(XAException xAException, JMQXid jMQXid) throws XAException {
        if (!this._connection.imqReconnect) {
            throw xAException;
        }
        try {
            SessionImpl.yield();
            this._connection.checkReconnecting(null);
            if (this._connection.isCloseCalled || this._connection.connectionIsBroken) {
                throw xAException;
            }
            this.verifyPrepare(jMQXid);
        }
        catch (XAException xAException2) {
            throw xAException2;
        }
        catch (Exception exception) {
            XAException xAException3 = new XAException(-7);
            xAException3.initCause(exception);
            throw xAException3;
        }
    }

    private void verifyPrepare(JMQXid jMQXid) throws XAException, JMSException {
        SessionImpl.sessionLogger.log(Level.INFO, "XA verifyPrepare(), jmqXid: " + jMQXid);
        int n = this._connection.protocolHandler.verifyHATransaction(0L, 1, jMQXid);
        switch (n) {
            case 6: {
                SessionImpl.sessionLogger.log(Level.INFO, "transaction in prepared state: " + jMQXid);
                return;
            }
        }
        XAException xAException = new XAException(100);
        throw xAException;
    }

    private void HAOnePhaseCommit(Xid xid, JMQXid jMQXid) throws JMSException, XAException {
        int n = 1;
        try {
            this.prepare(xid, true);
            n = 2;
            if (this.isXATracking()) {
                xaTable.put(jMQXid, XAResourceForRA.XA_PREPARE);
            }
            this._connection.getProtocolHandler().commit(0L, 0, jMQXid, true);
        }
        catch (Exception exception) {
            this.checkCommitStatus(exception, n, jMQXid, true);
        }
        XAResourceImpl.removeXid(jMQXid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void HATwoPhaseCommit(JMQXid jMQXid) throws JMSException, XAException {
        block2: {
            try {
                this._connection.getProtocolHandler().commit(0L, 0, jMQXid);
            }
            catch (JMSException jMSException) {
                if (!this.isXATracking()) throw jMSException;
                Integer n = (Integer)xaTable.get(jMQXid);
                if (n == null || n != 2) break block2;
                this.checkCommitStatus(jMSException, 2, jMQXid, false);
            }
        }
        XAResourceImpl.removeXid(jMQXid);
    }

    private void checkCommitStatus(Exception exception, int n, JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        try {
            this.doCheckCommitStatus(exception, n, jMQXid, bl);
        }
        catch (Exception exception2) {
            if (exception2 instanceof JMSException) {
                throw (JMSException)exception2;
            }
            if (exception2 instanceof XAException) {
                throw (XAException)exception2;
            }
            XAException xAException = new XAException(-7);
            xAException.initCause(exception2);
            throw xAException;
        }
    }

    private void doCheckCommitStatus(Exception exception, int n, JMQXid jMQXid, boolean bl) throws Exception {
        if (!this._connection.imqReconnect) {
            throw exception;
        }
        SessionImpl.yield();
        this._connection.checkReconnecting(null);
        if (this._connection.isCloseCalled || this._connection.connectionIsBroken) {
            throw exception;
        }
        this.verifyTransaction(n, jMQXid, bl);
    }

    private void verifyTransaction(int n, JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        int n2 = this._connection.protocolHandler.verifyHATransaction(0L, n, jMQXid);
        switch (n2) {
            case 7: {
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): transaction is in prepred state, committing the transaction: " + jMQXid);
                    this._connection.getProtocolHandler().commit(0L, 0, jMQXid, bl);
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): prepared transaction committed successfully: " + jMQXid);
                    return;
                }
                catch (JMSException jMSException) {
                    SessionImpl.yield();
                    this._connection.checkReconnecting(null);
                    throw jMSException;
                }
            }
        }
        XAException xAException = new XAException(100);
        throw xAException;
    }

    private void HACommit(Xid xid, JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        if (bl) {
            this.HAOnePhaseCommit(xid, jMQXid);
        } else {
            this.HATwoPhaseCommit(jMQXid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void HARollback(JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        try {
            try {
                this._connection.getProtocolHandler().rollback(0L, jMQXid, bl);
            }
            catch (JMSException jMSException) {
                SessionImpl.yield();
                this._connection.checkReconnecting(null);
                if (this._connection.isCloseCalled) throw jMSException;
                if (this._connection.connectionIsBroken) {
                    throw jMSException;
                }
                this.retryRollBack(jMQXid, bl);
                Object var5_4 = null;
                XAResourceImpl.removeXid(jMQXid);
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            XAResourceImpl.removeXid(jMQXid);
            throw throwable;
        }
        XAResourceImpl.removeXid(jMQXid);
    }

    private void retryRollBack(JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        try {
            this._connection.getProtocolHandler().rollback(0L, jMQXid, bl, true);
        }
        catch (JMSException jMSException) {
            if (this.isXATracking()) {
                Integer n = (Integer)xaTable.get(jMQXid);
                if (n != null && n != 2) {
                    ConnectionImpl.connectionLogger.log(Level.WARNING, jMSException.toString());
                }
                throw jMSException;
            }
            throw jMSException;
        }
    }

    private boolean isJoin(int n) {
        return (n & 0x200000) == 0x200000;
    }

    private boolean isResume(int n) {
        return (n & 0x8000000) == 0x8000000;
    }

    public void clearTransactionInfo() {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean isComplete() {
        throw new UnsupportedOperationException("Not supported");
    }

    private String printXid(Xid xid) {
        return "(GlobalTransactionID=" + xid.getGlobalTransactionId() + ", BranchQualifier=" + xid.getBranchQualifier() + ") ";
    }

    private boolean isNoFlags(int n) {
        return (n & 0) == 0;
    }

    private boolean isFail(int n) {
        return (n & 0x20000000) == 0x20000000;
    }

    private boolean isOnePhase(int n) {
        return (n & 0x40000000) == 0x40000000;
    }

    private boolean isSuccess(int n) {
        return (n & 0x4000000) == 0x4000000;
    }

    private boolean isSuspend(int n) {
        return (n & 0x2000000) == 0x2000000;
    }

    private boolean isTMENDRSCAN(int n) {
        return (n & 0x800000) == 0x800000;
    }

    private boolean TMSTARTRSCAN(int n) {
        return (n & 0x1000000) == 0x1000000;
    }

    private String printFlags(int n) {
        String string = "(Flags: ";
        if (this.isJoin(n)) {
            string = string + "JOIN ";
        }
        if (this.isNoFlags(n)) {
            string = string + "TMNOFLAGS ";
        }
        if (this.isFail(n)) {
            string = string + "TMFAIL ";
        }
        if (this.isOnePhase(n)) {
            string = string + "TMONEPHASE ";
        }
        if (this.isResume(n)) {
            string = string + "TMRESUME ";
        }
        if (this.isSuccess(n)) {
            string = string + "TMSUCCESS ";
        }
        if (this.isSuspend(n)) {
            string = string + "TMSUSPEND ";
        }
        if (this.isTMENDRSCAN(n)) {
            string = string + "TMENDRSCAN ";
        }
        if (this.TMSTARTRSCAN(n)) {
            string = string + "TMSTARTRSCAN ";
        }
        string = string + ")";
        return string;
    }
}

