/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EventBroadcastHelper
implements EventBroadcaster {
    Collection[] c = new Collection[EventType.EVENT_TYPE_NUM];
    boolean[] busy = new boolean[EventType.EVENT_TYPE_NUM];
    int[] start = null;
    int cnt = 0;
    Boolean orderMaintained = new Boolean(true);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock shareLock = this.lock.readLock();
    private Lock exclusiveLock = this.lock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrderMaintained(boolean bl) {
        Boolean bl2 = this.orderMaintained;
        synchronized (bl2) {
            this.orderMaintained = bl;
            if (!this.orderMaintained.booleanValue()) {
                this.start = new int[EventType.EVENT_TYPE_NUM];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.exclusiveLock.lock();
        try {
            this.c = new Collection[EventType.EVENT_TYPE_NUM];
            for (int i = 0; i < EventType.EVENT_TYPE_NUM; ++i) {
                this.busy[i] = false;
            }
            Object var3_2 = null;
            this.exclusiveLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.exclusiveLock.unlock();
            throw throwable;
        }
    }

    public void dump(PrintStream printStream) {
        printStream.println(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string = "EventBroadcastHelper {\n";
        this.shareLock.lock();
        try {
            int n = this.c.length;
            for (int i = 0; i < n; ++i) {
                boolean bl = false;
                string = string + "\t" + i + " { ";
                if (this.c[i] == null) {
                    string = string + "null";
                } else {
                    Iterator iterator = this.c[i].iterator();
                    boolean bl2 = true;
                    int n2 = 0;
                    while (iterator.hasNext()) {
                        ListenerInfo listenerInfo = (ListenerInfo)iterator.next();
                        bl = true;
                        if (!bl2) {
                            string = string + "\t    ";
                        }
                        bl2 = false;
                        string = string + n2 + ":  " + listenerInfo.getListener() + "\n\t        " + listenerInfo.getType() + "\n\t        " + listenerInfo.getReason() + "\n\t        " + listenerInfo.getUserData() + "\n";
                        ++n2;
                    }
                }
                string = bl ? string + "\t  }\n" : string + " }\n";
            }
            Object var10_9 = null;
            this.shareLock.unlock();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        return string;
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Object object) {
        return this.addEventListener(eventListener, eventType, null, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addEventListener(EventListener eventListener, EventType eventType, Reason reason, Object object) {
        ListenerInfo listenerInfo = new ListenerInfo(eventListener, eventType, reason, object);
        int n = eventType.getEvent();
        this.exclusiveLock.lock();
        try {
            if (this.c[n] == null) {
                this.c[n] = new ArrayList();
                this.c[n].add(listenerInfo);
            } else {
                ArrayList<ListenerInfo> arrayList = new ArrayList<ListenerInfo>(this.c[n]);
                arrayList.add(listenerInfo);
                this.c[n] = arrayList;
            }
            this.busy[n] = true;
            ++this.cnt;
            Object var9_8 = null;
            this.exclusiveLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.exclusiveLock.unlock();
            throw throwable;
        }
        return listenerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeEventListener(Object object) {
        Collection collection;
        ListenerInfo listenerInfo;
        block7: {
            block6: {
                block5: {
                    this.exclusiveLock.lock();
                    try {
                        if (object != null) break block5;
                        Object var2_2 = null;
                        Object var9_4 = null;
                        this.exclusiveLock.unlock();
                        return var2_2;
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        this.exclusiveLock.unlock();
                        throw throwable;
                    }
                }
                listenerInfo = (ListenerInfo)object;
                if (listenerInfo.isValid()) break block6;
                Object var3_9 = null;
                Object var9_5 = null;
                this.exclusiveLock.unlock();
                return var3_9;
            }
            int n = listenerInfo.getType().getEvent();
            collection = this.c[n];
            if (collection != null) break block7;
            Object var5_12 = null;
            Object var9_6 = null;
            this.exclusiveLock.unlock();
            return var5_12;
        }
        ArrayList arrayList = new ArrayList(collection);
        arrayList.remove(listenerInfo);
        this.busy[n] = !arrayList.isEmpty();
        this.c[n] = arrayList;
        EventListener eventListener = listenerInfo.getListener();
        listenerInfo.clear();
        --this.cnt;
        EventListener eventListener2 = eventListener;
        Object var9_7 = null;
        this.exclusiveLock.unlock();
        return eventListener2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange(EventType eventType, Reason reason, Object object, Object object2, Object object3) {
        this.shareLock.lock();
        try {
            ArrayList arrayList;
            block11: {
                block10: {
                    arrayList = (ArrayList)this.c[eventType.getEvent()];
                    if (arrayList == null) break block10;
                    if (!arrayList.isEmpty()) break block11;
                }
                Object var16_7 = null;
                this.shareLock.unlock();
                return;
            }
            int n = 0;
            int n2 = arrayList.size();
            if (!this.orderMaintained.booleanValue() && this.start != null && n2 > 1) {
                Boolean bl = this.orderMaintained;
                synchronized (bl) {
                    n = this.start[eventType.getEvent()];
                    this.start[eventType.getEvent()] = n >= n2 - 1 ? 0 : n + 1;
                }
            }
            for (int i = 0; i < n2; ++i) {
                int n3;
                ListenerInfo listenerInfo = null;
                int n4 = n3 = n == 0 ? i : (i + n) % n2;
                if (n3 >= arrayList.size() || (listenerInfo = (ListenerInfo)arrayList.get(n3)) == null) continue;
                EventListener eventListener = listenerInfo.getListener();
                Reason reason2 = listenerInfo.getReason();
                Object object4 = listenerInfo.getUserData();
                if (eventListener == null || reason2 != null && reason2 != reason) continue;
                eventListener.eventOccured(eventType, reason, object, object2, object3, object4);
            }
        }
        catch (Throwable throwable) {
            Object var16_9 = null;
            this.shareLock.unlock();
            throw throwable;
        }
        Object var16_8 = null;
        this.shareLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(EventType eventType) {
        this.shareLock.lock();
        try {
            boolean bl = this.busy[eventType.getEvent()];
            Object var4_3 = null;
            this.shareLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shareLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        this.shareLock.lock();
        try {
            boolean bl = this.cnt > 0;
            Object var3_2 = null;
            this.shareLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.shareLock.unlock();
            throw throwable;
        }
    }

    class ListenerInfo {
        boolean valid = true;
        EventListener l;
        EventType type;
        Object userData;
        Reason reason;

        public ListenerInfo(EventListener eventListener, EventType eventType, Reason reason, Object object) {
            this.l = eventListener;
            this.type = eventType;
            this.userData = object;
            this.reason = reason;
        }

        Reason getReason() {
            return this.reason;
        }

        boolean isValid() {
            return this.valid;
        }

        Object getUserData() {
            return this.userData;
        }

        EventType getType() {
            return this.type;
        }

        EventListener getListener() {
            return this.l;
        }

        void clear() {
            this.valid = false;
            this.l = null;
            this.userData = null;
            this.reason = null;
            this.type = null;
        }
    }
}

