/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Arrays;

public class ByteArray {
    public byte[] items;
    public int size;
    public boolean ordered;

    public ByteArray() {
        this(true, 16);
    }

    public ByteArray(int capacity) {
        this(true, capacity);
    }

    public ByteArray(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new byte[capacity];
    }

    public ByteArray(ByteArray array) {
        this.ordered = array.ordered;
        this.size = array.size;
        this.items = new byte[this.size];
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public ByteArray(byte[] array) {
        this(true, array, 0, array.length);
    }

    public ByteArray(boolean ordered, byte[] array, int startIndex, int count) {
        this(ordered, count);
        this.size = count;
        System.arraycopy(array, startIndex, this.items, 0, count);
    }

    public void add(byte value) {
        byte[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size++] = value;
    }

    public void add(byte value1, byte value2) {
        byte[] items = this.items;
        if (this.size + 1 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        this.size += 2;
    }

    public void add(byte value1, byte value2, byte value3) {
        byte[] items = this.items;
        if (this.size + 2 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        this.size += 3;
    }

    public void add(byte value1, byte value2, byte value3, byte value4) {
        byte[] items = this.items;
        if (this.size + 3 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.8f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        items[this.size + 3] = value4;
        this.size += 4;
    }

    public void addAll(ByteArray array) {
        this.addAll(array.items, 0, array.size);
    }

    public void addAll(ByteArray array, int offset, int length) {
        if (offset + length > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.size);
        }
        this.addAll(array.items, offset, length);
    }

    public void addAll(byte ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(byte[] array, int offset, int length) {
        int sizeNeeded = this.size + length;
        byte[] items = this.items;
        if (sizeNeeded > items.length) {
            items = this.resize(Math.max(8, (int)((float)sizeNeeded * 1.75f)));
        }
        System.arraycopy(array, offset, items, this.size, length);
        this.size += length;
    }

    public byte get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, byte value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void incr(int index, byte value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = (byte)(this.items[n] + value);
    }

    public void incr(byte value) {
        byte[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items[n2] = (byte)(items[n2] + value);
        }
    }

    public void mul(int index, byte value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = (byte)(this.items[n] * value);
    }

    public void mul(byte value) {
        byte[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items[n2] = (byte)(items[n2] * value);
        }
    }

    public void insert(int index, byte value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        byte[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(items, index, items, index + 1, this.size - index);
        } else {
            items[this.size] = items[index];
        }
        ++this.size;
        items[index] = value;
    }

    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        byte[] items = this.items;
        byte firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    public boolean contains(byte value) {
        int i = this.size - 1;
        byte[] items = this.items;
        while (i >= 0) {
            if (items[i--] != value) continue;
            return true;
        }
        return false;
    }

    public int indexOf(byte value) {
        byte[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            if (items[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(byte value) {
        byte[] items = this.items;
        int i = this.size - 1;
        while (i >= 0) {
            if (items[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public boolean removeValue(byte value) {
        byte[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            if (items[i] == value) {
                this.removeIndex(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public int removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        byte[] items = this.items;
        byte value = items[index];
        --this.size;
        if (this.ordered) {
            System.arraycopy(items, index + 1, items, index, this.size - index);
        } else {
            items[index] = items[this.size];
        }
        return value;
    }

    public void removeRange(int start, int end) {
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int count = end - start + 1;
        int lastIndex = n - count;
        if (this.ordered) {
            System.arraycopy(this.items, start + count, this.items, start, n - (start + count));
        } else {
            int i = Math.max(lastIndex, end + 1);
            System.arraycopy(this.items, i, this.items, start, n - i);
        }
        this.size = n - count;
    }

    public boolean removeAll(ByteArray array) {
        int size;
        int startSize = size = this.size;
        byte[] items = this.items;
        int i = 0;
        int n = array.size;
        while (i < n) {
            byte item = array.get(i);
            int ii = 0;
            while (ii < size) {
                if (item == items[ii]) {
                    this.removeIndex(ii);
                    --size;
                    break;
                }
                ++ii;
            }
            ++i;
        }
        return size != startSize;
    }

    public byte pop() {
        return this.items[--this.size];
    }

    public byte peek() {
        return this.items[this.size - 1];
    }

    public byte first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public byte[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public byte[] ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded > this.items.length) {
            this.resize(Math.max(8, sizeNeeded));
        }
        return this.items;
    }

    public byte[] setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("newSize must be >= 0: " + newSize);
        }
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected byte[] resize(int newSize) {
        byte[] newItems = new byte[newSize];
        byte[] items = this.items;
        System.arraycopy(items, 0, newItems, 0, Math.min(this.size, newItems.length));
        this.items = newItems;
        return newItems;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        byte[] items = this.items;
        int i = 0;
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        while (i < n) {
            int ii = lastIndex - i;
            byte temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
            ++i;
        }
    }

    public void shuffle() {
        byte[] items = this.items;
        int i = this.size - 1;
        while (i >= 0) {
            int ii = MathUtils.random(i);
            byte temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
            --i;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    public byte random() {
        if (this.size == 0) {
            return 0;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public byte[] toArray() {
        byte[] array = new byte[this.size];
        System.arraycopy(this.items, 0, array, 0, this.size);
        return array;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        byte[] items = this.items;
        int h = 1;
        int i = 0;
        int n = this.size;
        while (i < n) {
            h = h * 31 + items[i];
            ++i;
        }
        return h;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof ByteArray)) {
            return false;
        }
        ByteArray array = (ByteArray)object;
        if (!array.ordered) {
            return false;
        }
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        byte[] items1 = this.items;
        byte[] items2 = array.items;
        int i = 0;
        while (i < n) {
            if (items1[i] != items2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        byte[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(items[0]);
        int i = 1;
        while (i < this.size) {
            buffer.append(", ");
            buffer.append(items[i]);
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        byte[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(items[0]);
        int i = 1;
        while (i < this.size) {
            buffer.append(separator);
            buffer.append(items[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static ByteArray with(byte ... array) {
        return new ByteArray(array);
    }
}

