/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.IntArray;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.MonsterRow;
import com.esotericsoftware.gloomhavenhelper.model.SummonColor;
import com.esotericsoftware.gloomhavenhelper.util.Menu;
import com.esotericsoftware.gloomhavenhelper.util.builders.ButtonBuilder;
import com.esotericsoftware.gloomhavenhelper.util.builders.TextButtonBuilder;

public class MonsterAddMenu
extends Menu {
    private MonsterRow row;

    public MonsterAddMenu(final MonsterRow row, IntArray free, final boolean elite) {
        this.row = row;
        this.defaults().size(100.0f);
        Color color = row.data.isBoss() ? App.bossRed : (elite ? App.eliteGold : Color.WHITE);
        int columns = 2;
        if (row.data.count < 6) {
            columns = 5;
        } else if (row.data.count < 10) {
            columns = 3;
        }
        int i = 1;
        while (i <= row.data.count) {
            boolean disabled = !free.contains(i);
            Button button = ((TextButtonBuilder)((TextButtonBuilder)((TextButtonBuilder)((ButtonBuilder)App.textButton(String.valueOf(i)).fontColor(color)).over("selected", App.buttonGray)).disabled("white", Color.CLEAR)).disabled(disabled)).create();
            final int number = i;
            if (!disabled) {
                button.addListener(new ClickListener((TextButton)button){
                    private final /* synthetic */ TextButton val$button;
                    {
                        this.val$button = textButton;
                    }

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        row.addMonsterBox(number, row.data, row.level, elite, SummonColor.blue, true);
                        App.state.changed();
                        if (row.boxes.size == row.data.count) {
                            MonsterAddMenu.this.hide();
                        }
                        this.val$button.setDisabled(true);
                        this.val$button.removeListener(this);
                    }
                });
            }
            this.add(button);
            if (i % columns == 0) {
                this.row();
            }
            ++i;
        }
    }

    @Override
    protected void updatePosition() {
        super.updatePosition();
        App.gloom.rowsScroll.scrollTo(0.0f, this.row.getY() - 10.0f, 0.0f, this.row.getHeight() + 20.0f);
    }
}

