/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonLoader;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class SkeletonJson
extends SkeletonLoader {
    public SkeletonJson(AttachmentLoader attachmentLoader) {
        super(attachmentLoader);
    }

    public SkeletonJson(TextureAtlas atlas) {
        super(atlas);
    }

    protected JsonValue parse(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        return new JsonReader().parse(file);
    }

    @Override
    public SkeletonData readSkeletonData(FileHandle file) {
        String targetName;
        BoneData bone;
        JsonValue entry;
        ConstraintData data;
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        float scale = this.scale;
        SkeletonData skeletonData = new SkeletonData();
        skeletonData.name = file.nameWithoutExtension();
        JsonValue root = this.parse(file);
        JsonValue skeletonMap = root.get("skeleton");
        if (skeletonMap != null) {
            skeletonData.hash = skeletonMap.getString("hash", null);
            skeletonData.version = skeletonMap.getString("spine", null);
            skeletonData.x = skeletonMap.getFloat("x", 0.0f);
            skeletonData.y = skeletonMap.getFloat("y", 0.0f);
            skeletonData.width = skeletonMap.getFloat("width", 0.0f);
            skeletonData.height = skeletonMap.getFloat("height", 0.0f);
            skeletonData.fps = skeletonMap.getFloat("fps", 30.0f);
            skeletonData.imagesPath = skeletonMap.getString("images", null);
            skeletonData.audioPath = skeletonMap.getString("audio", null);
        }
        JsonValue boneMap = root.getChild("bones");
        while (boneMap != null) {
            BoneData parent = null;
            String parentName = boneMap.getString("parent", null);
            if (parentName != null && (parent = skeletonData.findBone(parentName)) == null) {
                throw new SerializationException("Parent bone not found: " + parentName);
            }
            BoneData data2 = new BoneData(skeletonData.bones.size, boneMap.getString("name"), parent);
            data2.length = boneMap.getFloat("length", 0.0f) * scale;
            data2.x = boneMap.getFloat("x", 0.0f) * scale;
            data2.y = boneMap.getFloat("y", 0.0f) * scale;
            data2.rotation = boneMap.getFloat("rotation", 0.0f);
            data2.scaleX = boneMap.getFloat("scaleX", 1.0f);
            data2.scaleY = boneMap.getFloat("scaleY", 1.0f);
            data2.shearX = boneMap.getFloat("shearX", 0.0f);
            data2.shearY = boneMap.getFloat("shearY", 0.0f);
            data2.transformMode = BoneData.TransformMode.valueOf(boneMap.getString("transform", BoneData.TransformMode.normal.name()));
            data2.skinRequired = boneMap.getBoolean("skin", false);
            String color = boneMap.getString("color", null);
            if (color != null) {
                Color.valueOf(color, data2.getColor());
            }
            skeletonData.bones.add(data2);
            boneMap = boneMap.next;
        }
        JsonValue slotMap = root.getChild("slots");
        while (slotMap != null) {
            String dark;
            String slotName = slotMap.getString("name");
            String boneName = slotMap.getString("bone");
            BoneData boneData = skeletonData.findBone(boneName);
            if (boneData == null) {
                throw new SerializationException("Slot bone not found: " + boneName);
            }
            SlotData data3 = new SlotData(skeletonData.slots.size, slotName, boneData);
            String color = slotMap.getString("color", null);
            if (color != null) {
                Color.valueOf(color, data3.getColor());
            }
            if ((dark = slotMap.getString("dark", null)) != null) {
                data3.setDarkColor(Color.valueOf(dark));
            }
            data3.attachmentName = slotMap.getString("attachment", null);
            data3.blendMode = BlendMode.valueOf(slotMap.getString("blend", BlendMode.normal.name()));
            skeletonData.slots.add(data3);
            slotMap = slotMap.next;
        }
        JsonValue constraintMap = root.getChild("ik");
        while (constraintMap != null) {
            data = new IkConstraintData(constraintMap.getString("name"));
            data.order = constraintMap.getInt("order", 0);
            data.skinRequired = constraintMap.getBoolean("skin", false);
            entry = constraintMap.getChild("bones");
            while (entry != null) {
                bone = skeletonData.findBone(entry.asString());
                if (bone == null) {
                    throw new SerializationException("IK bone not found: " + entry);
                }
                data.bones.add(bone);
                entry = entry.next;
            }
            targetName = constraintMap.getString("target");
            data.target = skeletonData.findBone(targetName);
            if (data.target == null) {
                throw new SerializationException("IK target bone not found: " + targetName);
            }
            data.mix = constraintMap.getFloat("mix", 1.0f);
            data.softness = constraintMap.getFloat("softness", 0.0f) * scale;
            data.bendDirection = constraintMap.getBoolean("bendPositive", true) ? 1 : -1;
            data.compress = constraintMap.getBoolean("compress", false);
            data.stretch = constraintMap.getBoolean("stretch", false);
            data.uniform = constraintMap.getBoolean("uniform", false);
            skeletonData.ikConstraints.add((IkConstraintData)data);
            constraintMap = constraintMap.next;
        }
        constraintMap = root.getChild("transform");
        while (constraintMap != null) {
            data = new TransformConstraintData(constraintMap.getString("name"));
            ((TransformConstraintData)data).order = constraintMap.getInt("order", 0);
            ((TransformConstraintData)data).skinRequired = constraintMap.getBoolean("skin", false);
            entry = constraintMap.getChild("bones");
            while (entry != null) {
                bone = skeletonData.findBone(entry.asString());
                if (bone == null) {
                    throw new SerializationException("Transform constraint bone not found: " + entry);
                }
                ((TransformConstraintData)data).bones.add(bone);
                entry = entry.next;
            }
            targetName = constraintMap.getString("target");
            ((TransformConstraintData)data).target = skeletonData.findBone(targetName);
            if (((TransformConstraintData)data).target == null) {
                throw new SerializationException("Transform constraint target bone not found: " + targetName);
            }
            ((TransformConstraintData)data).local = constraintMap.getBoolean("local", false);
            ((TransformConstraintData)data).relative = constraintMap.getBoolean("relative", false);
            ((TransformConstraintData)data).offsetRotation = constraintMap.getFloat("rotation", 0.0f);
            ((TransformConstraintData)data).offsetX = constraintMap.getFloat("x", 0.0f) * scale;
            ((TransformConstraintData)data).offsetY = constraintMap.getFloat("y", 0.0f) * scale;
            ((TransformConstraintData)data).offsetScaleX = constraintMap.getFloat("scaleX", 0.0f);
            ((TransformConstraintData)data).offsetScaleY = constraintMap.getFloat("scaleY", 0.0f);
            ((TransformConstraintData)data).offsetShearY = constraintMap.getFloat("shearY", 0.0f);
            ((TransformConstraintData)data).rotateMix = constraintMap.getFloat("rotateMix", 1.0f);
            ((TransformConstraintData)data).translateMix = constraintMap.getFloat("translateMix", 1.0f);
            ((TransformConstraintData)data).scaleMix = constraintMap.getFloat("scaleMix", 1.0f);
            ((TransformConstraintData)data).shearMix = constraintMap.getFloat("shearMix", 1.0f);
            skeletonData.transformConstraints.add((TransformConstraintData)data);
            constraintMap = constraintMap.next;
        }
        constraintMap = root.getChild("path");
        while (constraintMap != null) {
            data = new PathConstraintData(constraintMap.getString("name"));
            ((PathConstraintData)data).order = constraintMap.getInt("order", 0);
            ((PathConstraintData)data).skinRequired = constraintMap.getBoolean("skin", false);
            entry = constraintMap.getChild("bones");
            while (entry != null) {
                bone = skeletonData.findBone(entry.asString());
                if (bone == null) {
                    throw new SerializationException("Path bone not found: " + entry);
                }
                ((PathConstraintData)data).bones.add(bone);
                entry = entry.next;
            }
            targetName = constraintMap.getString("target");
            ((PathConstraintData)data).target = skeletonData.findSlot(targetName);
            if (((PathConstraintData)data).target == null) {
                throw new SerializationException("Path target slot not found: " + targetName);
            }
            ((PathConstraintData)data).positionMode = PathConstraintData.PositionMode.valueOf(constraintMap.getString("positionMode", "percent"));
            ((PathConstraintData)data).spacingMode = PathConstraintData.SpacingMode.valueOf(constraintMap.getString("spacingMode", "length"));
            ((PathConstraintData)data).rotateMode = PathConstraintData.RotateMode.valueOf(constraintMap.getString("rotateMode", "tangent"));
            ((PathConstraintData)data).offsetRotation = constraintMap.getFloat("rotation", 0.0f);
            ((PathConstraintData)data).position = constraintMap.getFloat("position", 0.0f);
            if (((PathConstraintData)data).positionMode == PathConstraintData.PositionMode.fixed) {
                ((PathConstraintData)data).position *= scale;
            }
            ((PathConstraintData)data).spacing = constraintMap.getFloat("spacing", 0.0f);
            if (((PathConstraintData)data).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)data).spacingMode == PathConstraintData.SpacingMode.fixed) {
                ((PathConstraintData)data).spacing *= scale;
            }
            ((PathConstraintData)data).rotateMix = constraintMap.getFloat("rotateMix", 1.0f);
            ((PathConstraintData)data).translateMix = constraintMap.getFloat("translateMix", 1.0f);
            skeletonData.pathConstraints.add((PathConstraintData)data);
            constraintMap = constraintMap.next;
        }
        JsonValue skinMap = root.getChild("skins");
        while (skinMap != null) {
            ConstraintData constraint;
            Skin skin = new Skin(skinMap.getString("name"));
            entry = skinMap.getChild("bones");
            while (entry != null) {
                bone = skeletonData.findBone(entry.asString());
                if (bone == null) {
                    throw new SerializationException("Skin bone not found: " + entry);
                }
                skin.bones.add(bone);
                entry = entry.next;
            }
            skin.bones.shrink();
            entry = skinMap.getChild("ik");
            while (entry != null) {
                constraint = skeletonData.findIkConstraint(entry.asString());
                if (constraint == null) {
                    throw new SerializationException("Skin IK constraint not found: " + entry);
                }
                skin.constraints.add(constraint);
                entry = entry.next;
            }
            entry = skinMap.getChild("transform");
            while (entry != null) {
                constraint = skeletonData.findTransformConstraint(entry.asString());
                if (constraint == null) {
                    throw new SerializationException("Skin transform constraint not found: " + entry);
                }
                skin.constraints.add(constraint);
                entry = entry.next;
            }
            entry = skinMap.getChild("path");
            while (entry != null) {
                constraint = skeletonData.findPathConstraint(entry.asString());
                if (constraint == null) {
                    throw new SerializationException("Skin path constraint not found: " + entry);
                }
                skin.constraints.add(constraint);
                entry = entry.next;
            }
            skin.constraints.shrink();
            JsonValue slotEntry = skinMap.getChild("attachments");
            while (slotEntry != null) {
                SlotData slot = skeletonData.findSlot(slotEntry.name);
                if (slot == null) {
                    throw new SerializationException("Slot not found: " + slotEntry.name);
                }
                JsonValue entry2 = slotEntry.child;
                while (entry2 != null) {
                    try {
                        Attachment attachment = this.readAttachment(entry2, skin, slot.index, entry2.name, skeletonData);
                        if (attachment != null) {
                            skin.setAttachment(slot.index, entry2.name, attachment);
                        }
                    }
                    catch (Throwable ex) {
                        throw new SerializationException("Error reading attachment: " + entry2.name + ", skin: " + skin, ex);
                    }
                    entry2 = entry2.next;
                }
                slotEntry = slotEntry.next;
            }
            skeletonData.skins.add(skin);
            if (skin.name.equals("default")) {
                skeletonData.defaultSkin = skin;
            }
            skinMap = skinMap.next;
        }
        T[] items = this.linkedMeshes.items;
        int i = 0;
        int n = this.linkedMeshes.size;
        while (i < n) {
            Skin skin;
            LinkedMesh linkedMesh = (LinkedMesh)items[i];
            Skin skin2 = skin = linkedMesh.skin == null ? skeletonData.getDefaultSkin() : skeletonData.findSkin(linkedMesh.skin);
            if (skin == null) {
                throw new SerializationException("Skin not found: " + linkedMesh.skin);
            }
            Attachment parent = skin.getAttachment(linkedMesh.slotIndex, linkedMesh.parent);
            if (parent == null) {
                throw new SerializationException("Parent mesh not found: " + linkedMesh.parent);
            }
            linkedMesh.mesh.setDeformAttachment(linkedMesh.inheritDeform ? (VertexAttachment)parent : linkedMesh.mesh);
            linkedMesh.mesh.setParentMesh((MeshAttachment)parent);
            linkedMesh.mesh.updateUVs();
            ++i;
        }
        this.linkedMeshes.clear();
        JsonValue eventMap = root.getChild("events");
        while (eventMap != null) {
            EventData data4 = new EventData(eventMap.name);
            data4.intValue = eventMap.getInt("int", 0);
            data4.floatValue = eventMap.getFloat("float", 0.0f);
            data4.stringValue = eventMap.getString("string", "");
            data4.audioPath = eventMap.getString("audio", null);
            if (data4.audioPath != null) {
                data4.volume = eventMap.getFloat("volume", 1.0f);
                data4.balance = eventMap.getFloat("balance", 0.0f);
            }
            skeletonData.events.add(data4);
            eventMap = eventMap.next;
        }
        JsonValue animationMap = root.getChild("animations");
        while (animationMap != null) {
            try {
                this.readAnimation(animationMap, animationMap.name, skeletonData);
            }
            catch (Throwable ex) {
                throw new SerializationException("Error reading animation: " + animationMap.name, ex);
            }
            animationMap = animationMap.next;
        }
        skeletonData.bones.shrink();
        skeletonData.slots.shrink();
        skeletonData.skins.shrink();
        skeletonData.events.shrink();
        skeletonData.animations.shrink();
        skeletonData.ikConstraints.shrink();
        return skeletonData;
    }

    private Attachment readAttachment(JsonValue map, Skin skin, int slotIndex, String name, SkeletonData skeletonData) {
        float scale = this.scale;
        name = map.getString("name", name);
        switch (AttachmentType.valueOf(map.getString("type", AttachmentType.region.name()))) {
            case region: {
                String path = map.getString("path", name);
                RegionAttachment region = this.attachmentLoader.newRegionAttachment(skin, name, path);
                if (region == null) {
                    return null;
                }
                region.setPath(path);
                region.setX(map.getFloat("x", 0.0f) * scale);
                region.setY(map.getFloat("y", 0.0f) * scale);
                region.setScaleX(map.getFloat("scaleX", 1.0f));
                region.setScaleY(map.getFloat("scaleY", 1.0f));
                region.setRotation(map.getFloat("rotation", 0.0f));
                region.setWidth(map.getFloat("width") * scale);
                region.setHeight(map.getFloat("height") * scale);
                String color = map.getString("color", null);
                if (color != null) {
                    Color.valueOf(color, region.getColor());
                }
                region.updateOffset();
                return region;
            }
            case boundingbox: {
                BoundingBoxAttachment box = this.attachmentLoader.newBoundingBoxAttachment(skin, name);
                if (box == null) {
                    return null;
                }
                this.readVertices(map, box, map.getInt("vertexCount") << 1);
                String color = map.getString("color", null);
                if (color != null) {
                    Color.valueOf(color, box.getColor());
                }
                return box;
            }
            case mesh: 
            case linkedmesh: {
                String path = map.getString("path", name);
                MeshAttachment mesh = this.attachmentLoader.newMeshAttachment(skin, name, path);
                if (mesh == null) {
                    return null;
                }
                mesh.setPath(path);
                String color = map.getString("color", null);
                if (color != null) {
                    Color.valueOf(color, mesh.getColor());
                }
                mesh.setWidth(map.getFloat("width", 0.0f) * scale);
                mesh.setHeight(map.getFloat("height", 0.0f) * scale);
                String parent = map.getString("parent", null);
                if (parent != null) {
                    this.linkedMeshes.add(new LinkedMesh(mesh, map.getString("skin", null), slotIndex, parent, map.getBoolean("deform", true)));
                    return mesh;
                }
                float[] uvs = map.require("uvs").asFloatArray();
                this.readVertices(map, mesh, uvs.length);
                mesh.setTriangles(map.require("triangles").asShortArray());
                mesh.setRegionUVs(uvs);
                mesh.updateUVs();
                if (map.has("hull")) {
                    mesh.setHullLength(map.require("hull").asInt() << 1);
                }
                if (map.has("edges")) {
                    mesh.setEdges(map.require("edges").asShortArray());
                }
                return mesh;
            }
            case path: {
                PathAttachment path = this.attachmentLoader.newPathAttachment(skin, name);
                if (path == null) {
                    return null;
                }
                path.setClosed(map.getBoolean("closed", false));
                path.setConstantSpeed(map.getBoolean("constantSpeed", true));
                int vertexCount = map.getInt("vertexCount");
                this.readVertices(map, path, vertexCount << 1);
                float[] lengths = new float[vertexCount / 3];
                int i = 0;
                JsonValue curves = map.require((String)"lengths").child;
                while (curves != null) {
                    lengths[i++] = curves.asFloat() * scale;
                    curves = curves.next;
                }
                path.setLengths(lengths);
                String color = map.getString("color", null);
                if (color != null) {
                    Color.valueOf(color, path.getColor());
                }
                return path;
            }
            case point: {
                PointAttachment point = this.attachmentLoader.newPointAttachment(skin, name);
                if (point == null) {
                    return null;
                }
                point.setX(map.getFloat("x", 0.0f) * scale);
                point.setY(map.getFloat("y", 0.0f) * scale);
                point.setRotation(map.getFloat("rotation", 0.0f));
                String color = map.getString("color", null);
                if (color != null) {
                    Color.valueOf(color, point.getColor());
                }
                return point;
            }
            case clipping: {
                ClippingAttachment clip = this.attachmentLoader.newClippingAttachment(skin, name);
                if (clip == null) {
                    return null;
                }
                String end = map.getString("end", null);
                if (end != null) {
                    SlotData slot = skeletonData.findSlot(end);
                    if (slot == null) {
                        throw new SerializationException("Clipping end slot not found: " + end);
                    }
                    clip.setEndSlot(slot);
                }
                this.readVertices(map, clip, map.getInt("vertexCount") << 1);
                String color = map.getString("color", null);
                if (color != null) {
                    Color.valueOf(color, clip.getColor());
                }
                return clip;
            }
        }
        return null;
    }

    private void readVertices(JsonValue map, VertexAttachment attachment, int verticesLength) {
        attachment.setWorldVerticesLength(verticesLength);
        float[] vertices = map.require("vertices").asFloatArray();
        if (verticesLength == vertices.length) {
            if (this.scale != 1.0f) {
                int i = 0;
                int n = vertices.length;
                while (i < n) {
                    int n2 = i++;
                    vertices[n2] = vertices[n2] * this.scale;
                }
            }
            attachment.setVertices(vertices);
            return;
        }
        FloatArray weights = new FloatArray(verticesLength * 3 * 3);
        IntArray bones = new IntArray(verticesLength * 3);
        int i = 0;
        int n = vertices.length;
        while (i < n) {
            int boneCount = (int)vertices[i++];
            bones.add(boneCount);
            int nn = i + (boneCount << 2);
            while (i < nn) {
                bones.add((int)vertices[i]);
                weights.add(vertices[i + 1] * this.scale);
                weights.add(vertices[i + 2] * this.scale);
                weights.add(vertices[i + 3]);
                i += 4;
            }
        }
        attachment.setBones(bones.toArray());
        attachment.setVertices(weights.toArray());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void readAnimation(JsonValue map, String name, SkeletonData skeletonData) {
        block72: {
            scale = this.scale;
            timelines = new Array<Animation.Timeline>();
            slotMap = map.getChild("slots");
            while (slotMap != null) {
                slot = skeletonData.findSlot(slotMap.name);
                if (slot == null) {
                    throw new SerializationException("Slot not found: " + slotMap.name);
                }
                timelineMap = slotMap.child;
                while (timelineMap != null) {
                    keyMap = timelineMap.child;
                    if (keyMap != null) {
                        timelineName = timelineMap.name;
                        if (timelineName.equals("attachment")) {
                            timeline = new Animation.AttachmentTimeline(timelineMap.size, slot.index);
                            frame = 0;
                            while (keyMap != null) {
                                timeline.setFrame(frame, keyMap.getFloat("time", 0.0f), keyMap.getString("name"));
                                keyMap = keyMap.next;
                                ++frame;
                            }
                            timelines.add(timeline);
                        } else if (timelineName.equals("color")) {
                            timeline = new Animation.ColorTimeline(timelineMap.size, timelineMap.size << 2, slot.index);
                            time = keyMap.getFloat("time", 0.0f);
                            color = keyMap.getString("color");
                            r = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                            g = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                            b = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                            a = (float)Integer.parseInt(color.substring(6, 8), 16) / 255.0f;
                            frame = 0;
                            bezier = 0;
                            while (true) {
                                timeline.setFrame(frame, time, r, g, b, a);
                                nextMap = keyMap.next;
                                if (nextMap == null) break;
                                time2 = nextMap.getFloat("time", 0.0f);
                                color = nextMap.getString("color");
                                nr = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                                ng = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                                nb = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                                na = (float)Integer.parseInt(color.substring(6, 8), 16) / 255.0f;
                                curve = keyMap.get("curve");
                                if (curve != null) {
                                    bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline, bezier, frame, 0, time, time2, r, nr, 1.0f);
                                    bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline, bezier, frame, 1, time, time2, g, ng, 1.0f);
                                    bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline, bezier, frame, 2, time, time2, b, nb, 1.0f);
                                    bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline, bezier, frame, 3, time, time2, a, na, 1.0f);
                                }
                                time = time2;
                                r = nr;
                                g = ng;
                                b = nb;
                                a = na;
                                keyMap = nextMap;
                                ++frame;
                            }
                            timeline.shrink(bezier);
                            timelines.add(timeline);
                        } else if (timelineName.equals("twoColor")) {
                            timeline = new Animation.TwoColorTimeline(timelineMap.size, timelineMap.size * 7, slot.index);
                            time = keyMap.getFloat("time", 0.0f);
                            color = keyMap.getString("light");
                            r = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                            g = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                            b = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                            a = (float)Integer.parseInt(color.substring(6, 8), 16) / 255.0f;
                            color = keyMap.getString("dark");
                            r2 = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                            g2 = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                            b2 = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                            frame = 0;
                            bezier = 0;
                            while (true) {
                                timeline.setFrame(frame, time, r, g, b, a, r2, g2, b2);
                                nextMap = keyMap.next;
                                if (nextMap == null) break;
                                time2 = nextMap.getFloat("time", 0.0f);
                                color = nextMap.getString("light");
                                nr = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                                ng = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                                nb = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                                na = (float)Integer.parseInt(color.substring(6, 8), 16) / 255.0f;
                                color = nextMap.getString("dark");
                                nr2 = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
                                ng2 = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
                                nb2 = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
                                curve = keyMap.get("curve");
                                if (curve != null) {
                                    bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline, bezier, frame, 0, time, time2, r, nr, 1.0f);
                                    bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline, bezier, frame, 1, time, time2, g, ng, 1.0f);
                                    bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline, bezier, frame, 2, time, time2, b, nb, 1.0f);
                                    bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline, bezier, frame, 3, time, time2, a, na, 1.0f);
                                    bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline, bezier, frame, 4, time, time2, r2, nr2, 1.0f);
                                    bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline, bezier, frame, 5, time, time2, g2, ng2, 1.0f);
                                    bezier = this.readCurve(curve, (Animation.CurveTimeline)timeline, bezier, frame, 6, time, time2, b2, nb2, 1.0f);
                                }
                                time = time2;
                                r = nr;
                                g = ng;
                                b = nb;
                                a = na;
                                r2 = nr2;
                                g2 = ng2;
                                b2 = nb2;
                                keyMap = nextMap;
                                ++frame;
                            }
                            timeline.shrink(bezier);
                            timelines.add(timeline);
                        } else {
                            throw new RuntimeException("Invalid timeline type for a slot: " + timelineName + " (" + slotMap.name + ")");
                        }
                    }
                    timelineMap = timelineMap.next;
                }
                slotMap = slotMap.next;
            }
            boneMap = map.getChild("bones");
            while (boneMap != null) {
                bone = skeletonData.findBone(boneMap.name);
                if (bone == null) {
                    throw new SerializationException("Bone not found: " + boneMap.name);
                }
                timelineMap = boneMap.child;
                while (timelineMap != null) {
                    keyMap = timelineMap.child;
                    if (keyMap != null) {
                        timelineName = timelineMap.name;
                        if (timelineName.equals("rotate")) {
                            timelines.add(this.readTimeline(keyMap, new Animation.RotateTimeline(timelineMap.size, timelineMap.size, bone.index), 0.0f, 1.0f));
                        } else if (timelineName.equals("translate")) {
                            timeline = new Animation.TranslateTimeline(timelineMap.size, timelineMap.size << 1, bone.index);
                            timelines.add(this.readTimeline(keyMap, (Animation.CurveTimeline2)timeline, "x", "y", 0.0f, scale));
                        } else if (timelineName.equals("scale")) {
                            timeline = new Animation.ScaleTimeline(timelineMap.size, timelineMap.size << 1, bone.index);
                            timelines.add(this.readTimeline(keyMap, (Animation.CurveTimeline2)timeline, "x", "y", 1.0f, 1.0f));
                        } else if (timelineName.equals("shear")) {
                            timeline = new Animation.ShearTimeline(timelineMap.size, timelineMap.size << 1, bone.index);
                            timelines.add(this.readTimeline(keyMap, (Animation.CurveTimeline2)timeline, "x", "y", 0.0f, 1.0f));
                        } else {
                            throw new RuntimeException("Invalid timeline type for a bone: " + timelineName + " (" + boneMap.name + ")");
                        }
                    }
                    timelineMap = timelineMap.next;
                }
                boneMap = boneMap.next;
            }
            timelineMap = map.getChild("ik");
            while (timelineMap != null) {
                keyMap = timelineMap.child;
                if (keyMap != null) {
                    constraint /* !! */  = skeletonData.findIkConstraint(timelineMap.name);
                    timeline = new Animation.IkConstraintTimeline(timelineMap.size, timelineMap.size << 1, skeletonData.getIkConstraints().indexOf(constraint /* !! */ , true));
                    time = keyMap.getFloat("time", 0.0f);
                    mix = keyMap.getFloat("mix", 1.0f);
                    softness = keyMap.getFloat("softness", 0.0f) * scale;
                    frame = 0;
                    bezier = 0;
                    while (true) {
                        timeline.setFrame(frame, time, mix, softness, keyMap.getBoolean("bendPositive", true) != false ? 1 : -1, keyMap.getBoolean("compress", false), keyMap.getBoolean("stretch", false));
                        nextMap = keyMap.next;
                        if (nextMap == null) break;
                        time2 = nextMap.getFloat("time", 0.0f);
                        mix2 = nextMap.getFloat("mix", 1.0f);
                        softness2 = nextMap.getFloat("softness", 0.0f) * scale;
                        curve = keyMap.get("curve");
                        if (curve != null) {
                            bezier = this.readCurve(curve, timeline, bezier, frame, 0, time, time2, mix, mix2, 1.0f);
                            bezier = this.readCurve(curve, timeline, bezier, frame, 1, time, time2, softness, softness2, scale);
                        }
                        time = time2;
                        mix = mix2;
                        softness = softness2;
                        keyMap = nextMap;
                        ++frame;
                    }
                    timeline.shrink(bezier);
                    timelines.add(timeline);
                }
                timelineMap = timelineMap.next;
            }
            timelineMap = map.getChild("transform");
            while (timelineMap != null) {
                keyMap = timelineMap.child;
                if (keyMap != null) {
                    constraint /* !! */  = skeletonData.findTransformConstraint(timelineMap.name);
                    timeline = new Animation.TransformConstraintTimeline(timelineMap.size, timelineMap.size << 2, skeletonData.getTransformConstraints().indexOf((TransformConstraintData)constraint /* !! */ , true));
                    time = keyMap.getFloat("time", 0.0f);
                    rotateMix = keyMap.getFloat("rotateMix", 1.0f);
                    translateMix = keyMap.getFloat("translateMix", 1.0f);
                    scaleMix = keyMap.getFloat("scaleMix", 1.0f);
                    shearMix = keyMap.getFloat("shearMix", 1.0f);
                    frame = 0;
                    bezier = 0;
                    while (true) {
                        timeline.setFrame(frame, time, rotateMix, translateMix, scaleMix, shearMix);
                        nextMap = keyMap.next;
                        if (nextMap == null) break;
                        time2 = nextMap.getFloat("time", 0.0f);
                        rotateMix2 = nextMap.getFloat("rotateMix", 1.0f);
                        translateMix2 = nextMap.getFloat("translateMix", 1.0f);
                        scaleMix2 = nextMap.getFloat("scaleMix", 1.0f);
                        shearMix2 = nextMap.getFloat("shearMix", 1.0f);
                        curve = keyMap.get("curve");
                        if (curve != null) {
                            bezier = this.readCurve(curve, timeline, bezier, frame, 0, time, time2, rotateMix, rotateMix2, 1.0f);
                            bezier = this.readCurve(curve, timeline, bezier, frame, 1, time, time2, translateMix, translateMix2, 1.0f);
                            bezier = this.readCurve(curve, timeline, bezier, frame, 2, time, time2, scaleMix, scaleMix2, 1.0f);
                            bezier = this.readCurve(curve, timeline, bezier, frame, 3, time, time2, shearMix, shearMix2, 1.0f);
                        }
                        time = time2;
                        rotateMix = rotateMix2;
                        translateMix = translateMix2;
                        scaleMix = scaleMix2;
                        shearMix = shearMix2;
                        keyMap = nextMap;
                        ++frame;
                    }
                    timeline.shrink(bezier);
                    timelines.add(timeline);
                }
                timelineMap = timelineMap.next;
            }
            constraintMap = map.getChild("path");
            while (constraintMap != null) {
                data = skeletonData.findPathConstraint(constraintMap.name);
                if (data == null) {
                    throw new SerializationException("Path constraint not found: " + constraintMap.name);
                }
                index = skeletonData.pathConstraints.indexOf(data, true);
                timelineMap = constraintMap.child;
                while (timelineMap != null) {
                    keyMap = timelineMap.child;
                    if (keyMap != null) {
                        timelineName = timelineMap.name;
                        if (timelineName.equals("position")) {
                            timeline /* !! */  = new Animation.PathConstraintPositionTimeline(timelineMap.size, timelineMap.size, index);
                            timelines.add(this.readTimeline(keyMap, timeline /* !! */ , 0.0f, data.positionMode == PathConstraintData.PositionMode.fixed ? scale : 1.0f));
                        } else if (timelineName.equals("spacing")) {
                            timeline /* !! */  = new Animation.PathConstraintSpacingTimeline(timelineMap.size, timelineMap.size, index);
                            timelines.add(this.readTimeline(keyMap, timeline /* !! */ , 0.0f, data.spacingMode == PathConstraintData.SpacingMode.length || data.spacingMode == PathConstraintData.SpacingMode.fixed ? scale : 1.0f));
                        } else if (timelineName.equals("mix")) {
                            timeline /* !! */  = new Animation.PathConstraintMixTimeline(timelineMap.size, timelineMap.size << 1, index);
                            timelines.add(this.readTimeline(keyMap, (Animation.CurveTimeline2)timeline /* !! */ , "rotateMix", "translateMix", 1.0f, 1.0f));
                        }
                    }
                    timelineMap = timelineMap.next;
                }
                constraintMap = constraintMap.next;
            }
            deformMap = map.getChild("deform");
            while (deformMap != null) {
                skin = skeletonData.findSkin(deformMap.name);
                if (skin == null) {
                    throw new SerializationException("Skin not found: " + deformMap.name);
                }
                slotMap = deformMap.child;
                while (slotMap != null) {
                    slot = skeletonData.findSlot(slotMap.name);
                    if (slot == null) {
                        throw new SerializationException("Slot not found: " + slotMap.name);
                    }
                    timelineMap = slotMap.child;
                    while (timelineMap != null) {
                        keyMap = timelineMap.child;
                        if (keyMap != null) {
                            attachment = (VertexAttachment)skin.getAttachment(slot.index, timelineMap.name);
                            if (attachment == null) {
                                throw new SerializationException("Deform attachment not found: " + timelineMap.name);
                            }
                            weighted = attachment.getBones() != null;
                            vertices = attachment.getVertices();
                            deformLength = weighted != false ? vertices.length / 3 << 1 : vertices.length;
                            timeline = new Animation.DeformTimeline(timelineMap.size, timelineMap.size, slot.index, attachment);
                            time = keyMap.getFloat("time", 0.0f);
                            frame = 0;
                            bezier = 0;
                            while (true) {
                                if ((verticesValue = keyMap.get("vertices")) == null) {
                                    deform = weighted != false ? new float[deformLength] : vertices;
                                } else {
                                    deform = new float[deformLength];
                                    start = keyMap.getInt("offset", 0);
                                    SpineUtils.arraycopy(verticesValue.asFloatArray(), 0, deform, start, verticesValue.size);
                                    if (scale != 1.0f) {
                                        i = start;
                                        n = i + verticesValue.size;
                                        while (i < n) {
                                            v0 = i++;
                                            deform[v0] = deform[v0] * scale;
                                        }
                                    }
                                    if (!weighted) {
                                        i = 0;
                                        while (i < deformLength) {
                                            v1 = i;
                                            deform[v1] = deform[v1] + vertices[i];
                                            ++i;
                                        }
                                    }
                                }
                                timeline.setFrame(frame, time, deform);
                                nextMap = keyMap.next;
                                if (nextMap == null) break;
                                time2 = nextMap.getFloat("time", 0.0f);
                                curve = keyMap.get("curve");
                                if (curve != null) {
                                    bezier = this.readCurve(curve, timeline, bezier, frame, 0, time, time2, 0.0f, 1.0f, 1.0f);
                                }
                                time = time2;
                                keyMap = nextMap;
                                ++frame;
                            }
                            timeline.shrink(bezier);
                            timelines.add(timeline);
                        }
                        timelineMap = timelineMap.next;
                    }
                    slotMap = slotMap.next;
                }
                deformMap = deformMap.next;
            }
            drawOrdersMap = map.get("drawOrder");
            if (drawOrdersMap == null) {
                drawOrdersMap = map.get("draworder");
            }
            if (drawOrdersMap == null) break block72;
            timeline = new Animation.DrawOrderTimeline(drawOrdersMap.size);
            slotCount = skeletonData.slots.size;
            frame = 0;
            drawOrderMap = drawOrdersMap.child;
            while (drawOrderMap != null) {
                block73: {
                    drawOrder = null;
                    offsets = drawOrderMap.get("offsets");
                    if (offsets == null) break block73;
                    drawOrder = new int[slotCount];
                    i = slotCount - 1;
                    while (i >= 0) {
                        drawOrder[i] = -1;
                        --i;
                    }
                    unchanged = new int[slotCount - offsets.size];
                    originalIndex = 0;
                    unchangedIndex = 0;
                    offsetMap = offsets.child;
                    while (offsetMap != null) {
                        slot = skeletonData.findSlot(offsetMap.getString("slot"));
                        if (slot != null) ** GOTO lbl335
                        throw new SerializationException("Slot not found: " + offsetMap.getString("slot"));
lbl-1000:
                        // 1 sources

                        {
                            unchanged[unchangedIndex++] = originalIndex++;
lbl335:
                            // 2 sources

                            ** while (originalIndex != slot.index)
                        }
lbl336:
                        // 1 sources

                        drawOrder[originalIndex + offsetMap.getInt((String)"offset")] = originalIndex++;
                        offsetMap = offsetMap.next;
                    }
                    while (originalIndex < slotCount) {
                        unchanged[unchangedIndex++] = originalIndex++;
                    }
                    i = slotCount - 1;
                    while (i >= 0) {
                        if (drawOrder[i] == -1) {
                            drawOrder[i] = unchanged[--unchangedIndex];
                        }
                        --i;
                    }
                }
                timeline.setFrame(frame, drawOrderMap.getFloat("time", 0.0f), drawOrder);
                drawOrderMap = drawOrderMap.next;
                ++frame;
            }
            timelines.add(timeline);
        }
        if ((eventsMap = map.get("events")) != null) {
            timeline = new Animation.EventTimeline(eventsMap.size);
            frame = 0;
            eventMap = eventsMap.child;
            while (eventMap != null) {
                eventData = skeletonData.findEvent(eventMap.getString("name"));
                if (eventData == null) {
                    throw new SerializationException("Event not found: " + eventMap.getString("name"));
                }
                event = new Event(eventMap.getFloat("time", 0.0f), eventData);
                event.intValue = eventMap.getInt("int", eventData.intValue);
                event.floatValue = eventMap.getFloat("float", eventData.floatValue);
                event.stringValue = eventMap.getString("string", eventData.stringValue);
                if (event.getData().audioPath != null) {
                    event.volume = eventMap.getFloat("volume", eventData.volume);
                    event.balance = eventMap.getFloat("balance", eventData.balance);
                }
                timeline.setFrame(frame, event);
                eventMap = eventMap.next;
                ++frame;
            }
            timelines.add(timeline);
        }
        timelines.shrink();
        duration = 0.0f;
        items = timelines.items;
        i = 0;
        n = timelines.size;
        while (i < n) {
            duration = Math.max(duration, ((Animation.Timeline)items[i]).getDuration());
            ++i;
        }
        skeletonData.animations.add(new Animation(name, timelines, duration));
    }

    private Animation.Timeline readTimeline(JsonValue keyMap, Animation.CurveTimeline1 timeline, float defaultValue, float scale) {
        float time = keyMap.getFloat("time", 0.0f);
        float value = keyMap.getFloat("value", defaultValue) * scale;
        int bezier = 0;
        int frame = 0;
        while (true) {
            timeline.setFrame(frame, time, value);
            JsonValue nextMap = keyMap.next;
            if (nextMap == null) break;
            float time2 = nextMap.getFloat("time", 0.0f);
            float value2 = nextMap.getFloat("value", defaultValue) * scale;
            JsonValue curve = keyMap.get("curve");
            if (curve != null) {
                bezier = this.readCurve(curve, timeline, bezier, frame, 0, time, time2, value, value2, scale);
            }
            time = time2;
            value = value2;
            keyMap = nextMap;
            ++frame;
        }
        timeline.shrink(bezier);
        return timeline;
    }

    private Animation.Timeline readTimeline(JsonValue keyMap, Animation.CurveTimeline2 timeline, String name1, String name2, float defaultValue, float scale) {
        float time = keyMap.getFloat("time", 0.0f);
        float value1 = keyMap.getFloat(name1, defaultValue) * scale;
        float value2 = keyMap.getFloat(name2, defaultValue) * scale;
        int bezier = 0;
        int frame = 0;
        while (true) {
            timeline.setFrame(frame, time, value1, value2);
            JsonValue nextMap = keyMap.next;
            if (nextMap == null) break;
            float time2 = nextMap.getFloat("time", 0.0f);
            float nvalue1 = nextMap.getFloat(name1, defaultValue) * scale;
            float nvalue2 = nextMap.getFloat(name2, defaultValue) * scale;
            JsonValue curve = keyMap.get("curve");
            if (curve != null) {
                bezier = this.readCurve(curve, timeline, bezier, frame, 0, time, time2, value1, nvalue1, scale);
                bezier = this.readCurve(curve, timeline, bezier, frame, 1, time, time2, value2, nvalue2, scale);
            }
            time = time2;
            value1 = nvalue1;
            value2 = nvalue2;
            keyMap = nextMap;
            ++frame;
        }
        timeline.shrink(bezier);
        return timeline;
    }

    int readCurve(JsonValue curve, Animation.CurveTimeline timeline, int bezier, int frame, int value, float time1, float time2, float value1, float value2, float scale) {
        if (curve.isString()) {
            if (value != 0) {
                timeline.setStepped(frame);
            }
        } else {
            curve = curve.get(value << 2);
            float cx1 = curve.asFloat();
            curve = curve.next;
            float cy1 = curve.asFloat() * scale;
            curve = curve.next;
            float cx2 = curve.asFloat();
            curve = curve.next;
            float cy2 = curve.asFloat() * scale;
            this.setBezier(timeline, frame, value, bezier++, time1, value1, cx1, cy1, cx2, cy2, time2, value2);
        }
        return bezier;
    }

    void setBezier(Animation.CurveTimeline timeline, int frame, int value, int bezier, float time1, float value1, float cx1, float cy1, float cx2, float cy2, float time2, float value2) {
        timeline.setBezier(bezier, frame, value, time1, value1, cx1, cy1, cx2, cy2, time2, value2);
    }

    static class LinkedMesh {
        String parent;
        String skin;
        int slotIndex;
        MeshAttachment mesh;
        boolean inheritDeform;

        public LinkedMesh(MeshAttachment mesh, String skin, int slotIndex, String parent, boolean inheritDeform) {
            this.mesh = mesh;
            this.skin = skin;
            this.slotIndex = slotIndex;
            this.parent = parent;
            this.inheritDeform = inheritDeform;
        }
    }
}

