
#include "applicationclass.h"

#define kAPPLICATION_ID_PROPERTY_PRIVATEDATA                    0
#define kAPPLICATION_NUM_PROPERTY_IDENTIFIERS                   1

#define kAPPLICATION_ID_METHOD_CREATEAPPLICATION               0
#define kAPPLICATION_ID_METHOD_DESTROYAPPLICATION              1
#define kAPPLICATION_ID_METHOD_SHOW                             2
#define kAPPLICATION_ID_METHOD_HIDE                             3
#define kAPPLICATION_NUM_METHOD_IDENTIFIERS              		4


static  bool            v_bAPPLICATIONIdentifiersInitialized = false;

static  NPIdentifier    v_APPLICATIONPropertyIdentifiers[kAPPLICATION_NUM_PROPERTY_IDENTIFIERS];
static  const NPUTF8 *  v_APPLICATIONPropertyNames[kAPPLICATION_NUM_PROPERTY_IDENTIFIERS] = {
    "privateData"
};

static  NPIdentifier    v_APPLICATIONMethodIdentifiers[kAPPLICATION_NUM_METHOD_IDENTIFIERS];
static  const NPUTF8 *  v_APPLICATIONMethodNames[kAPPLICATION_NUM_METHOD_IDENTIFIERS] = {
    "createApplication",
    "destroyApplication",
    "show",
    "hide"
};


static  void    APPLICATIONinitializeIdentifiers(void)
{
    sBrowserFuncs->getstringidentifiers( v_APPLICATIONPropertyNames, kAPPLICATION_NUM_PROPERTY_IDENTIFIERS, v_APPLICATIONPropertyIdentifiers );
    sBrowserFuncs->getstringidentifiers( v_APPLICATIONMethodNames,   kAPPLICATION_NUM_METHOD_IDENTIFIERS,   v_APPLICATIONMethodIdentifiers );
}

NPClass  stAPPLICATIONclass;
NPClass* pAPPLICATIONclass = NULL;

NPClass* fillAPPLICATIONpclass(void)
{
    TRACEINFO;
    if (pAPPLICATIONclass == NULL)
    {
        stAPPLICATIONclass.allocate          = APPLICATION_Allocate;
        stAPPLICATIONclass.deallocate        = APPLICATION_Deallocate;
        stAPPLICATIONclass.invalidate        = APPLICATION_Invalidate;
        stAPPLICATIONclass.hasMethod         = APPLICATION_HasMethod;
        stAPPLICATIONclass.invoke            = APPLICATION_Invoke;
        stAPPLICATIONclass.invokeDefault     = APPLICATION_InvokeDefault;
        stAPPLICATIONclass.hasProperty       = APPLICATION_HasProperty;
        stAPPLICATIONclass.getProperty       = APPLICATION_GetProperty;
        stAPPLICATIONclass.setProperty       = APPLICATION_SetProperty;
        stAPPLICATIONclass.removeProperty    = APPLICATION_RemoveProperty;
        stAPPLICATIONclass.enumerate         = APPLICATION_Enumerate;
        pAPPLICATIONclass = &stAPPLICATIONclass;
    }

    return pAPPLICATIONclass;
}


NPObject *          APPLICATION_Allocate(NPP npp, NPClass *theClass)
{
    TRACEINFO;

    NPObject* newapplication = NULL;
    if (!v_bAPPLICATIONIdentifiersInitialized)
    {
        v_bAPPLICATIONIdentifiersInitialized = true;
        APPLICATIONinitializeIdentifiers();
    }

    newapplication = malloc(sizeof(NPObject));

    return newapplication;
}

  void        APPLICATION_Deallocate(NPObject* obj)
{
    TRACEINFO;
    free(obj);
    return;
}

  void        APPLICATION_Invalidate(NPObject* obj)
{
    TRACEINFO;
    return;
}

  bool        APPLICATION_HasMethod(NPObject* obj, NPIdentifier name)
{
    TRACEINFO;

    bool result = false;
    int i = 0;
    NPUTF8* utf8methodname = (char*)sBrowserFuncs->utf8fromidentifier(name);
    while ((i < kAPPLICATION_NUM_METHOD_IDENTIFIERS) && (result == false))
    {
        if ( name == v_APPLICATIONMethodIdentifiers[i] )
        {
            result= true;
        }
        i++;
    }
	printf("\tAPPLICATION has method \"%s\" : %s \n", utf8methodname, booltostr(result));

    return result;
}

bool        APPLICATION_Invoke(NPObject* obj, NPIdentifier name, const NPVariant* args, uint32_t argCount, NPVariant* result)
{
    TRACEINFO;
	bool fctresult = false;
    if (name == v_APPLICATIONMethodIdentifiers[kAPPLICATION_ID_METHOD_CREATEAPPLICATION])
    {
		APPLICATION_Invoke_CreateApplication(obj, args, argCount);
		fctresult = true;
    }
    else if (name == v_APPLICATIONMethodIdentifiers[kAPPLICATION_ID_METHOD_DESTROYAPPLICATION])
    {
		APPLICATION_Invoke_DestroyApplication(obj, args, argCount);
		fctresult = true;
    }
    else if (name == v_APPLICATIONMethodIdentifiers[kAPPLICATION_ID_METHOD_HIDE])
    {
		APPLICATION_Invoke_Hide(obj, args, argCount);
		fctresult = true;
    }
	else if (name == v_APPLICATIONMethodIdentifiers[kAPPLICATION_ID_METHOD_SHOW])
    {
		APPLICATION_Invoke_Show(obj, args, argCount);
		fctresult = true;
    }
    else
    {
        printf("%s : method not found\n",__FUNCTION__);
        fctresult = false;
    }
    return fctresult;
}

 bool        APPLICATION_InvokeDefault(NPObject *npobj, const NPVariant *args, uint32_t argCount, NPVariant *result)
{
    TRACEINFO;
    return true;
}

  bool        APPLICATION_HasProperty(NPObject* obj, NPIdentifier name)
{
    TRACEINFO;
    bool result = false;
    NPUTF8* utf8propertyname = (char*)sBrowserFuncs->utf8fromidentifier(name);

    int i = 0;
    while ((i < kAPPLICATION_NUM_PROPERTY_IDENTIFIERS) && (result == false))
    {
        if ( name == v_APPLICATIONPropertyIdentifiers[i] )
        {
            result= true;
        }
        i++;
    }

    printf("\tAPPLICATION has property \"%s\" : %s \n", utf8propertyname, booltostr(result));
    return result;
}

  bool        APPLICATION_GetProperty(NPObject* obj, NPIdentifier name, NPVariant* result)
{
    TRACEINFO;
    return true;
}

  bool        APPLICATION_SetProperty(NPObject *obj, NPIdentifier name, const NPVariant *value)
{
    TRACEINFO;
    return true;
}

 bool        APPLICATION_RemoveProperty(NPObject *npobj, NPIdentifier name)
{
    TRACEINFO;
    return true;
}


 bool        APPLICATION_Enumerate(NPObject *npobj, NPIdentifier **value, uint32_t *count)
{
    TRACEINFO;
    return true;
}

/** implementation **/

void APPLICATION_Invoke_CreateApplication(NPObject* obj,const NPVariant* args, uint32_t argCount)
{
	TRACEINFO;
	NOTIMPLEMENTED;
}

void APPLICATION_Invoke_DestroyApplication(NPObject* obj,const NPVariant* args, uint32_t argCount)
{
	TRACEINFO;
	NOTIMPLEMENTED;
}

void APPLICATION_Invoke_Show(NPObject* obj,const NPVariant* args, uint32_t argCount)
{
	TRACEINFO;
	NOTIMPLEMENTED;
}

void APPLICATION_Invoke_Hide(NPObject* obj,const NPVariant* args, uint32_t argCount)
{
	TRACEINFO;
	NOTIMPLEMENTED;
}
