/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.PluginRequests;

public class BuildDefinition {
    @Nullable
    private final String name;
    @Nullable
    private final File buildRootDir;
    private final StartParameter startParameter;
    private final PluginRequests injectedSettingsPlugins;
    private final PublicBuildPath fromBuild;

    private BuildDefinition(@Nullable String name, @Nullable File buildRootDir, StartParameter startParameter, PluginRequests injectedSettingsPlugins, @Nullable PublicBuildPath fromBuild) {
        this.name = name;
        this.buildRootDir = buildRootDir;
        this.startParameter = startParameter;
        this.injectedSettingsPlugins = injectedSettingsPlugins;
        this.fromBuild = fromBuild;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public File getBuildRootDir() {
        return this.buildRootDir;
    }

    @Nullable
    public PublicBuildPath getFromBuild() {
        return this.fromBuild;
    }

    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    public PluginRequests getInjectedPluginRequests() {
        return this.injectedSettingsPlugins;
    }

    public static BuildDefinition fromStartParameterForBuild(StartParameter startParameter, @Nullable String name, File buildRootDir, PublicBuildPath fromBuild) {
        return BuildDefinition.fromStartParameterForBuild(startParameter, name, buildRootDir, DefaultPluginRequests.EMPTY, fromBuild);
    }

    public static BuildDefinition fromStartParameterForBuild(StartParameter startParameter, @Nullable String name, File buildRootDir, PluginRequests pluginRequests, PublicBuildPath fromBuild) {
        return new BuildDefinition(name, buildRootDir, BuildDefinition.configure(startParameter, buildRootDir), pluginRequests, fromBuild);
    }

    private static StartParameter configure(StartParameter startParameter, File buildRootDir) {
        StartParameter includedBuildStartParam = startParameter.newBuild();
        includedBuildStartParam.setCurrentDir(buildRootDir);
        includedBuildStartParam.setSearchUpwards(false);
        includedBuildStartParam.setConfigureOnDemand(false);
        includedBuildStartParam.setInitScripts(startParameter.getInitScripts());
        return includedBuildStartParam;
    }

    public static BuildDefinition fromStartParameter(StartParameter startParameter, @Nullable PublicBuildPath fromBuild) {
        return new BuildDefinition(null, null, startParameter, DefaultPluginRequests.EMPTY, fromBuild);
    }

    public BuildDefinition newInstance() {
        return new BuildDefinition(this.name, this.buildRootDir, this.startParameter.newInstance(), this.injectedSettingsPlugins, this.fromBuild);
    }
}

