/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;

public class GraphAggregator<N> {
    private final CachingDirectedGraphWalker<N, N> graphWalker;

    public GraphAggregator(DirectedGraph<N, ?> graph) {
        this.graphWalker = new CachingDirectedGraphWalker(new ConnectedNodesAsValuesDirectedGraph(graph));
    }

    public Result<N> group(Collection<? extends N> startNodes, Collection<? extends N> allNodes) {
        HashMap<N, Set<N>> reachableByNode = new HashMap<N, Set<N>>();
        LinkedHashSet<N> topLevelNodes = new LinkedHashSet<N>(allNodes);
        for (N node : allNodes) {
            Set<N> reachableNodes = this.graphWalker.add(node).findValues();
            reachableByNode.put(node, reachableNodes);
            topLevelNodes.removeAll(reachableNodes);
        }
        topLevelNodes.addAll(startNodes);
        HashMap nodes = new HashMap();
        for (Object node : topLevelNodes) {
            nodes.put(node, this.calculateReachableNodes(reachableByNode, node, topLevelNodes));
        }
        return new Result<N>(nodes, topLevelNodes);
    }

    private Set<N> calculateReachableNodes(Map<N, Set<N>> nodes, N node, Set<N> topLevelNodes) {
        Set<N> reachableNodes = nodes.get(node);
        reachableNodes.add(node);
        LinkedHashSet<N> reachableStartNodes = new LinkedHashSet<N>(topLevelNodes);
        reachableStartNodes.retainAll(reachableNodes);
        reachableStartNodes.remove(node);
        for (Object startNode : reachableStartNodes) {
            reachableNodes.removeAll(this.calculateReachableNodes(nodes, startNode, topLevelNodes));
        }
        return reachableNodes;
    }

    private static class ConnectedNodesAsValuesDirectedGraph<N>
    implements DirectedGraph<N, N> {
        private final DirectedGraph<N, ?> graph;

        private ConnectedNodesAsValuesDirectedGraph(DirectedGraph<N, ?> graph) {
            this.graph = graph;
        }

        @Override
        public void getNodeValues(N node, Collection<? super N> values, Collection<? super N> connectedNodes) {
            LinkedHashSet edges = new LinkedHashSet();
            this.graph.getNodeValues(node, new ArrayList(), edges);
            values.addAll(edges);
            connectedNodes.addAll(edges);
        }
    }

    public static class Result<N> {
        private final Map<N, Set<N>> nodes;
        private final Set<N> topLevelNodes;

        public Result(Map<N, Set<N>> nodes, Set<N> topLevelNodes) {
            this.nodes = nodes;
            this.topLevelNodes = topLevelNodes;
        }

        public Set<N> getNodes(N startNode) {
            return this.nodes.get(startNode);
        }

        public Set<N> getTopLevelNodes() {
            return this.topLevelNodes;
        }
    }
}

