/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class CompositeResolvedArtifactSet
implements ResolvedArtifactSet {
    private final List<ResolvedArtifactSet> sets;

    private CompositeResolvedArtifactSet(List<ResolvedArtifactSet> sets) {
        this.sets = sets;
    }

    public static ResolvedArtifactSet of(Collection<? extends ResolvedArtifactSet> sets) {
        ArrayList<ResolvedArtifactSet> filtered = new ArrayList<ResolvedArtifactSet>(sets.size());
        for (ResolvedArtifactSet resolvedArtifactSet : sets) {
            if (resolvedArtifactSet == ResolvedArtifactSet.EMPTY) continue;
            filtered.add(resolvedArtifactSet);
        }
        if (filtered.isEmpty()) {
            return EMPTY;
        }
        if (filtered.size() == 1) {
            return (ResolvedArtifactSet)filtered.get(0);
        }
        return new CompositeResolvedArtifactSet(filtered);
    }

    public static boolean visitHierarchy(ResolvedArtifactSet rootArtifactSet, ResolvedArtifactSetVisitor visitor) {
        ArrayDeque<ResolvedArtifactSet> queue = new ArrayDeque<ResolvedArtifactSet>();
        queue.add(rootArtifactSet);
        ResolvedArtifactSet artifactSet;
        while ((artifactSet = (ResolvedArtifactSet)queue.poll()) != null) {
            if (!visitor.visitArtifactSet(artifactSet)) {
                return false;
            }
            if (!(artifactSet instanceof CompositeResolvedArtifactSet)) continue;
            queue.addAll(((CompositeResolvedArtifactSet)artifactSet).sets);
        }
        return true;
    }

    @Override
    public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
        ArrayList<ResolvedArtifactSet.Completion> results = new ArrayList<ResolvedArtifactSet.Completion>(this.sets.size());
        for (ResolvedArtifactSet set : this.sets) {
            results.add(set.startVisit(actions, listener));
        }
        return new CompositeResult(results);
    }

    @Override
    public void collectBuildDependencies(BuildDependenciesVisitor visitor) {
        for (ResolvedArtifactSet set : this.sets) {
            set.collectBuildDependencies(visitor);
        }
    }

    private static class CompositeResult
    implements ResolvedArtifactSet.Completion {
        private final List<ResolvedArtifactSet.Completion> results;

        CompositeResult(List<ResolvedArtifactSet.Completion> results) {
            this.results = results;
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            for (ResolvedArtifactSet.Completion result : this.results) {
                result.visit(visitor);
            }
        }
    }

    public static interface ResolvedArtifactSetVisitor {
        public boolean visitArtifactSet(ResolvedArtifactSet var1);
    }
}

