/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.progress.BuildOperationState;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.process.internal.health.memory.JvmMemoryStatus;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerDaemonProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WorkerDaemonClient
implements Worker,
Stoppable {
    private final DaemonForkOptions forkOptions;
    private final WorkerDaemonProcess<ActionExecutionSpec> workerDaemonProcess;
    private final WorkerProcess workerProcess;
    private final LogLevel logLevel;
    private int uses;

    public WorkerDaemonClient(DaemonForkOptions forkOptions, WorkerDaemonProcess<ActionExecutionSpec> workerDaemonProcess, WorkerProcess workerProcess, LogLevel logLevel) {
        this.forkOptions = forkOptions;
        this.workerDaemonProcess = workerDaemonProcess;
        this.workerProcess = workerProcess;
        this.logLevel = logLevel;
    }

    @Override
    public DefaultWorkResult execute(ActionExecutionSpec spec, WorkerLeaseRegistry.WorkerLease parentWorkerWorkerLease, BuildOperationState parentBuildOperation) {
        return this.execute(spec);
    }

    @Override
    public DefaultWorkResult execute(ActionExecutionSpec spec) {
        ++this.uses;
        return this.workerDaemonProcess.execute(spec);
    }

    public boolean isCompatibleWith(DaemonForkOptions required) {
        return this.forkOptions.isCompatibleWith(required);
    }

    JvmMemoryStatus getJvmMemoryStatus() {
        return this.workerProcess.getJvmMemoryStatus();
    }

    public void stop() {
        this.workerDaemonProcess.stop();
    }

    DaemonForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public int getUses() {
        return this.uses;
    }

    public KeepAliveMode getKeepAliveMode() {
        return this.forkOptions.getKeepAliveMode();
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }
}

