/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.util.JBHiDPIScaledImage;

public class RetinaImage {
    @NotNull
    public static Image createFrom(Image image, int scale, ImageObserver observer) {
        Image image2 = RetinaImage.createFrom(image, (float)scale, observer);
        if (image2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/RetinaImage", "createFrom"));
        }
        return image2;
    }

    @NotNull
    public static Image createFrom(Image image, float scale, ImageObserver observer) {
        int w = image.getWidth(observer);
        int h = image.getHeight(observer);
        JBHiDPIScaledImage hidpi = new JBHiDPIScaledImage(image, (int)((float)w / scale), (int)((float)h / scale), 2);
        if (SystemInfo.isAppleJvm) {
            Graphics2D g = (Graphics2D)((Image)hidpi).getGraphics();
            g.scale(1.0f / scale, 1.0f / scale);
            g.drawImage(image, 0, 0, null);
            g.dispose();
        }
        JBHiDPIScaledImage jBHiDPIScaledImage = hidpi;
        if (jBHiDPIScaledImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/RetinaImage", "createFrom"));
        }
        return jBHiDPIScaledImage;
    }

    @NotNull
    public static BufferedImage create(int width, int height, int type2) {
        JBHiDPIScaledImage jBHiDPIScaledImage = new JBHiDPIScaledImage(width, height, type2);
        if (jBHiDPIScaledImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/RetinaImage", "create"));
        }
        return jBHiDPIScaledImage;
    }
}

