/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.configuration.ScriptTarget;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ScriptBlock;
import org.gradle.groovy.scripts.internal.StatementTransformer;
import org.gradle.internal.Factory;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.use.internal.PluginUseScriptBlockMetadataExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialPassStatementTransformer
implements StatementTransformer,
Factory<PluginRequests> {
    public static final String PLUGINS = "plugins";
    public static final String PLUGIN_MANAGEMENT = "pluginManagement";
    private final ScriptTarget scriptTarget;
    private final List<String> scriptBlockNames;
    private final DocumentationRegistry documentationRegistry;
    private final PluginUseScriptBlockMetadataExtractor pluginBlockMetadataExtractor;
    private boolean seenNonClasspathStatement;
    private boolean seenPluginsBlock;
    private boolean seenPluginManagementBlock;
    private boolean seenClasspathBlock;

    public InitialPassStatementTransformer(ScriptSource scriptSource, ScriptTarget scriptTarget, DocumentationRegistry documentationRegistry) {
        this.scriptTarget = scriptTarget;
        this.scriptBlockNames = Arrays.asList(scriptTarget.getClasspathBlockName(), PLUGINS, PLUGIN_MANAGEMENT);
        this.documentationRegistry = documentationRegistry;
        this.pluginBlockMetadataExtractor = new PluginUseScriptBlockMetadataExtractor(scriptSource, documentationRegistry);
    }

    public Statement transform(SourceUnit sourceUnit, Statement statement) {
        ScriptBlock scriptBlock = AstUtils.detectScriptBlock((Statement)statement, this.scriptBlockNames);
        if (scriptBlock == null) {
            this.seenNonClasspathStatement = true;
            return null;
        }
        if (scriptBlock.getName().equals(PLUGINS)) {
            String failMessage = null;
            if (!this.scriptTarget.getSupportsPluginsBlock()) {
                failMessage = this.pluginBlockMetadataExtractor.formatErrorMessage("Only Project build scripts can contain plugins {} blocks");
            } else {
                this.seenPluginsBlock = true;
                if (this.seenNonClasspathStatement) {
                    failMessage = String.format(this.pluginBlockMetadataExtractor.formatErrorMessage("only %s {} and other %s {} script blocks are allowed before %s {} blocks, no other statements are allowed"), this.scriptTarget.getClasspathBlockName(), PLUGINS, PLUGINS);
                } else {
                    this.pluginBlockMetadataExtractor.extract(sourceUnit, scriptBlock);
                }
            }
            if (failMessage != null) {
                sourceUnit.getErrorCollector().addError(new SyntaxException(failMessage, statement.getLineNumber(), statement.getColumnNumber()), sourceUnit);
            }
            return null;
        }
        if (scriptBlock.getName().equals(PLUGIN_MANAGEMENT)) {
            String failureMessage = null;
            if (!this.scriptTarget.getSupportsPluginManagementBlock()) {
                failureMessage = "Only Settings scripts can contain a pluginManagement {} block.";
            } else if (this.seenClasspathBlock || this.seenNonClasspathStatement || this.seenPluginsBlock) {
                failureMessage = String.format("The %s {} block must appear before any other statements in the script.", PLUGIN_MANAGEMENT);
            } else if (this.seenPluginManagementBlock) {
                failureMessage = String.format("At most, one %s {} block may appear in the script.", PLUGIN_MANAGEMENT);
            }
            if (failureMessage != null) {
                sourceUnit.getErrorCollector().addError(new SyntaxException(this.makePluginManagementError(failureMessage), statement.getLineNumber(), statement.getColumnNumber()), sourceUnit);
            }
            this.seenPluginManagementBlock = true;
            return statement;
        }
        if (this.seenPluginsBlock) {
            String message = String.format(this.pluginBlockMetadataExtractor.formatErrorMessage("all %s {} blocks must appear before any %s {} blocks in the script"), this.scriptTarget.getClasspathBlockName(), PLUGINS);
            sourceUnit.getErrorCollector().addError(new SyntaxException(message, statement.getLineNumber(), statement.getColumnNumber()), sourceUnit);
        }
        this.seenClasspathBlock = true;
        return statement;
    }

    private String makePluginManagementError(String failureMessage) {
        return String.format("%s%n%nSee %s for information on the pluginManagement {} block%n%n", failureMessage, this.documentationRegistry.getDocumentationFor(PLUGINS, "sec:plugin_management"));
    }

    public PluginRequests create() {
        return this.pluginBlockMetadataExtractor.getPluginRequests();
    }
}

