/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils.mutator;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.Mutator;

public final class LastExpressionMutator {
    @NotNull
    private final Mutator mutator;

    public static JsStatement mutateLastExpression(@NotNull JsNode node, @NotNull Mutator mutator) {
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(0);
        }
        if (mutator == null) {
            LastExpressionMutator.$$$reportNull$$$0(1);
        }
        return JsAstUtils.convertToStatement(new LastExpressionMutator(mutator).apply(node));
    }

    private LastExpressionMutator(@NotNull Mutator mutator) {
        if (mutator == null) {
            LastExpressionMutator.$$$reportNull$$$0(2);
        }
        this.mutator = mutator;
    }

    @NotNull
    private JsNode apply(@NotNull JsNode node) {
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(3);
        }
        if (node instanceof JsBlock) {
            JsNode jsNode = this.applyToBlock((JsBlock)node);
            if (jsNode == null) {
                LastExpressionMutator.$$$reportNull$$$0(4);
            }
            return jsNode;
        }
        if (node instanceof JsIf) {
            JsNode jsNode = this.applyToIf((JsIf)node);
            if (jsNode == null) {
                LastExpressionMutator.$$$reportNull$$$0(5);
            }
            return jsNode;
        }
        if (node instanceof JsTry) {
            JsNode jsNode = this.applyToTry((JsTry)node);
            if (jsNode == null) {
                LastExpressionMutator.$$$reportNull$$$0(6);
            }
            return jsNode;
        }
        if (node instanceof JsExpressionStatement) {
            JsNode jsNode = this.applyToStatement((JsExpressionStatement)node);
            if (jsNode == null) {
                LastExpressionMutator.$$$reportNull$$$0(7);
            }
            return jsNode;
        }
        JsNode jsNode = this.mutator.mutate(node);
        if (jsNode == null) {
            LastExpressionMutator.$$$reportNull$$$0(8);
        }
        return jsNode;
    }

    @NotNull
    private JsNode applyToStatement(@NotNull JsExpressionStatement node) {
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(9);
        }
        JsStatement jsStatement = JsAstUtils.convertToStatement(this.apply(node.getExpression()));
        if (jsStatement == null) {
            LastExpressionMutator.$$$reportNull$$$0(10);
        }
        return jsStatement;
    }

    @NotNull
    private JsNode applyToIf(@NotNull JsIf node) {
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(11);
        }
        node.setThenStatement(JsAstUtils.convertToStatement(this.apply(node.getThenStatement())));
        JsStatement elseStmt = node.getElseStatement();
        if (elseStmt != null) {
            node.setElseStatement(JsAstUtils.convertToStatement(this.apply(elseStmt)));
        }
        JsIf jsIf = node;
        if (jsIf == null) {
            LastExpressionMutator.$$$reportNull$$$0(12);
        }
        return jsIf;
    }

    @NotNull
    private JsNode applyToTry(@NotNull JsTry node) {
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(13);
        }
        this.applyToBlock(node.getTryBlock());
        for (JsCatch jsCatch : node.getCatches()) {
            this.applyToBlock(jsCatch.getBody());
        }
        JsTry jsTry = node;
        if (jsTry == null) {
            LastExpressionMutator.$$$reportNull$$$0(14);
        }
        return jsTry;
    }

    @NotNull
    private JsNode applyToBlock(@NotNull JsBlock node) {
        List<JsStatement> statements;
        if (node == null) {
            LastExpressionMutator.$$$reportNull$$$0(15);
        }
        if ((statements = node.getStatements()).isEmpty()) {
            JsBlock jsBlock = node;
            if (jsBlock == null) {
                LastExpressionMutator.$$$reportNull$$$0(16);
            }
            return jsBlock;
        }
        int size = statements.size();
        statements.set(size - 1, JsAstUtils.convertToStatement(this.apply(statements.get(size - 1))));
        JsBlock jsBlock = node;
        if (jsBlock == null) {
            LastExpressionMutator.$$$reportNull$$$0(17);
        }
        return jsBlock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToIf";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToTry";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mutateLastExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyToStatement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyToIf";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyToTry";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyToBlock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

