/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.ExperimentalFeatures;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.artifact.MavenArtifactNotationParserFactory;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenProjectIdentity;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.publish.maven.tasks.PublishToMavenLocal;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;

@Incubating
public class MavenPublishPlugin
implements Plugin<Project> {
    public static final String PUBLISH_LOCAL_LIFECYCLE_TASK_NAME = "publishToMavenLocal";
    private final Instantiator instantiator;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final FileCollectionFactory fileCollectionFactory;
    private final ExperimentalFeatures experimentalFeatures;

    @Inject
    public MavenPublishPlugin(Instantiator instantiator, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, ExperimentalFeatures experimentalFeatures) {
        this.instantiator = instantiator;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
        this.projectDependencyResolver = projectDependencyResolver;
        this.fileCollectionFactory = fileCollectionFactory;
        this.experimentalFeatures = experimentalFeatures;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        TaskContainer tasks = project.getTasks();
        Task publishLocalLifecycleTask = tasks.create(PUBLISH_LOCAL_LIFECYCLE_TASK_NAME);
        publishLocalLifecycleTask.setDescription("Publishes all Maven publications produced by this project to the local Maven cache.");
        publishLocalLifecycleTask.setGroup("publishing");
        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

            public void execute(PublishingExtension extension) {
                extension.getPublications().registerFactory(MavenPublication.class, (NamedDomainObjectFactory)new MavenPublicationFactory(MavenPublishPlugin.this.dependencyMetaDataProvider, MavenPublishPlugin.this.instantiator, MavenPublishPlugin.this.fileResolver));
            }
        });
    }

    private class MavenPublicationFactory
    implements NamedDomainObjectFactory<MavenPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final FileResolver fileResolver;

        private MavenPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, FileResolver fileResolver) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.fileResolver = fileResolver;
        }

        public MavenPublication create(String name) {
            Module module = this.dependencyMetaDataProvider.getModule();
            DefaultMavenProjectIdentity projectIdentity = new DefaultMavenProjectIdentity(module.getGroup(), module.getName(), module.getVersion());
            NotationParser<Object, MavenArtifact> artifactNotationParser = new MavenArtifactNotationParserFactory(this.instantiator, this.fileResolver).create();
            return (MavenPublication)this.instantiator.newInstance(DefaultMavenPublication.class, new Object[]{name, projectIdentity, artifactNotationParser, this.instantiator, MavenPublishPlugin.this.projectDependencyResolver, MavenPublishPlugin.this.fileCollectionFactory, MavenPublishPlugin.this.experimentalFeatures});
        }
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Mutate
        public void realizePublishingTasks(ModelMap<Task> tasks, PublishingExtension extension, @Path(value="buildDir") File buildDir) {
            PublicationContainer publications = extension.getPublications();
            Task publishLifecycleTask = (Task)tasks.get("publish");
            Task publishLocalLifecycleTask = (Task)tasks.get(MavenPublishPlugin.PUBLISH_LOCAL_LIFECYCLE_TASK_NAME);
            NamedDomainObjectSet mavenPublications = publications.withType(MavenPublicationInternal.class);
            ArrayList<Publication> asPublication = new ArrayList<Publication>((Collection<Publication>)publications);
            for (MavenPublicationInternal publication : mavenPublications) {
                String publicationName = publication.getName();
                this.createGenerateMetadataTask(tasks, publication, asPublication, buildDir);
                this.createGeneratePomTask(tasks, publication, buildDir);
                this.createLocalInstallTask(tasks, publishLocalLifecycleTask, publication);
                this.createPublishTasksForEachMavenRepo(tasks, extension, publishLifecycleTask, publication);
            }
        }

        private void createPublishTasksForEachMavenRepo(ModelMap<Task> tasks, PublishingExtension extension, Task publishLifecycleTask, final MavenPublicationInternal publication) {
            final String publicationName = publication.getName();
            for (final MavenArtifactRepository repository : extension.getRepositories().withType(MavenArtifactRepository.class)) {
                final String repositoryName = repository.getName();
                String publishTaskName = "publish" + StringUtils.capitalize((String)publicationName) + "PublicationTo" + StringUtils.capitalize((String)repositoryName) + "Repository";
                tasks.create(publishTaskName, PublishToMavenRepository.class, (Action)new Action<PublishToMavenRepository>(){

                    public void execute(PublishToMavenRepository publishTask) {
                        publishTask.setPublication(publication);
                        publishTask.setRepository(repository);
                        publishTask.setGroup("publishing");
                        publishTask.setDescription("Publishes Maven publication '" + publicationName + "' to Maven repository '" + repositoryName + "'.");
                    }
                });
                publishLifecycleTask.dependsOn(new Object[]{publishTaskName});
            }
        }

        private void createLocalInstallTask(ModelMap<Task> tasks, Task publishLocalLifecycleTask, final MavenPublicationInternal publication) {
            final String publicationName = publication.getName();
            String installTaskName = "publish" + StringUtils.capitalize((String)publicationName) + "PublicationToMavenLocal";
            tasks.create(installTaskName, PublishToMavenLocal.class, (Action)new Action<PublishToMavenLocal>(){

                public void execute(PublishToMavenLocal publishLocalTask) {
                    publishLocalTask.setPublication(publication);
                    publishLocalTask.setGroup("publishing");
                    publishLocalTask.setDescription("Publishes Maven publication '" + publicationName + "' to the local Maven repository.");
                }
            });
            publishLocalLifecycleTask.dependsOn(new Object[]{installTaskName});
        }

        private void createGeneratePomTask(ModelMap<Task> tasks, final MavenPublicationInternal publication, final File buildDir) {
            final String publicationName = publication.getName();
            String descriptorTaskName = "generatePomFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
            tasks.create(descriptorTaskName, GenerateMavenPom.class, (Action)new Action<GenerateMavenPom>(){

                public void execute(GenerateMavenPom generatePomTask) {
                    generatePomTask.setDescription("Generates the Maven POM file for publication '" + publicationName + "'.");
                    generatePomTask.setGroup("publishing");
                    generatePomTask.setPom(publication.getPom());
                    generatePomTask.setDestination(new File(buildDir, "publications/" + publication.getName() + "/pom-default.xml"));
                }
            });
            publication.setPomFile(((Task)tasks.get(descriptorTaskName)).getOutputs().getFiles());
        }

        private void createGenerateMetadataTask(ModelMap<Task> tasks, final MavenPublicationInternal publication, final List<Publication> publications, final File buildDir) {
            if (!publication.canPublishModuleMetadata()) {
                return;
            }
            final String publicationName = publication.getName();
            String descriptorTaskName = "generateMetadataFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
            tasks.create(descriptorTaskName, GenerateModuleMetadata.class, (Action)new Action<GenerateModuleMetadata>(){

                public void execute(GenerateModuleMetadata generateTask) {
                    generateTask.setDescription("Generates the Gradle metadata file for publication '" + publicationName + "'.");
                    generateTask.setGroup("publishing");
                    generateTask.getPublication().set((Object)publication);
                    generateTask.getPublications().set((Object)publications);
                    generateTask.getOutputFile().set(new File(buildDir, "publications/" + publication.getName() + "/module.json"));
                }
            });
            GenerateModuleMetadata generatorTask = (GenerateModuleMetadata)tasks.get(descriptorTaskName);
            MavenArtifact metadataFile = publication.artifact(generatorTask.getOutputFile());
            metadataFile.setExtension("module");
        }
    }
}

