/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.plugins;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.artifacts.dependencies.DefaultSelfResolvingDependency;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftComponent;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.plugins.SwiftExecutablePlugin;
import org.gradle.language.swift.plugins.SwiftLibraryPlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.language.swift.tasks.UnexportMainSymbol;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.tasks.LinkMachOBundle;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.MacOSSdkPlatformPathLocator;
import org.gradle.nativeplatform.test.xctest.tasks.InstallXCTestBundle;
import org.gradle.nativeplatform.test.xctest.tasks.XcTest;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.ToolChain;
import org.gradle.testing.base.plugins.TestingBasePlugin;
import org.gradle.util.GUtil;

@Incubating
public class XCTestConventionPlugin
implements Plugin<ProjectInternal> {
    private final MacOSSdkPlatformPathLocator sdkPlatformPathLocator;

    @Inject
    public XCTestConventionPlugin(MacOSSdkPlatformPathLocator sdkPlatformPathLocator) {
        this.sdkPlatformPathLocator = sdkPlatformPathLocator;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(TestingBasePlugin.class);
        project.getPluginManager().apply(SwiftBasePlugin.class);
        TaskContainerInternal tasks = project.getTasks();
        SwiftXCTestSuite testSuite = XCTestConventionPlugin.createTestSuite((Project)project);
        Task testingTask = XCTestConventionPlugin.createTestingTask((Project)project, testSuite);
        this.configureTestSuiteBuildingTasks(project, testSuite);
        this.configureTestSuiteWithTestedComponentWhenAvailable((Project)project);
        Task test = tasks.create(testSuite.getName());
        test.dependsOn(new Object[]{testingTask});
        if (OperatingSystem.current().isMacOsX() || OperatingSystem.current().isLinux()) {
            Task check = tasks.getByName("check");
            check.dependsOn(new Object[]{test});
        }
    }

    private void configureTestSuiteBuildingTasks(ProjectInternal project, SwiftXCTestSuite testSuite) {
        Object install;
        AbstractLinkTask link;
        TaskContainerInternal tasks = project.getTasks();
        final SwiftXCTestBinary binary = testSuite.getTestExecutable();
        final Names names = Names.of((String)binary.getName());
        SwiftCompile compile = (SwiftCompile)tasks.getByName(names.getCompileTaskName("swift"));
        DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
        ModelRegistry modelRegistry = project.getModelRegistry();
        NativeToolChain toolChain = (NativeToolChain)((NativeToolChainRegistryInternal)modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)currentPlatform);
        if (OperatingSystem.current().isMacOsX()) {
            compile.getCompilerArgs().addAll(project.provider((Callable)new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                    return Arrays.asList("-parse-as-library", "-g", "-F" + frameworkDir.getAbsolutePath());
                }
            }));
            link = (AbstractLinkTask)tasks.create(names.getTaskName("link"), LinkMachOBundle.class);
            link.getLinkerArgs().set(project.provider((Callable)new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                    return Lists.newArrayList((Object[])new String[]{"-F" + frameworkDir.getAbsolutePath(), "-framework", "XCTest", "-Xlinker", "-rpath", "-Xlinker", "@executable_path/../Frameworks", "-Xlinker", "-rpath", "-Xlinker", "@loader_path/../Frameworks"});
                }
            }));
            install = (InstallXCTestBundle)tasks.create(names.getTaskName("install"), InstallXCTestBundle.class);
            ((InstallXCTestBundle)((Object)install)).getBundleBinaryFile().set(binary.getExecutableTestFile());
            ((InstallXCTestBundle)((Object)install)).getInstallDirectory().set(project.getLayout().getBuildDirectory().dir("install/" + names.getDirName()));
            ((DefaultSwiftXCTestBinary)binary).getInstallDirectory().set((Provider)((InstallXCTestBundle)((Object)install)).getInstallDirectory());
            ((DefaultSwiftXCTestBinary)binary).getRunScriptFile().set(((InstallXCTestBundle)((Object)install)).getRunScriptFile());
        } else {
            link = (AbstractLinkTask)tasks.create(names.getTaskName("link"), LinkExecutable.class);
            install = (InstallExecutable)tasks.create(names.getTaskName("install"), InstallExecutable.class);
            install.setPlatform((NativePlatform)currentPlatform);
            install.setToolChain((ToolChain)toolChain);
            install.getInstallDirectory().set(project.getLayout().getBuildDirectory().dir("install/" + names.getDirName()));
            install.getSourceFile().set(binary.getExecutableTestFile());
            install.lib((Object)binary.getRuntimeLibraries());
            ((DefaultSwiftXCTestBinary)binary).getInstallDirectory().set((Provider)install.getInstallDirectory());
            ((DefaultSwiftXCTestBinary)binary).getRunScriptFile().set(install.getRunScriptFile());
        }
        link.source((Object)binary.getObjects());
        link.lib((Object)binary.getLinkLibraries());
        final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
        Provider exeLocation = project.getLayout().getBuildDirectory().file(project.getProviders().provider((Callable)new Callable<String>(){

            @Override
            public String call() {
                return toolProvider.getExecutableName("exe/" + names.getDirName() + (String)binary.getModule().get());
            }
        }));
        link.setOutputFile(exeLocation);
        link.setTargetPlatform((NativePlatform)currentPlatform);
        link.setToolChain(toolChain);
        link.setDebuggable(binary.isDebuggable());
        ((DefaultSwiftXCTestBinary)binary).getExecutableTestFile().set((Provider)link.getBinaryFile());
    }

    private static Task createTestingTask(Project project, SwiftXCTestSuite testSuite) {
        TaskContainer tasks = project.getTasks();
        XcTest testTask = (XcTest)tasks.create("xcTest", XcTest.class);
        SwiftXCTestBinary binary = testSuite.getDevelopmentBinary();
        testTask.getTestInstallDirectory().set(binary.getInstallDirectory());
        testTask.getRunScriptFile().set(binary.getRunScriptFile());
        testTask.getWorkingDirectory().set(binary.getInstallDirectory());
        testTask.setGroup("verification");
        testTask.setDescription("Executes XCTest suites");
        return testTask;
    }

    private static SwiftXCTestSuite createTestSuite(Project project) {
        SwiftXCTestSuite testSuite = (SwiftXCTestSuite)project.getObjects().newInstance(DefaultSwiftXCTestSuite.class, new Object[]{"test", project.getConfigurations()});
        project.getExtensions().add(SwiftXCTestSuite.class, "xctest", (Object)testSuite);
        project.getComponents().add((Object)testSuite);
        project.getComponents().add((Object)testSuite.getDevelopmentBinary());
        testSuite.getModule().set((Object)GUtil.toCamelCase((CharSequence)(project.getName() + "Test")));
        return testSuite;
    }

    private void configureTestSuiteWithTestedComponentWhenAvailable(Project project) {
        project.getPlugins().withType(SwiftExecutablePlugin.class, XCTestConventionPlugin.configureTestSuiteWithTestedComponent(project));
        project.getPlugins().withType(SwiftLibraryPlugin.class, XCTestConventionPlugin.configureTestSuiteWithTestedComponent(project));
    }

    private static <T> Action<? super T> configureTestSuiteWithTestedComponent(final Project project) {
        return new Action<T>(){

            public void execute(T plugin) {
                TaskContainer tasks = project.getTasks();
                SwiftComponent testedComponent = (SwiftComponent)project.getComponents().withType(SwiftComponent.class).getByName("main");
                SwiftXCTestSuite testSuite = (SwiftXCTestSuite)project.getExtensions().getByType(SwiftXCTestSuite.class);
                ((DefaultSwiftXCTestSuite)testSuite).getTestedComponent().set((Object)testedComponent);
                SwiftCompile compileMain = (SwiftCompile)tasks.withType(SwiftCompile.class).getByName("compileDebugSwift");
                SwiftCompile compileTest = (SwiftCompile)tasks.withType(SwiftCompile.class).getByName("compileTestSwift");
                compileTest.getModules().from(new Object[]{compileMain.getModuleFile()});
                testSuite.getImplementationDependencies().extendsFrom(new Configuration[]{testedComponent.getImplementationDependencies()});
                ((Configuration)testSuite.getDevelopmentBinary().getCompileModules()).getDependencies().add((Object)new DefaultSelfResolvingDependency((FileCollectionInternal)project.files(new Object[]{((DefaultSwiftBinary)testedComponent.getDevelopmentBinary()).getModuleFile().map((Transformer)new Transformer<File, RegularFile>(){

                    public File transform(RegularFile regularFile) {
                        return regularFile.getAsFile().getParentFile();
                    }
                })})));
                AbstractLinkTask linkTest = (AbstractLinkTask)tasks.withType(AbstractLinkTask.class).getByName("linkTest");
                if (testedComponent instanceof SwiftApplication) {
                    final UnexportMainSymbol relocate = (UnexportMainSymbol)tasks.create("relocateMainForTest", UnexportMainSymbol.class);
                    relocate.source(new Object[]{testedComponent.getDevelopmentBinary().getObjects()});
                    linkTest.source((Object)relocate);
                    linkTest.source((Object)testedComponent.getDevelopmentBinary().getObjects().filter((Spec)new Spec<File>(){

                        public boolean isSatisfiedBy(File objectFile) {
                            return !objectFile.equals(relocate.getMainObject());
                        }
                    }));
                } else {
                    linkTest.source((Object)testedComponent.getDevelopmentBinary().getObjects());
                }
            }
        };
    }
}

