/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListProperty<T>
implements PropertyInternal<List<T>>,
ListProperty<T> {
    private static final Provider<ImmutableList<Object>> EMPTY_LIST = Providers.of(ImmutableList.of());
    private Provider<? extends List<T>> provider = (Provider)Cast.uncheckedCast(EMPTY_LIST);

    public DefaultListProperty(Class<T> elementType) {
    }

    public void add(T element) {
        this.addAll(Providers.of(ImmutableList.of((Object)Preconditions.checkNotNull(element, (Object)"Cannot add a null value to a list property."))));
    }

    public void add(Provider<? extends T> providerOfElement) {
        this.addAll(providerOfElement.map(new Transformer<Iterable<T>, T>(){

            public Iterable<T> transform(T t) {
                return ImmutableList.of(t);
            }
        }));
    }

    public void addAll(final Provider<? extends Iterable<T>> providerOfElements) {
        this.provider = this.provider.map(new Transformer<List<T>, List<T>>(){

            public List<T> transform(List<T> ts) {
                return ImmutableList.builder().addAll(ts).addAll((Iterable)providerOfElements.get()).build();
            }
        });
    }

    @Override
    @Nullable
    public Class<List<T>> getType() {
        return null;
    }

    public boolean isPresent() {
        return this.provider.isPresent();
    }

    public List<T> get() {
        return ImmutableList.copyOf((Collection)((Collection)this.provider.get()));
    }

    @Nullable
    public List<T> getOrNull() {
        return this.getOrElse(null);
    }

    public List<T> getOrElse(List<T> defaultValue) {
        List list = (List)this.provider.getOrNull();
        if (list == null) {
            return defaultValue;
        }
        return ImmutableList.copyOf((Collection)list);
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            if (object != null && !(object instanceof List)) {
                throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", List.class.getName(), object.getClass().getName()));
            }
            this.set((List)object);
        }
    }

    public void set(@Nullable List<T> value) {
        if (value == null) {
            this.provider = Providers.notDefined();
            return;
        }
        this.provider = Providers.of(value);
    }

    public void set(Provider<? extends List<T>> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        this.provider = provider;
    }

    @Override
    public <S> ProviderInternal<S> map(Transformer<? extends S, ? super List<T>> transformer) {
        return new TransformBackedProvider<S, List<T>>(transformer, this){

            @Override
            protected S map(List<T> v) {
                Object result = super.map(v);
                if (result instanceof List) {
                    return ImmutableList.copyOf((Collection)((List)result));
                }
                return result;
            }
        };
    }
}

