/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.execution.taskgraph.DefaultTaskPlanExecutor;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ParallelismConfigurationManager;
import org.gradle.internal.work.WorkerLeaseService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPlanExecutorFactory
implements Factory<TaskPlanExecutor> {
    private final ParallelismConfigurationManager parallelismConfigurationManager;
    private final ExecutorFactory executorFactory;
    private final WorkerLeaseService workerLeaseService;
    private final List<TaskPlanExecutor> taskPlanExecutors = Lists.newArrayList();

    public TaskPlanExecutorFactory(ParallelismConfigurationManager parallelismConfigurationManager, ExecutorFactory executorFactory, WorkerLeaseService workerLeaseService) {
        this.parallelismConfigurationManager = parallelismConfigurationManager;
        this.executorFactory = executorFactory;
        this.workerLeaseService = workerLeaseService;
    }

    public TaskPlanExecutor create() {
        int parallelThreads = this.parallelismConfigurationManager.getParallelismConfiguration().getMaxWorkerCount();
        if (parallelThreads < 1) {
            throw new IllegalStateException(String.format("Cannot create executor for requested number of worker threads: %s.", parallelThreads));
        }
        DefaultTaskPlanExecutor taskPlanExecutor = new DefaultTaskPlanExecutor(this.parallelismConfigurationManager.getParallelismConfiguration(), this.executorFactory, this.workerLeaseService);
        this.taskPlanExecutors.add(taskPlanExecutor);
        return taskPlanExecutor;
    }
}

