/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.List;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;

public class DependencyMetadataAdapter
implements DependencyMetadata {
    private final List<ModuleDependencyMetadata> container;
    private final int originalIndex;

    public DependencyMetadataAdapter(List<ModuleDependencyMetadata> container, int originalIndex) {
        this.container = container;
        this.originalIndex = originalIndex;
    }

    private ModuleDependencyMetadata getOriginalMetadata() {
        return this.container.get(this.originalIndex);
    }

    private void updateMetadata(ModuleDependencyMetadata modifiedMetadata) {
        this.container.set(this.originalIndex, modifiedMetadata);
    }

    public String getGroup() {
        return this.getOriginalMetadata().getSelector().getGroup();
    }

    public String getName() {
        return this.getOriginalMetadata().getSelector().getModule();
    }

    public String getVersion() {
        return this.getOriginalMetadata().getSelector().getVersion();
    }

    public DependencyMetadata setVersion(String version) {
        ModuleDependencyMetadata dependencyMetadata = this.getOriginalMetadata().withRequestedVersion(new DefaultMutableVersionConstraint(version));
        this.updateMetadata(dependencyMetadata);
        return this;
    }
}

