/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.definition;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.api.initialization.definition.InjectedPluginDependencies;
import org.gradle.api.initialization.definition.InjectedPluginDependency;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.definition.DefaultInjectedPluginDependency;
import org.gradle.initialization.definition.SelfResolvingPluginRequest;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.use.PluginId;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInjectedPluginDependencies
implements InjectedPluginDependencies {
    private final List<DefaultInjectedPluginDependency> dependencies = Lists.newArrayList();
    private final ClassLoaderScope classLoaderScope;

    public DefaultInjectedPluginDependencies(ClassLoaderScope classLoaderScope) {
        this.classLoaderScope = classLoaderScope;
    }

    public InjectedPluginDependency id(String id) {
        DefaultInjectedPluginDependency injectedPluginDependency = new DefaultInjectedPluginDependency(id);
        this.dependencies.add(injectedPluginDependency);
        return injectedPluginDependency;
    }

    public PluginRequests getRequests() {
        if (this.dependencies.isEmpty()) {
            return DefaultPluginRequests.EMPTY;
        }
        return new DefaultPluginRequests(this.listPluginRequests());
    }

    List<PluginRequestInternal> listPluginRequests() {
        List pluginRequests = CollectionUtils.collect(this.dependencies, (Transformer)new Transformer<PluginRequestInternal, DefaultInjectedPluginDependency>(){

            public PluginRequestInternal transform(DefaultInjectedPluginDependency original) {
                return new SelfResolvingPluginRequest(original.getId(), DefaultInjectedPluginDependencies.this.classLoaderScope);
            }
        });
        Map groupedById = CollectionUtils.groupBy((Iterable)pluginRequests, (Transformer)new Transformer<PluginId, PluginRequestInternal>(){

            public PluginId transform(PluginRequestInternal pluginRequest) {
                return pluginRequest.getId();
            }
        });
        for (PluginId key : groupedById.keySet()) {
            Collection pluginRequestsForId = (Collection)groupedById.get(key);
            if (pluginRequestsForId.size() <= 1) continue;
            PluginRequestInternal first = (PluginRequestInternal)pluginRequests.get(0);
            throw new InvalidPluginRequestException(first, "Plugin with id '" + key + "' was already requested.");
        }
        return pluginRequests;
    }
}

