/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import java.io.File;
import java.util.List;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.SettingsLoader;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.plugin.management.internal.DefaultPluginRequests;

public class CompositeBuildSettingsLoader
implements SettingsLoader {
    private final SettingsLoader delegate;
    private final NestedBuildFactory nestedBuildFactory;
    private final BuildStateRegistry buildRegistry;

    public CompositeBuildSettingsLoader(SettingsLoader delegate, NestedBuildFactory nestedBuildFactory, BuildStateRegistry buildRegistry) {
        this.delegate = delegate;
        this.nestedBuildFactory = nestedBuildFactory;
        this.buildRegistry = buildRegistry;
    }

    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        SettingsInternal settings = this.delegate.findAndLoadSettings(gradle);
        List<IncludedBuildSpec> includedBuilds = settings.getIncludedBuilds();
        if (!includedBuilds.isEmpty()) {
            for (IncludedBuildSpec includedBuildSpec : includedBuilds) {
                IncludedBuildState includedBuild = this.buildRegistry.addExplicitBuild(BuildDefinition.fromStartParameterForBuild(gradle.getStartParameter(), includedBuildSpec.rootDir, DefaultPluginRequests.EMPTY), this.nestedBuildFactory);
                includedBuildSpec.configurer.execute((Object)includedBuild.getModel());
            }
        }
        for (File rootDir : gradle.getStartParameter().getIncludedBuilds()) {
            this.buildRegistry.addExplicitBuild(BuildDefinition.fromStartParameterForBuild(gradle.getStartParameter(), rootDir, DefaultPluginRequests.EMPTY), this.nestedBuildFactory);
        }
        this.buildRegistry.registerRootBuild(settings);
        return settings;
    }
}

