/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiAnonymousClassImpl
extends PsiClassImpl
implements PsiAnonymousClass {
    private SoftReference<PsiClassType> myCachedBaseType;

    public PsiAnonymousClassImpl(PsiClassStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANONYMOUS_CLASS);
    }

    public PsiAnonymousClassImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiAnonymousClassImpl clone = (PsiAnonymousClassImpl)super.clone();
        clone.myCachedBaseType = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    @Override
    public PsiExpressionList getArgumentList() {
        return (PsiExpressionList)this.getNode().findChildByRoleAsPsiElement(73);
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        PsiElement baseRef = this.getFirstChild();
        assert (baseRef instanceof PsiJavaCodeReferenceElement) : this.getText();
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)baseRef;
        if (psiJavaCodeReferenceElement == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(0);
        }
        return psiJavaCodeReferenceElement;
    }

    @Override
    @NotNull
    public PsiClassType getBaseClassType() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub == null) {
            this.myCachedBaseType = null;
            PsiClassType psiClassType = this.getTypeByTree();
            if (psiClassType == null) {
                PsiAnonymousClassImpl.$$$reportNull$$$0(1);
            }
            return psiClassType;
        }
        PsiClassType type2 = SoftReference.dereference(this.myCachedBaseType);
        if (type2 != null) {
            PsiClassType psiClassType = type2;
            if (psiClassType == null) {
                PsiAnonymousClassImpl.$$$reportNull$$$0(2);
            }
            return psiClassType;
        }
        if (!this.isInQualifiedNew() && !this.isDiamond(stub)) {
            String refText = stub.getBaseClassReferenceText();
            assert (refText != null) : stub;
            PsiElementFactory factory2 = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
            PsiElement context = this.calcBasesResolveContext(PsiNameHelper.getShortClassName(refText), this.getExtendsList());
            try {
                PsiJavaCodeReferenceElement ref = factory2.createReferenceFromText(refText, context);
                ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(1);
                type2 = factory2.createType(ref);
            }
            catch (IncorrectOperationException e) {
                type2 = PsiType.getJavaLangObject(this.getManager(), this.getResolveScope());
            }
            this.myCachedBaseType = new SoftReference<PsiClassType>(type2);
            PsiClassType psiClassType = type2;
            if (psiClassType == null) {
                PsiAnonymousClassImpl.$$$reportNull$$$0(3);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = this.getTypeByTree();
        if (psiClassType == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(4);
        }
        return psiClassType;
    }

    private boolean isDiamond(PsiClassStub stub) {
        String referenceText;
        if (PsiUtil.isLanguageLevel9OrHigher(this) && (referenceText = stub.getBaseClassReferenceText()) != null && referenceText.endsWith(">")) {
            return StringUtil.trimEnd(referenceText, ">").trim().endsWith("<");
        }
        return false;
    }

    private PsiClassType getTypeByTree() {
        return JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createType(this.getBaseClassReference());
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(5);
        }
        return name.equals("final");
    }

    @Override
    public PsiReferenceList getExtendsList() {
        return null;
    }

    @Override
    public PsiReferenceList getImplementsList() {
        return null;
    }

    @Override
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(6);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAnonymousClass(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiAnonymousClass";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(7);
        }
        if (state2 == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(8);
        }
        if (place == null) {
            PsiAnonymousClassImpl.$$$reportNull$$$0(9);
        }
        if (lastParent instanceof PsiExpressionList) {
            return true;
        }
        if (lastParent instanceof PsiJavaCodeReferenceElement && lastParent.getParent() == this && lastParent == this.getBaseClassReference()) {
            return true;
        }
        return super.processDeclarations(processor, state2, lastParent, place);
    }

    @Override
    public boolean isInQualifiedNew() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAnonymousInQualifiedNew();
        }
        PsiElement parent2 = this.getParent();
        return parent2 instanceof PsiNewExpression && ((PsiNewExpression)parent2).getQualifier() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnonymousClassImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseClassReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseClassType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnonymousClassImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

