/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;

public class MavenUniqueSnapshotComponentIdentifier
extends DefaultModuleComponentIdentifier {
    private final String timestamp;
    private final int hashCode;

    public MavenUniqueSnapshotComponentIdentifier(String group, String module, String version, String timestamp) {
        super(group, module, version);
        this.timestamp = timestamp;
        this.hashCode = super.hashCode() + timestamp.hashCode();
    }

    public MavenUniqueSnapshotComponentIdentifier(ModuleComponentIdentifier baseIdentifier, String timestamp) {
        super(baseIdentifier.getGroup(), baseIdentifier.getModule(), baseIdentifier.getVersion());
        this.timestamp = timestamp;
        this.hashCode = super.hashCode() + timestamp.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && ((MavenUniqueSnapshotComponentIdentifier)o).timestamp.equals(this.timestamp);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getDisplayName() {
        return String.format("%s:%s:%s:%s", this.getGroup(), this.getModule(), this.getSnapshotVersion(), this.timestamp);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getSnapshotVersion() {
        return this.getVersion().replace(this.timestamp, "SNAPSHOT");
    }

    public ModuleComponentIdentifier getSnapshotComponent() {
        return DefaultModuleComponentIdentifier.newId(this.getGroup(), this.getModule(), this.getSnapshotVersion());
    }

    public String getTimestampedVersion() {
        return this.getVersion().replace("SNAPSHOT", this.timestamp);
    }
}

