/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.DisplayName;

public class DefaultModuleComponentIdentifier
implements ModuleComponentIdentifier,
DisplayName {
    private final String group;
    private final String module;
    private final String version;
    private final int hashCode;

    public DefaultModuleComponentIdentifier(String group, String module, String version) {
        assert (group != null) : "group cannot be null";
        assert (module != null) : "module cannot be null";
        assert (version != null) : "version cannot be null";
        this.group = group;
        this.module = module;
        this.version = version;
        this.hashCode = Objects.hashCode((Object[])new Object[]{version, module, group});
    }

    public String getDisplayName() {
        StringBuilder builder = new StringBuilder(this.group.length() + this.module.length() + this.version.length() + 2);
        builder.append(this.group);
        builder.append(":");
        builder.append(this.module);
        builder.append(":");
        builder.append(this.version);
        return builder.toString();
    }

    public String getCapitalizedDisplayName() {
        return this.getDisplayName();
    }

    public String getGroup() {
        return this.group;
    }

    public String getModule() {
        return this.module;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleComponentIdentifier that = (DefaultModuleComponentIdentifier)o;
        if (!this.group.equals(that.group)) {
            return false;
        }
        if (!this.module.equals(that.module)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ModuleComponentIdentifier newId(String group, String name, String version) {
        return new DefaultModuleComponentIdentifier(group, name, version);
    }

    public static ModuleComponentIdentifier newId(ModuleVersionIdentifier moduleVersionIdentifier) {
        return new DefaultModuleComponentIdentifier(moduleVersionIdentifier.getGroup(), moduleVersionIdentifier.getName(), moduleVersionIdentifier.getVersion());
    }
}

