/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress.util;

import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.impl.CoreProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.util.ProgressIndicatorStacked;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.ui.mac.foundation.MacUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class AbstractProgressIndicatorBase
extends UserDataHolderBase
implements ProgressIndicatorStacked {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.progress.util.ProgressIndicatorBase");
    private volatile String myText;
    private volatile double myFraction;
    private volatile String myText2;
    private volatile boolean myCanceled;
    private volatile boolean myRunning;
    private volatile boolean myFinished;
    private volatile boolean myIndeterminate = Registry.is("ide.progress.indeterminate.by.default", true);
    private volatile Object myMacActivity;
    private volatile boolean myShouldStartActivity = true;
    ProgressIndicator myModalityProgress;
    private volatile ModalityState myModalityState = ModalityState.NON_MODAL;
    private volatile int myNonCancelableSectionCount;
    private static final Set<Class> ourReportedReuseExceptions = ContainerUtil.newConcurrentSet();

    @Override
    public synchronized void start() {
        LOG.assertTrue(!this.isRunning(), "Attempt to start ProgressIndicator which is already running");
        if (this.myFinished) {
            if (this.myCanceled && !this.isReuseable() && ourReportedReuseExceptions.add(this.getClass())) {
                LOG.error("Attempt to start ProgressIndicator which is cancelled and already stopped:" + this + "," + this.getClass());
            }
            this.myCanceled = false;
            this.myFinished = false;
        }
        this.myText = "";
        this.myFraction = 0.0;
        this.myText2 = "";
        this.startSystemActivity();
        this.myRunning = true;
    }

    protected boolean isReuseable() {
        return false;
    }

    @Override
    public synchronized void stop() {
        LOG.assertTrue(this.myRunning, "stop() should be called only if start() called before");
        this.myRunning = false;
        this.myFinished = true;
        this.stopSystemActivity();
    }

    private void startSystemActivity() {
        this.myMacActivity = this.myShouldStartActivity ? MacUtil.wakeUpNeo(this.toString()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopSystemActivity() {
        Object macActivity = this.myMacActivity;
        if (macActivity != null) {
            Object object = macActivity;
            synchronized (object) {
                MacUtil.matrixHasYou(macActivity);
                this.myMacActivity = null;
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.myRunning;
    }

    @Override
    public void cancel() {
        this.myCanceled = true;
        this.stopSystemActivity();
        if (ApplicationManager.getApplication() != null) {
            ProgressManager.canceled(this);
        }
    }

    @Override
    public boolean isCanceled() {
        return this.myCanceled;
    }

    @Override
    public void checkCanceled() {
        this.throwIfCanceled();
        if (CoreProgressManager.runCheckCanceledHooks(this)) {
            this.throwIfCanceled();
        }
    }

    private void throwIfCanceled() {
        if (this.isCanceled() && this.isCancelable()) {
            Throwable trace = this.getCancellationTrace();
            throw trace instanceof ProcessCanceledException ? (ProcessCanceledException)trace : new ProcessCanceledException(trace);
        }
    }

    @Nullable
    protected Throwable getCancellationTrace() {
        if (this instanceof Disposable) {
            return ObjectUtils.tryCast(Disposer.getTree().getDisposalInfo((Disposable)((Object)this)), Throwable.class);
        }
        return null;
    }

    @Override
    public void setText(String text2) {
        this.myText = text2;
    }

    @Override
    public void setText2(String text2) {
        this.myText2 = text2;
    }

    protected boolean isCancelable() {
        return this.myNonCancelableSectionCount == 0 && !ProgressManager.getInstance().isInNonCancelableSection();
    }

    @Override
    public final boolean isModal() {
        return this.myModalityProgress != null;
    }

    @Override
    @NotNull
    public ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(0);
        }
        return modalityState;
    }

    @NonNls
    public String toString() {
        return "ProgressIndicator " + System.identityHashCode(this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/progress/util/AbstractProgressIndicatorBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/progress/util/AbstractProgressIndicatorBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextStack";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFractionStack";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText2Stack";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initStateFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

