/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Arrays;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.transform.DefaultTransformer;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.TransformerInvoker;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.model.internal.type.ModelType;

public class DefaultTransformationRegistration
implements VariantTransformRegistry.Registration {
    private final ImmutableAttributes from;
    private final ImmutableAttributes to;
    private final TransformationStep transformationStep;

    public static VariantTransformRegistry.Registration create(ImmutableAttributes from, ImmutableAttributes to, Class<? extends ArtifactTransform> implementation, Object[] params, IsolatableFactory isolatableFactory, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, InstantiatorFactory instantiatorFactory, TransformerInvoker transformerInvoker) {
        Isolatable paramsSnapshot;
        Hasher hasher = Hashing.newHasher();
        hasher.putString((CharSequence)implementation.getName());
        hasher.putHash(classLoaderHierarchyHasher.getClassLoaderHash(implementation.getClassLoader()));
        try {
            paramsSnapshot = isolatableFactory.isolate((Object)params);
        }
        catch (Exception e) {
            throw new VariantTransformConfigurationException(String.format("Could not snapshot configuration values for transform %s: %s", ModelType.of(implementation).getDisplayName(), Arrays.asList(params)), (Throwable)e);
        }
        paramsSnapshot.appendToHasher(hasher);
        DefaultTransformer transformer = new DefaultTransformer(implementation, (Isolatable<Object[]>)paramsSnapshot, hasher.hash(), instantiatorFactory, from);
        return new DefaultTransformationRegistration(from, to, new TransformationStep(transformer, transformerInvoker));
    }

    public DefaultTransformationRegistration(ImmutableAttributes from, ImmutableAttributes to, TransformationStep transformationStep) {
        this.from = from;
        this.to = to;
        this.transformationStep = transformationStep;
    }

    @Override
    public AttributeContainerInternal getFrom() {
        return this.from;
    }

    @Override
    public AttributeContainerInternal getTo() {
        return this.to;
    }

    @Override
    public TransformationStep getTransformationStep() {
        return this.transformationStep;
    }
}

