/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.locking.LockEntryFilter;

class LockEntryFilterFactory {
    private static final LockEntryFilter FILTERS_NONE = new LockEntryFilter(){

        public boolean isSatisfiedBy(ModuleComponentIdentifier element) {
            return false;
        }
    };
    private static final LockEntryFilter FILTERS_ALL = new LockEntryFilter(){

        public boolean isSatisfiedBy(ModuleComponentIdentifier element) {
            return true;
        }
    };
    private static final String WILDCARD_SUFFIX = "*";
    public static final String MODULE_SEPARATOR = ":";

    LockEntryFilterFactory() {
    }

    static LockEntryFilter forParameter(List<String> lockedDependenciesToUpdate) {
        if (lockedDependenciesToUpdate.isEmpty()) {
            return FILTERS_NONE;
        }
        HashSet<LockEntryFilter> lockEntryFilters = new HashSet<LockEntryFilter>();
        for (String lockExcludes : lockedDependenciesToUpdate) {
            for (String lockExclude : lockExcludes.split(",")) {
                String[] split = lockExclude.split(MODULE_SEPARATOR);
                LockEntryFilterFactory.validateNotation(lockExclude, split);
                lockEntryFilters.add(LockEntryFilterFactory.createFilter(split[0], split[1]));
            }
            if (!lockEntryFilters.isEmpty()) continue;
            LockEntryFilterFactory.throwInvalid(lockExcludes);
        }
        if (lockEntryFilters.size() == 1) {
            return (LockEntryFilter)lockEntryFilters.iterator().next();
        }
        return new AggregateLockEntryFilter(lockEntryFilters);
    }

    private static void throwInvalid(String lockExclude) {
        throw new IllegalArgumentException("Update lock format must be <group>:<artifact> but '" + lockExclude + "' is invalid.");
    }

    private static LockEntryFilter createFilter(String group, String module) {
        if (group.equals(WILDCARD_SUFFIX) && module.equals(WILDCARD_SUFFIX)) {
            return FILTERS_ALL;
        }
        return new GroupModuleLockEntryFilter(group, module);
    }

    private static void validateNotation(String lockExclude, String[] split) {
        if (split.length != 2) {
            LockEntryFilterFactory.throwInvalid(lockExclude);
        }
        String group = split[0];
        String module = split[1];
        if (group.contains(WILDCARD_SUFFIX) && !group.endsWith(WILDCARD_SUFFIX) || module.contains(WILDCARD_SUFFIX) && !module.endsWith(WILDCARD_SUFFIX)) {
            LockEntryFilterFactory.throwInvalid(lockExclude);
        }
    }

    private static class GroupModuleLockEntryFilter
    implements LockEntryFilter {
        private final String group;
        private final String module;

        private GroupModuleLockEntryFilter(String group, String module) {
            this.group = group;
            this.module = module;
        }

        public boolean isSatisfiedBy(ModuleComponentIdentifier id) {
            return this.matches(this.group, id.getGroup()) && this.matches(this.module, id.getModule());
        }

        private boolean matches(String test, String candidate) {
            if (test.endsWith(LockEntryFilterFactory.WILDCARD_SUFFIX)) {
                return candidate.startsWith(test.substring(0, test.length() - 1));
            }
            return candidate.equals(test);
        }
    }

    private static class AggregateLockEntryFilter
    implements LockEntryFilter {
        private final Set<LockEntryFilter> filters;

        private AggregateLockEntryFilter(Set<LockEntryFilter> filters) {
            this.filters = filters;
        }

        public boolean isSatisfiedBy(ModuleComponentIdentifier moduleComponentIdentifier) {
            for (LockEntryFilter filter : this.filters) {
                if (!filter.isSatisfiedBy(moduleComponentIdentifier)) continue;
                return true;
            }
            return false;
        }
    }
}

