/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.nativeplatform.internal.CompileTaskConfig;
import org.gradle.language.nativeplatform.internal.DependentSourceSetInternal;
import org.gradle.language.nativeplatform.internal.NativeLanguageTransform;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.tasks.PrefixHeaderFileGenerateTask;
import org.gradle.nativeplatform.toolchain.internal.PreCompiledHeader;

public class PCHCompileTaskConfig
extends CompileTaskConfig {
    public PCHCompileTaskConfig(NativeLanguageTransform<?> languageTransform, Class<? extends DefaultTask> taskType) {
        super(languageTransform, taskType);
    }

    @Override
    protected void configureCompileTask(AbstractNativeCompileTask task, NativeBinarySpecInternal binary, LanguageSourceSetInternal languageSourceSet) {
        final DependentSourceSetInternal sourceSet = (DependentSourceSetInternal)languageSourceSet;
        task.setDescription("Compiles a pre-compiled header for the " + sourceSet + " of " + binary);
        task.includes(sourceSet.getSource().getSourceDirectories());
        Project project = task.getProject();
        task.source(sourceSet.getPrefixHeaderFile());
        task.getObjectFileDir().set(new File(binary.getNamingScheme().getOutputDirectory(project.getBuildDir(), "objs"), languageSourceSet.getProjectScopedName() + "PCH"));
        task.dependsOn(new Object[]{project.getTasks().withType(PrefixHeaderFileGenerateTask.class).matching((Spec)new Spec<PrefixHeaderFileGenerateTask>(){

            public boolean isSatisfiedBy(PrefixHeaderFileGenerateTask prefixHeaderFileGenerateTask) {
                return prefixHeaderFileGenerateTask.getPrefixHeaderFile().equals(sourceSet.getPrefixHeaderFile());
            }
        })});
        binary.binaryInputs((FileCollection)task.getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
        PreCompiledHeader pch = (PreCompiledHeader)binary.getPrefixFileToPCH().get(sourceSet.getPrefixHeaderFile());
        pch.setPchObjects((FileCollection)task.getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.pch", "**/*.gch"})));
        pch.builtBy(new Object[]{task});
    }
}

