/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.serialization;

import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderCache;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderDetails;
import org.gradle.tooling.internal.provider.serialization.ClasspathInferer;
import org.gradle.tooling.internal.provider.serialization.ClientOwnedClassLoaderSpec;
import org.gradle.tooling.internal.provider.serialization.DeserializeMap;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.serialization.SerializeMap;

@ThreadSafe
public class ClientSidePayloadClassLoaderRegistry
implements PayloadClassLoaderRegistry {
    private static final short CLIENT_CLASS_LOADER_ID = 1;
    private final PayloadClassLoaderRegistry delegate;
    private final ClasspathInferer classpathInferer;
    private final ClassLoaderCache classLoaderCache;
    private final Lock lock = new ReentrantLock();
    private final Map<UUID, LocalClassLoaderMapping> classLoaders = new LinkedHashMap<UUID, LocalClassLoaderMapping>();

    public ClientSidePayloadClassLoaderRegistry(PayloadClassLoaderRegistry delegate, ClasspathInferer classpathInferer, ClassLoaderCache classLoaderCache) {
        this.delegate = delegate;
        this.classpathInferer = classpathInferer;
        this.classLoaderCache = classLoaderCache;
    }

    @Override
    public SerializeMap newSerializeSession() {
        final LinkedHashSet candidates = new LinkedHashSet();
        final LinkedHashSet classPath = new LinkedHashSet();
        final HashMap classLoaderIds = new HashMap();
        final HashMap classLoaderDetails = new HashMap();
        return new SerializeMap(){

            @Override
            public short visitClass(Class<?> target) {
                ClassLoader classLoader = target.getClassLoader();
                Short id = (Short)classLoaderIds.get(classLoader);
                if (id != null) {
                    return id;
                }
                ClassLoaderDetails details = ClientSidePayloadClassLoaderRegistry.this.classLoaderCache.maybeGetDetails(classLoader);
                if (details != null) {
                    id = (short)(classLoaderIds.size() + 1 + 1);
                    classLoaderIds.put(classLoader, id);
                    classLoaderDetails.put(id, details);
                    return id;
                }
                ClientSidePayloadClassLoaderRegistry.this.classpathInferer.getClassPathFor(target, classPath);
                candidates.add(target.getClassLoader());
                return 1;
            }

            @Override
            public void collectClassLoaderDefinitions(Map<Short, ClassLoaderDetails> details) {
                UUID uuid;
                ClientSidePayloadClassLoaderRegistry.this.lock.lock();
                try {
                    uuid = ClientSidePayloadClassLoaderRegistry.this.getUuidForLocalClassLoaders(candidates);
                }
                finally {
                    ClientSidePayloadClassLoaderRegistry.this.lock.unlock();
                }
                details.putAll(classLoaderDetails);
                details.put((short)1, new ClassLoaderDetails(uuid, new ClientOwnedClassLoaderSpec(new ArrayList<URL>(classPath))));
            }
        };
    }

    @Override
    public DeserializeMap newDeserializeSession() {
        final DeserializeMap deserializeMap = this.delegate.newDeserializeSession();
        return new DeserializeMap(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Class<?> resolveClass(ClassLoaderDetails classLoaderDetails, String className) throws ClassNotFoundException {
                Set candidates;
                ClientSidePayloadClassLoaderRegistry.this.lock.lock();
                try {
                    candidates = ClientSidePayloadClassLoaderRegistry.this.getClassLoaders(classLoaderDetails.uuid);
                }
                finally {
                    ClientSidePayloadClassLoaderRegistry.this.lock.unlock();
                }
                if (candidates != null) {
                    for (ClassLoader candidate : candidates) {
                        try {
                            return candidate.loadClass(className);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                    }
                    throw new UnsupportedOperationException("Unexpected class received in response.");
                }
                return deserializeMap.resolveClass(classLoaderDetails, className);
            }
        };
    }

    private Set<ClassLoader> getClassLoaders(UUID uuid) {
        LocalClassLoaderMapping localClassLoaderMapping = this.classLoaders.get(uuid);
        if (localClassLoaderMapping == null) {
            return null;
        }
        LinkedHashSet candidates = Sets.newLinkedHashSet();
        for (WeakReference reference : localClassLoaderMapping.classLoaders) {
            ClassLoader classLoader = (ClassLoader)reference.get();
            if (classLoader == null) continue;
            candidates.add(classLoader);
        }
        return candidates;
    }

    private UUID getUuidForLocalClassLoaders(Set<ClassLoader> candidates) {
        for (LocalClassLoaderMapping localClassLoaderMapping : new ArrayList<LocalClassLoaderMapping>(this.classLoaders.values())) {
            LinkedHashSet<ClassLoader> localCandidates = new LinkedHashSet<ClassLoader>();
            for (WeakReference reference : localClassLoaderMapping.classLoaders) {
                ClassLoader cl = (ClassLoader)reference.get();
                if (cl == null) continue;
                localCandidates.add(cl);
            }
            if (localCandidates.isEmpty()) {
                this.classLoaders.remove(localClassLoaderMapping.uuid);
                continue;
            }
            if (!localCandidates.equals(candidates)) continue;
            return localClassLoaderMapping.uuid;
        }
        LocalClassLoaderMapping details = new LocalClassLoaderMapping(UUID.randomUUID());
        for (ClassLoader candidate : candidates) {
            details.classLoaders.add(new WeakReference<ClassLoader>(candidate));
        }
        this.classLoaders.put(details.uuid, details);
        return details.uuid;
    }

    private static class LocalClassLoaderMapping {
        private final Set<WeakReference<ClassLoader>> classLoaders = Sets.newLinkedHashSet();
        private final UUID uuid;

        private LocalClassLoaderMapping(UUID uuid) {
            this.uuid = uuid;
        }
    }
}

