/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import org.jetbrains.kotlin.js.translate.callTranslator.DelegateIntrinsic;
import org.jetbrains.kotlin.js.translate.callTranslator.VariableAccessInfo;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0002H\u0016J\u0012\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u0002H\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/DelegatePropertyAccessIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/DelegateIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;", "()V", "canBeApply", "", "getArgs", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "js.translator"})
public final class DelegatePropertyAccessIntrinsic
implements DelegateIntrinsic<VariableAccessInfo> {
    public static final DelegatePropertyAccessIntrinsic INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canBeApply(@NotNull VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (!(CallInfoExtensionsKt.getVariableDescriptor($receiver) instanceof PropertyDescriptor)) return false;
        if (CallInfoExtensionsKt.isGetAccess($receiver)) return true;
        VariableDescriptor variableDescriptor = CallInfoExtensionsKt.getVariableDescriptor($receiver);
        if (variableDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
        }
        if (!((PropertyDescriptor)variableDescriptor).isVar()) return false;
        return true;
    }

    @Override
    @NotNull
    public List<JsExpression> getArgs(@NotNull VariableAccessInfo $receiver) {
        List<JsExpression> list2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (CallInfoExtensionsKt.isGetAccess($receiver)) {
            List<JsExpression> list3 = Collections.emptyList();
            list2 = list3;
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"Collections.emptyList<JsExpression>()");
        } else {
            JsExpression jsExpression = $receiver.getValue();
            if (jsExpression == null) {
                Intrinsics.throwNpe();
            }
            List<JsExpression> list4 = Collections.singletonList(jsExpression);
            list2 = list4;
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"Collections.singletonList(value!!)");
        }
        return list2;
    }

    @Override
    @NotNull
    public CallableDescriptor getDescriptor(@NotNull VariableAccessInfo $receiver) {
        CallableDescriptor callableDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        VariableDescriptor variableDescriptor = CallInfoExtensionsKt.getVariableDescriptor($receiver);
        if (variableDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
        }
        PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)variableDescriptor;
        if (CallInfoExtensionsKt.isGetAccess($receiver)) {
            PropertyGetterDescriptor propertyGetterDescriptor = propertyDescriptor2.getGetter();
            if (propertyGetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor, (String)"propertyDescriptor.getter!!");
            callableDescriptor = propertyGetterDescriptor;
        } else {
            PropertySetterDescriptor propertySetterDescriptor = propertyDescriptor2.getSetter();
            if (propertySetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor, (String)"propertyDescriptor.setter!!");
            callableDescriptor = propertySetterDescriptor;
        }
        return callableDescriptor;
    }

    private DelegatePropertyAccessIntrinsic() {
    }

    static {
        DelegatePropertyAccessIntrinsic delegatePropertyAccessIntrinsic;
        INSTANCE = delegatePropertyAccessIntrinsic = new DelegatePropertyAccessIntrinsic();
    }

    @Override
    @Nullable
    public JsExpression intrinsic(@NotNull VariableAccessInfo callInfo, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)callInfo, (String)"callInfo");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return DelegateIntrinsic.DefaultImpls.intrinsic(this, (CallInfo)callInfo, context);
    }
}

