/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultGroovySourceSet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.JavaPluginsHelper;
import org.gradle.api.plugins.internal.SourceSetUtil;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.GroovyRuntime;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.javadoc.Groovydoc;

public class GroovyBasePlugin
implements Plugin<Project> {
    public static final String GROOVY_RUNTIME_EXTENSION_NAME = "groovyRuntime";
    private final ObjectFactory objectFactory;
    private final ModuleRegistry moduleRegistry;
    private Project project;
    private GroovyRuntime groovyRuntime;

    @Inject
    public GroovyBasePlugin(ObjectFactory objectFactory, ModuleRegistry moduleRegistry) {
        this.objectFactory = objectFactory;
        this.moduleRegistry = moduleRegistry;
    }

    public void apply(Project project) {
        this.project = project;
        project.getPluginManager().apply(JavaBasePlugin.class);
        this.configureGroovyRuntimeExtension();
        this.configureCompileDefaults();
        this.configureSourceSetDefaults();
        this.configureGroovydoc();
    }

    private void configureGroovyRuntimeExtension() {
        this.groovyRuntime = (GroovyRuntime)this.project.getExtensions().create(GROOVY_RUNTIME_EXTENSION_NAME, GroovyRuntime.class, new Object[]{this.project});
    }

    private void configureCompileDefaults() {
        this.project.getTasks().withType(GroovyCompile.class).configureEach((Action)new Action<GroovyCompile>(){

            public void execute(final GroovyCompile compile) {
                compile.getConventionMapping().map("groovyClasspath", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() {
                        return GroovyBasePlugin.this.groovyRuntime.inferGroovyClasspath((Iterable<File>)compile.getClasspath());
                    }
                });
            }
        });
    }

    private void configureSourceSetDefaults() {
        ((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all((Action)new Action<SourceSet>(){

            public void execute(final SourceSet sourceSet) {
                final DefaultGroovySourceSet groovySourceSet = new DefaultGroovySourceSet("groovy", ((DefaultSourceSet)sourceSet).getDisplayName(), GroovyBasePlugin.this.objectFactory);
                new DslObject((Object)sourceSet).getConvention().getPlugins().put("groovy", groovySourceSet);
                groovySourceSet.getGroovy().srcDir((Object)("src/" + sourceSet.getName() + "/groovy"));
                sourceSet.getResources().getFilter().exclude((Spec)new Spec<FileTreeElement>(){

                    public boolean isSatisfiedBy(FileTreeElement element) {
                        return groovySourceSet.getGroovy().contains(element.getFile());
                    }
                });
                sourceSet.getAllJava().source(groovySourceSet.getGroovy());
                sourceSet.getAllSource().source(groovySourceSet.getGroovy());
                TaskProvider compileTask = GroovyBasePlugin.this.project.getTasks().register(sourceSet.getCompileTaskName("groovy"), GroovyCompile.class, (Action)new Action<GroovyCompile>(){

                    public void execute(GroovyCompile compile) {
                        SourceSetUtil.configureForSourceSet(sourceSet, groovySourceSet.getGroovy(), (AbstractCompile)compile, compile.getOptions(), GroovyBasePlugin.this.project);
                        compile.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
                        compile.setDescription("Compiles the " + sourceSet.getName() + " Groovy source.");
                        compile.setSource((FileTree)groovySourceSet.getGroovy());
                    }
                });
                SourceSetUtil.configureOutputDirectoryForSourceSet(sourceSet, groovySourceSet.getGroovy(), GroovyBasePlugin.this.project, (Provider<? extends AbstractCompile>)compileTask, (Provider<CompileOptions>)compileTask.map((Transformer)new Transformer<CompileOptions, GroovyCompile>(){

                    public CompileOptions transform(GroovyCompile groovyCompile) {
                        return groovyCompile.getOptions();
                    }
                }));
                if ("main".equals(sourceSet.getName())) {
                    GroovyBasePlugin.this.project.getPluginManager().withPlugin("java-library", (Action)new Action<AppliedPlugin>((Provider)compileTask){
                        final /* synthetic */ Provider val$compileTask;
                        {
                            this.val$compileTask = provider;
                        }

                        public void execute(AppliedPlugin plugin) {
                            Configuration apiElements = GroovyBasePlugin.this.project.getConfigurations().getByName(sourceSet.getApiElementsConfigurationName());
                            JavaPluginsHelper.registerClassesDirVariant((Provider<? extends AbstractCompile>)this.val$compileTask, GroovyBasePlugin.this.project.getObjects(), apiElements);
                        }
                    });
                }
                GroovyBasePlugin.this.project.getTasks().named(sourceSet.getClassesTaskName(), (Action)new Action<Task>((Provider)compileTask){
                    final /* synthetic */ Provider val$compileTask;
                    {
                        this.val$compileTask = provider;
                    }

                    public void execute(Task task) {
                        task.dependsOn(new Object[]{this.val$compileTask});
                    }
                });
            }
        });
    }

    private void configureGroovydoc() {
        this.project.getTasks().withType(Groovydoc.class).configureEach((Action)new Action<Groovydoc>(){

            public void execute(final Groovydoc groovydoc) {
                groovydoc.getConventionMapping().map("groovyClasspath", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        FileCollection groovyClasspath = GroovyBasePlugin.this.groovyRuntime.inferGroovyClasspath((Iterable<File>)groovydoc.getClasspath());
                        ConfigurableFileCollection jansi = GroovyBasePlugin.this.project.getObjects().fileCollection().from(new Object[]{GroovyBasePlugin.this.moduleRegistry.getExternalModule("jansi").getImplementationClasspath().getAsFiles()});
                        return groovyClasspath.plus((FileCollection)jansi);
                    }
                });
                groovydoc.getConventionMapping().map("destinationDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return new File(GroovyBasePlugin.this.java(GroovyBasePlugin.this.project.getConvention()).getDocsDir(), "groovydoc");
                    }
                });
                groovydoc.getConventionMapping().map("docTitle", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((ReportingExtension)GroovyBasePlugin.this.project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle();
                    }
                });
                groovydoc.getConventionMapping().map("windowTitle", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((ReportingExtension)GroovyBasePlugin.this.project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle();
                    }
                });
            }
        });
    }

    private JavaPluginConvention java(Convention convention) {
        return (JavaPluginConvention)convention.getPlugin(JavaPluginConvention.class);
    }
}

