/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import org.gradle.api.Describable;
import org.gradle.internal.change.CachingChangeContainer;
import org.gradle.internal.change.Change;
import org.gradle.internal.change.ChangeContainer;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.change.ErrorHandlingChangeContainer;
import org.gradle.internal.change.SummarizingChangeContainer;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.changes.ExecutionStateChangeDetector;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.ImplementationChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.history.changes.InputFileChanges;
import org.gradle.internal.execution.history.changes.InputValueChanges;
import org.gradle.internal.execution.history.changes.NonIncrementalInputChanges;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.execution.history.changes.PreviousSuccessChanges;
import org.gradle.internal.execution.history.changes.PropertyChanges;
import org.gradle.internal.execution.history.changes.RebuildExecutionStateChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;

public class DefaultExecutionStateChangeDetector
implements ExecutionStateChangeDetector {
    @Override
    public ExecutionStateChanges detectChanges(AfterPreviousExecutionState lastExecution, BeforeExecutionState thisExecution, Describable executable, boolean allowOverlappingOutputs, IncrementalInputProperties incrementalInputProperties) {
        boolean rebuildRequired;
        PreviousSuccessChanges previousSuccessState = new PreviousSuccessChanges(lastExecution.isSuccessful());
        ImplementationChanges implementationChanges = new ImplementationChanges(lastExecution.getImplementation(), lastExecution.getAdditionalImplementations(), thisExecution.getImplementation(), thisExecution.getAdditionalImplementations(), executable);
        PropertyChanges inputPropertyChanges = new PropertyChanges(lastExecution.getInputProperties(), thisExecution.getInputProperties(), "Input", executable);
        InputValueChanges inputPropertyValueChanges = new InputValueChanges(lastExecution.getInputProperties(), thisExecution.getInputProperties(), executable);
        PropertyChanges inputFilePropertyChanges = new PropertyChanges(lastExecution.getInputFileProperties(), thisExecution.getInputFileProperties(), "Input file", executable);
        InputFileChanges nonIncrementalInputFileChanges = incrementalInputProperties.nonIncrementalChanges(lastExecution.getInputFileProperties(), thisExecution.getInputFileProperties());
        InputFileChanges directIncrementalInputFileChanges = incrementalInputProperties.incrementalChanges(lastExecution.getInputFileProperties(), thisExecution.getInputFileProperties());
        InputFileChanges incrementalInputFileChanges = DefaultExecutionStateChangeDetector.errorHandling(executable, DefaultExecutionStateChangeDetector.caching(directIncrementalInputFileChanges));
        PropertyChanges outputFilePropertyChanges = new PropertyChanges(lastExecution.getOutputFileProperties(), thisExecution.getOutputFileProperties(), "Output", executable);
        OutputFileChanges outputFileChanges = new OutputFileChanges(lastExecution.getOutputFileProperties(), thisExecution.getOutputFileProperties(), allowOverlappingOutputs);
        ChangeContainer rebuildTriggeringChanges = DefaultExecutionStateChangeDetector.errorHandling(executable, (ChangeContainer)new SummarizingChangeContainer(new ChangeContainer[]{previousSuccessState, implementationChanges, inputPropertyChanges, inputPropertyValueChanges, outputFilePropertyChanges, outputFileChanges, inputFilePropertyChanges, nonIncrementalInputFileChanges}));
        ImmutableList.Builder builder = ImmutableList.builder();
        MessageCollectingChangeVisitor visitor = new MessageCollectingChangeVisitor((ImmutableCollection.Builder<String>)builder, 3);
        rebuildTriggeringChanges.accept((ChangeVisitor)visitor);
        ImmutableList rebuildReasons = builder.build();
        boolean bl = rebuildRequired = !rebuildReasons.isEmpty();
        if (!rebuildRequired) {
            incrementalInputFileChanges.accept(visitor);
        }
        ImmutableList allChangeMessages = builder.build();
        return rebuildRequired ? new NonIncrementalDetectedExecutionStateChanges((ImmutableList<String>)allChangeMessages, thisExecution.getInputFileProperties(), incrementalInputProperties) : new IncrementalDetectedExecutionStateChanges((ImmutableList<String>)allChangeMessages, thisExecution.getInputFileProperties(), incrementalInputFileChanges, incrementalInputProperties);
    }

    private static InputFileChanges caching(InputFileChanges wrapped) {
        CachingChangeContainer cachingChangeContainer = new CachingChangeContainer(3, (ChangeContainer)wrapped);
        return new InputFileChangesWrapper(wrapped, (ChangeContainer)cachingChangeContainer);
    }

    private static ChangeContainer errorHandling(Describable executable, ChangeContainer wrapped) {
        return new ErrorHandlingChangeContainer(executable, wrapped);
    }

    private static InputFileChanges errorHandling(Describable executable, InputFileChanges wrapped) {
        ErrorHandlingChangeContainer errorHandlingChangeContainer = new ErrorHandlingChangeContainer(executable, (ChangeContainer)wrapped);
        return new InputFileChangesWrapper(wrapped, (ChangeContainer)errorHandlingChangeContainer);
    }

    private static class MessageCollectingChangeVisitor
    implements ChangeVisitor {
        private final ImmutableCollection.Builder<String> messages;
        private final int max;
        private int count;

        public MessageCollectingChangeVisitor(ImmutableCollection.Builder<String> messages, int max) {
            this.messages = messages;
            this.max = max;
        }

        public boolean visitChange(Change change) {
            this.messages.add((Object)change.getMessage());
            return ++this.count < this.max;
        }
    }

    private static abstract class AbstractDetectedExecutionStateChanges
    implements ExecutionStateChanges {
        private final ImmutableList<String> allChangeMessages;
        protected final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileProperties;
        protected final IncrementalInputProperties incrementalInputProperties;

        public AbstractDetectedExecutionStateChanges(ImmutableList<String> allChangeMessages, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> incrementalInputFileProperties, IncrementalInputProperties incrementalInputProperties) {
            this.allChangeMessages = allChangeMessages;
            this.inputFileProperties = incrementalInputFileProperties;
            this.incrementalInputProperties = incrementalInputProperties;
        }

        @Override
        public ImmutableList<String> getAllChangeMessages() {
            return this.allChangeMessages;
        }

        @Override
        public ExecutionStateChanges withEnforcedRebuild(String rebuildReason) {
            return new RebuildExecutionStateChanges(rebuildReason, this.inputFileProperties, this.incrementalInputProperties);
        }
    }

    private static class NonIncrementalDetectedExecutionStateChanges
    extends AbstractDetectedExecutionStateChanges {
        public NonIncrementalDetectedExecutionStateChanges(ImmutableList<String> allChangeMessages, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileProperties, IncrementalInputProperties incrementalInputProperties) {
            super(allChangeMessages, inputFileProperties, incrementalInputProperties);
        }

        @Override
        public InputChangesInternal createInputChanges() {
            return new NonIncrementalInputChanges((ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)this.inputFileProperties, this.incrementalInputProperties);
        }
    }

    private static class IncrementalDetectedExecutionStateChanges
    extends AbstractDetectedExecutionStateChanges {
        private final InputFileChanges inputFileChanges;

        public IncrementalDetectedExecutionStateChanges(ImmutableList<String> allChangeMessages, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileProperties, InputFileChanges incrementalInputFileChanges, IncrementalInputProperties incrementalInputProperties) {
            super(allChangeMessages, inputFileProperties, incrementalInputProperties);
            this.inputFileChanges = incrementalInputFileChanges;
        }

        @Override
        public InputChangesInternal createInputChanges() {
            return new IncrementalInputChanges(this.inputFileChanges, this.incrementalInputProperties);
        }
    }

    private static class InputFileChangesWrapper
    implements InputFileChanges {
        private final InputFileChanges inputFileChangesDelegate;
        private final ChangeContainer changeContainerDelegate;

        public InputFileChangesWrapper(InputFileChanges inputFileChangesDelegate, ChangeContainer changeContainerDelegate) {
            this.inputFileChangesDelegate = inputFileChangesDelegate;
            this.changeContainerDelegate = changeContainerDelegate;
        }

        @Override
        public boolean accept(String propertyName, ChangeVisitor visitor) {
            return this.inputFileChangesDelegate.accept(propertyName, visitor);
        }

        public boolean accept(ChangeVisitor visitor) {
            return this.changeContainerDelegate.accept(visitor);
        }
    }
}

