/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.phaser;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.phaser.BeforeOrAfter;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDumperVerifier;
import org.jetbrains.kotlin.backend.common.phaser.PhaserState;
import org.jetbrains.kotlin.backend.common.phaser.SameTypeCompilerPhase;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\u0004\b\u0001\u0010\u0003*\u0004\b\u0002\u0010\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005BW\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u001c\u0010\t\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005j\u0002`\u000b0\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J4\u0010\u001c\u001a\u00020\u001d2\u001c\u0010\u001e\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005j\u0002`\u000b0\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 H\u0002J.\u0010!\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00050#0\"2\u0006\u0010$\u001a\u00020\rH\u0016J-\u0010%\u001a\u00028\u00022\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010,J%\u0010-\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010.\u001a\u00028\u0002H\u0002\u00a2\u0006\u0002\u0010/J-\u00100\u001a\u00028\u00022\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00028\u00002\u0006\u00101\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010,J%\u00102\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010/J-\u00103\u001a\u00028\u00022\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010,J\b\u00104\u001a\u00020\u0007H\u0016R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R*\u0010\t\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005j\u0002`\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/backend/common/phaser/AbstractNamedPhaseWrapper;", "Context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Input", "Output", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "name", "", "description", "prerequisite", "", "Lorg/jetbrains/kotlin/backend/common/phaser/AnyNamedPhase;", "nlevels", "", "lower", "Lorg/jetbrains/kotlin/backend/common/phaser/CompilerPhase;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;ILorg/jetbrains/kotlin/backend/common/phaser/CompilerPhase;)V", "getDescription", "()Ljava/lang/String;", "inputDumperVerifier", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseDumperVerifier;", "getInputDumperVerifier", "()Lorg/jetbrains/kotlin/backend/common/phaser/PhaseDumperVerifier;", "getName", "outputDumperVerifier", "getOutputDumperVerifier", "getPrerequisite", "()Ljava/util/Set;", "checkAndRun", "", "set", "block", "Lkotlin/Function0;", "getNamedSubphases", "", "Lkotlin/Pair;", "startDepth", "invoke", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "phaserState", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;", "context", "input", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Ljava/lang/Object;)Ljava/lang/Object;", "runAfter", "output", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Ljava/lang/Object;)V", "runAndProfile", "source", "runBefore", "runBody", "toString", "ir.backend.common"})
public abstract class AbstractNamedPhaseWrapper<Context extends CommonBackendContext, Input, Output>
implements NamedCompilerPhase<Context, Input, Output> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @NotNull
    private final Set<NamedCompilerPhase<?, ?, ?>> prerequisite;
    private final int nlevels;
    private final CompilerPhase<Context, Input, Output> lower;

    @NotNull
    public abstract PhaseDumperVerifier<Context, Input> getInputDumperVerifier();

    @NotNull
    public abstract PhaseDumperVerifier<Context, Output> getOutputDumperVerifier();

    @Override
    public Output invoke(@NotNull PhaseConfig phaseConfig, @NotNull PhaserState phaserState, @NotNull Context context, Input input) {
        Intrinsics.checkParameterIsNotNull((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkParameterIsNotNull((Object)phaserState, (String)"phaserState");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (this instanceof SameTypeCompilerPhase && !phaseConfig.getEnabled().contains(this)) {
            return (Output)input;
        }
        boolean bl = phaserState.getAlreadyDone().containsAll((Collection)this.getPrerequisite());
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        context.setInVerbosePhase(phaseConfig.getVerbose().contains(this));
        this.runBefore(phaseConfig, context, input);
        Output output = this.runBody(phaseConfig, phaserState, context, input);
        this.runAfter(phaseConfig, context, output);
        phaserState.getAlreadyDone().add(this);
        return output;
    }

    private final void runBefore(PhaseConfig phaseConfig, Context context, Input input) {
        this.checkAndRun(phaseConfig.getToDumpStateBefore(), (Function0<Unit>)((Function0)new Function0<Unit>(this, context, input){
            final /* synthetic */ AbstractNamedPhaseWrapper this$0;
            final /* synthetic */ CommonBackendContext $context;
            final /* synthetic */ Object $input;

            public final void invoke() {
                this.this$0.getInputDumperVerifier().dump(this.this$0, this.$context, this.$input, BeforeOrAfter.BEFORE);
            }
            {
                this.this$0 = abstractNamedPhaseWrapper;
                this.$context = commonBackendContext;
                this.$input = object;
                super(0);
            }
        }));
        this.checkAndRun(phaseConfig.getToValidateStateBefore(), (Function0<Unit>)((Function0)new Function0<Unit>(this, context, input){
            final /* synthetic */ AbstractNamedPhaseWrapper this$0;
            final /* synthetic */ CommonBackendContext $context;
            final /* synthetic */ Object $input;

            public final void invoke() {
                this.this$0.getInputDumperVerifier().verify(this.$context, this.$input);
            }
            {
                this.this$0 = abstractNamedPhaseWrapper;
                this.$context = commonBackendContext;
                this.$input = object;
                super(0);
            }
        }));
    }

    private final Output runBody(PhaseConfig phaseConfig, PhaserState phaserState, Context context, Input input) {
        return (Output)(phaseConfig.getNeedProfiling() ? this.runAndProfile(phaseConfig, phaserState, context, input) : CompilerPhaseKt.downlevel(phaserState, this.nlevels, (Function0)new Function0<Output>(this, phaseConfig, phaserState, (CommonBackendContext)context, input){
            final /* synthetic */ AbstractNamedPhaseWrapper this$0;
            final /* synthetic */ PhaseConfig $phaseConfig;
            final /* synthetic */ PhaserState $phaserState;
            final /* synthetic */ CommonBackendContext $context;
            final /* synthetic */ Object $input;

            public final Output invoke() {
                return AbstractNamedPhaseWrapper.access$getLower$p(this.this$0).invoke(this.$phaseConfig, this.$phaserState, this.$context, this.$input);
            }
            {
                this.this$0 = abstractNamedPhaseWrapper;
                this.$phaseConfig = phaseConfig;
                this.$phaserState = phaserState;
                this.$context = commonBackendContext;
                this.$input = object;
                super(0);
            }
        }));
    }

    private final void runAfter(PhaseConfig phaseConfig, Context context, Output output) {
        this.checkAndRun(phaseConfig.getToDumpStateAfter(), (Function0<Unit>)((Function0)new Function0<Unit>(this, context, output){
            final /* synthetic */ AbstractNamedPhaseWrapper this$0;
            final /* synthetic */ CommonBackendContext $context;
            final /* synthetic */ Object $output;

            public final void invoke() {
                this.this$0.getOutputDumperVerifier().dump(this.this$0, this.$context, this.$output, BeforeOrAfter.AFTER);
            }
            {
                this.this$0 = abstractNamedPhaseWrapper;
                this.$context = commonBackendContext;
                this.$output = object;
                super(0);
            }
        }));
        this.checkAndRun(phaseConfig.getToValidateStateAfter(), (Function0<Unit>)((Function0)new Function0<Unit>(this, context, output){
            final /* synthetic */ AbstractNamedPhaseWrapper this$0;
            final /* synthetic */ CommonBackendContext $context;
            final /* synthetic */ Object $output;

            public final void invoke() {
                this.this$0.getOutputDumperVerifier().verify(this.$context, this.$output);
            }
            {
                this.this$0 = abstractNamedPhaseWrapper;
                this.$context = commonBackendContext;
                this.$output = object;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Output runAndProfile(PhaseConfig phaseConfig, PhaserState phaserState, Context context, Input source) {
        void result2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        result2.element = CompilerPhaseKt.downlevel(phaserState, this.nlevels, (Function0)new Function0<Output>(this, (Ref.ObjectRef)result2, phaserState, phaseConfig, (CommonBackendContext)context, source){
            final /* synthetic */ AbstractNamedPhaseWrapper this$0;
            final /* synthetic */ Ref.ObjectRef $result$inlined;
            final /* synthetic */ PhaserState $phaserState$inlined;
            final /* synthetic */ PhaseConfig $phaseConfig$inlined;
            final /* synthetic */ CommonBackendContext $context$inlined;
            final /* synthetic */ Object $source$inlined;
            {
                this.this$0 = abstractNamedPhaseWrapper;
                this.$result$inlined = objectRef;
                this.$phaserState$inlined = phaserState;
                this.$phaseConfig$inlined = phaseConfig;
                this.$context$inlined = commonBackendContext;
                this.$source$inlined = object;
                super(0);
            }

            public final Output invoke() {
                return AbstractNamedPhaseWrapper.access$getLower$p(this.this$0).invoke(this.$phaseConfig$inlined, this.$phaserState$inlined, this.$context$inlined, this.$source$inlined);
            }
        });
        long msec = System.currentTimeMillis() - start$iv;
        String string = StringsKt.repeat((CharSequence)"\t", (int)phaserState.getDepth()) + this.getDescription() + ": " + msec + " msec";
        boolean bl2 = false;
        System.out.println((Object)string);
        Object object = result2.element;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (Output)object;
    }

    private final void checkAndRun(Set<? extends NamedCompilerPhase<?, ?, ?>> set, Function0<Unit> block) {
        if (set.contains(this)) {
            block.invoke();
        }
    }

    @Override
    @NotNull
    public List<Pair<Integer, NamedCompilerPhase<?, ?, ?>>> getNamedSubphases(int startDepth) {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)TuplesKt.to((Object)startDepth, (Object)this)), (Iterable)this.lower.getNamedSubphases(startDepth + this.nlevels));
    }

    @NotNull
    public String toString() {
        return "Compiler Phase @" + this.getName();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Set<NamedCompilerPhase<?, ?, ?>> getPrerequisite() {
        return this.prerequisite;
    }

    public AbstractNamedPhaseWrapper(@NotNull String name, @NotNull String description2, @NotNull Set<? extends NamedCompilerPhase<?, ?, ?>> prerequisite, int nlevels, @NotNull CompilerPhase<? super Context, ? super Input, ? extends Output> lower2) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)description2, (String)"description");
        Intrinsics.checkParameterIsNotNull(prerequisite, (String)"prerequisite");
        Intrinsics.checkParameterIsNotNull(lower2, (String)"lower");
        this.name = name;
        this.description = description2;
        this.prerequisite = prerequisite;
        this.nlevels = nlevels;
        this.lower = lower2;
    }

    public /* synthetic */ AbstractNamedPhaseWrapper(String string, String string2, Set set, int n, CompilerPhase compilerPhase, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(string, string2, set, n, compilerPhase);
    }

    public static final /* synthetic */ CompilerPhase access$getLower$p(AbstractNamedPhaseWrapper $this) {
        return $this.lower;
    }
}

