/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Ieee754Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethods;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrEnumValueOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIllegalArgumentException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrNoWhenBranchMatchedException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Not;
import org.jetbrains.kotlin.backend.jvm.intrinsics.PrimitiveComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ThrowNPE;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "(Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;)V", "intrinsics", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethods;", "getIntrinsics", "()Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethods;", "irMapping", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "Lkotlin/collections/HashMap;", "createPrimitiveComparisonIntrinsics", "", "typeToIrFun", "", "Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "operator", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "getIntrinsic", "descriptor", "backend.jvm"})
public final class IrIntrinsicMethods {
    @NotNull
    private final IntrinsicMethods intrinsics;
    private final HashMap<CallableMemberDescriptor, IntrinsicMethod> irMapping;

    @NotNull
    public final IntrinsicMethods getIntrinsics() {
        return this.intrinsics;
    }

    private final void createPrimitiveComparisonIntrinsics(Map<SimpleType, ? extends IrSimpleFunction> typeToIrFun, KtSingleValueToken operator) {
        Map<SimpleType, ? extends IrSimpleFunction> map2 = typeToIrFun;
        boolean bl = false;
        Iterator<Map.Entry<SimpleType, ? extends IrSimpleFunction>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<SimpleType, ? extends IrSimpleFunction> entry;
            Map.Entry<SimpleType, ? extends IrSimpleFunction> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            SimpleType type2 = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            IrSimpleFunction irFun = entry2.getValue();
            ((Map)this.irMapping).put(irFun.getDescriptor(), new PrimitiveComparison(type2, operator));
        }
    }

    @Nullable
    public final IntrinsicMethod getIntrinsic(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        IntrinsicMethod intrinsicMethod = this.intrinsics.getIntrinsic(descriptor2);
        if (intrinsicMethod != null) {
            IntrinsicMethod intrinsicMethod2 = intrinsicMethod;
            boolean bl = false;
            boolean bl2 = false;
            IntrinsicMethod it = intrinsicMethod2;
            boolean bl3 = false;
            return it;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return this.intrinsics.getIntrinsic(DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty()));
        }
        return this.irMapping.get(descriptor2.getOriginal());
    }

    public IrIntrinsicMethods(@NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkParameterIsNotNull((Object)irBuiltIns, (String)"irBuiltIns");
        this.intrinsics = new IntrinsicMethods();
        IrIntrinsicMethods irIntrinsicMethods = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        irIntrinsicMethods.irMapping = hashMap;
        Map map2 = this.irMapping;
        FunctionDescriptor functionDescriptor = irBuiltIns.getEqeq();
        KtSingleValueToken ktSingleValueToken = KtTokens.EQEQ;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken, (String)"KtTokens.EQEQ");
        map2.put(functionDescriptor, new Equals(ktSingleValueToken));
        Map map3 = this.irMapping;
        FunctionDescriptor functionDescriptor2 = irBuiltIns.getEqeqeq();
        KtSingleValueToken ktSingleValueToken2 = KtTokens.EQEQEQ;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken2, (String)"KtTokens.EQEQEQ");
        map3.put(functionDescriptor2, new Equals(ktSingleValueToken2));
        Map map4 = this.irMapping;
        IrSimpleFunction irSimpleFunction = irBuiltIns.getIeee754equalsFunByOperandType().get(irBuiltIns.getFloat());
        if (irSimpleFunction == null) {
            Intrinsics.throwNpe();
        }
        FunctionDescriptor functionDescriptor3 = irSimpleFunction.getDescriptor();
        Type type2 = Type.FLOAT_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.FLOAT_TYPE");
        map4.put(functionDescriptor3, new Ieee754Equals(type2));
        Map map5 = this.irMapping;
        IrSimpleFunction irSimpleFunction2 = irBuiltIns.getIeee754equalsFunByOperandType().get(irBuiltIns.getDouble());
        if (irSimpleFunction2 == null) {
            Intrinsics.throwNpe();
        }
        FunctionDescriptor functionDescriptor4 = irSimpleFunction2.getDescriptor();
        Type type3 = Type.DOUBLE_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"Type.DOUBLE_TYPE");
        map5.put(functionDescriptor4, new Ieee754Equals(type3));
        ((Map)this.irMapping).put(irBuiltIns.getBooleanNot(), new Not());
        Map<SimpleType, IrSimpleFunction> map6 = irBuiltIns.getLessFunByOperandType();
        KtSingleValueToken ktSingleValueToken3 = KtTokens.LT;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken3, (String)"KtTokens.LT");
        this.createPrimitiveComparisonIntrinsics(map6, ktSingleValueToken3);
        Map<SimpleType, IrSimpleFunction> map7 = irBuiltIns.getLessOrEqualFunByOperandType();
        KtSingleValueToken ktSingleValueToken4 = KtTokens.LTEQ;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken4, (String)"KtTokens.LTEQ");
        this.createPrimitiveComparisonIntrinsics(map7, ktSingleValueToken4);
        Map<SimpleType, IrSimpleFunction> map8 = irBuiltIns.getGreaterFunByOperandType();
        KtSingleValueToken ktSingleValueToken5 = KtTokens.GT;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken5, (String)"KtTokens.GT");
        this.createPrimitiveComparisonIntrinsics(map8, ktSingleValueToken5);
        Map<SimpleType, IrSimpleFunction> map9 = irBuiltIns.getGreaterOrEqualFunByOperandType();
        KtSingleValueToken ktSingleValueToken6 = KtTokens.GTEQ;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSingleValueToken6, (String)"KtTokens.GTEQ");
        this.createPrimitiveComparisonIntrinsics(map9, ktSingleValueToken6);
        ((Map)this.irMapping).put(irBuiltIns.getEnumValueOf(), new IrEnumValueOf());
        ((Map)this.irMapping).put(irBuiltIns.getNoWhenBranchMatchedException(), new IrNoWhenBranchMatchedException());
        ((Map)this.irMapping).put(irBuiltIns.getIllegalArgumentException(), new IrIllegalArgumentException());
        ((Map)this.irMapping).put(irBuiltIns.getThrowNpe(), new ThrowNPE());
    }
}

