/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import java.util.List;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.exceptions.FailureResolutionAware;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.logging.text.BufferingStyledTextOutput;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.util.GUtil;
import org.gradle.util.TreeVisitor;

public class BuildExceptionReporter
implements Action<Throwable> {
    private final StyledTextOutputFactory textOutputFactory;
    private final LoggingConfiguration loggingConfiguration;
    private final BuildClientMetaData clientMetaData;

    public BuildExceptionReporter(StyledTextOutputFactory textOutputFactory, LoggingConfiguration loggingConfiguration, BuildClientMetaData clientMetaData) {
        this.textOutputFactory = textOutputFactory;
        this.loggingConfiguration = loggingConfiguration;
        this.clientMetaData = clientMetaData;
    }

    public void buildFinished(BuildResult result) {
        Throwable failure = result.getFailure();
        if (failure == null) {
            return;
        }
        this.execute(failure);
    }

    public void execute(Throwable failure) {
        if (failure instanceof MultipleBuildFailures) {
            List flattenedFailures = ((MultipleBuildFailures)((Object)failure)).getCauses();
            this.renderMultipleBuildExceptions(failure.getMessage(), flattenedFailures);
            return;
        }
        this.renderSingleBuildException(failure);
    }

    private void renderMultipleBuildExceptions(String message, List<? extends Throwable> flattenedFailures) {
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).format("FAILURE: %s", new Object[]{message});
        output.println();
        for (int i = 0; i < flattenedFailures.size(); ++i) {
            Throwable cause = flattenedFailures.get(i);
            FailureDetails details = this.constructFailureDetails("Task", cause);
            output.println();
            output.withStyle(StyledTextOutput.Style.Failure).format("%s: ", new Object[]{i + 1});
            details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
            output.println();
            output.text((Object)"-----------");
            this.writeFailureDetails(output, details);
            output.println((Object)"==============================================================================");
        }
        this.writeGeneralTips(output);
    }

    private void renderSingleBuildException(Throwable failure) {
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        FailureDetails details = this.constructFailureDetails("Build", failure);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).text((Object)"FAILURE: ");
        details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
        output.println();
        this.writeFailureDetails(output, details);
        this.writeGeneralTips(output);
    }

    private FailureDetails constructFailureDetails(String granularity, Throwable failure) {
        FailureDetails details = new FailureDetails(failure);
        this.reportBuildFailure(granularity, failure, details);
        return details;
    }

    private void reportBuildFailure(String granularity, Throwable failure, FailureDetails details) {
        if (this.loggingConfiguration.getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS) {
            details.exceptionStyle = ExceptionStyle.FULL;
        }
        this.formatGenericFailure(granularity, failure, details);
    }

    private void formatGenericFailure(String granularity, Throwable failure, final FailureDetails details) {
        details.summary.format("%s failed with an exception.", new Object[]{granularity});
        this.fillInFailureResolution(details);
        if (failure instanceof LocationAwareException) {
            final LocationAwareException scriptException = (LocationAwareException)((Object)failure);
            details.failure = scriptException.getCause();
            if (scriptException.getLocation() != null) {
                details.location.text((Object)scriptException.getLocation());
            }
            scriptException.visitReportableCauses((TreeVisitor<? super Throwable>)new TreeVisitor<Throwable>(){
                int depth;

                @Override
                public void node(Throwable node) {
                    if (node == scriptException) {
                        details.details.text((Object)BuildExceptionReporter.this.getMessage(scriptException.getCause()));
                    } else {
                        LinePrefixingStyledTextOutput output = this.getLinePrefixingStyledTextOutput();
                        output.text((Object)BuildExceptionReporter.this.getMessage(node));
                    }
                }

                @Override
                public void startChildren() {
                    ++this.depth;
                }

                @Override
                public void endChildren() {
                    --this.depth;
                }

                private LinePrefixingStyledTextOutput getLinePrefixingStyledTextOutput() {
                    details.details.format("%n", new Object[0]);
                    StringBuilder prefix = new StringBuilder();
                    for (int i = 1; i < this.depth; ++i) {
                        prefix.append("   ");
                    }
                    details.details.text((Object)prefix);
                    prefix.append("  ");
                    details.details.style(StyledTextOutput.Style.Info).text((Object)"> ").style(StyledTextOutput.Style.Normal);
                    return new LinePrefixingStyledTextOutput((StyledTextOutput)details.details, (CharSequence)prefix, false);
                }
            });
        } else {
            details.details.text((Object)this.getMessage(failure));
        }
    }

    private void fillInFailureResolution(FailureDetails details) {
        BufferingStyledTextOutput resolution = details.resolution;
        if (details.failure instanceof FailureResolutionAware) {
            ((FailureResolutionAware)((Object)details.failure)).appendResolution((StyledTextOutput)resolution, this.clientMetaData);
            if (resolution.getHasContent()) {
                resolution.append(' ');
            }
        }
        if (details.exceptionStyle == ExceptionStyle.NONE) {
            resolution.text((Object)"Run with ");
            resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"stacktrace"});
            resolution.text((Object)" option to get the stack trace. ");
        }
        if (this.loggingConfiguration.getLogLevel() != LogLevel.DEBUG) {
            resolution.text((Object)"Run with ");
            if (this.loggingConfiguration.getLogLevel() != LogLevel.INFO) {
                resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"info"});
                resolution.text((Object)" or ");
            }
            resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"debug"});
            resolution.text((Object)" option to get more log output.");
        }
        this.addBuildScanMessage(resolution);
    }

    private void addBuildScanMessage(BufferingStyledTextOutput resolution) {
        resolution.text((Object)" Run with ");
        resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"scan"});
        resolution.text((Object)" to get full insights.");
    }

    private void writeGeneralTips(StyledTextOutput resolution) {
        resolution.println();
        resolution.text((Object)"* Get more help at ");
        resolution.withStyle(StyledTextOutput.Style.UserInput).text((Object)"https://help.gradle.org");
        resolution.println();
    }

    private String getMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (GUtil.isTrue((Object)message)) {
            return message;
        }
        return String.format("%s (no error message)", throwable.getClass().getName());
    }

    private void writeFailureDetails(StyledTextOutput output, FailureDetails details) {
        if (details.location.getHasContent()) {
            output.println();
            output.println((Object)"* Where:");
            details.location.writeTo(output);
            output.println();
        }
        if (details.details.getHasContent()) {
            output.println();
            output.println((Object)"* What went wrong:");
            details.details.writeTo(output);
            output.println();
        }
        if (details.resolution.getHasContent()) {
            output.println();
            output.println((Object)"* Try:");
            details.resolution.writeTo(output);
            output.println();
        }
        Throwable exception = null;
        switch (details.exceptionStyle) {
            case NONE: {
                break;
            }
            case FULL: {
                exception = details.failure;
            }
        }
        if (exception != null) {
            output.println();
            output.println((Object)"* Exception is:");
            output.exception(exception);
            output.println();
        }
    }

    private static class FailureDetails {
        Throwable failure;
        final BufferingStyledTextOutput summary = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput details = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput location = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput resolution = new BufferingStyledTextOutput();
        ExceptionStyle exceptionStyle = ExceptionStyle.NONE;

        public FailureDetails(Throwable failure) {
            this.failure = failure;
        }
    }

    private static enum ExceptionStyle {
        NONE,
        FULL;

    }
}

