/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.gradle.cache.internal.FileContentCache;
import org.gradle.cache.internal.FileContentCacheFactory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.WellKnownFileLocations;

public class SplitFileContentCacheFactory
implements FileContentCacheFactory,
Closeable {
    private final FileContentCacheFactory globalFactory;
    private final FileContentCacheFactory localFactory;
    private final WellKnownFileLocations wellKnownFileLocations;

    public SplitFileContentCacheFactory(FileContentCacheFactory globalFactory, FileContentCacheFactory localFactory, WellKnownFileLocations wellKnownFileLocations) {
        this.globalFactory = globalFactory;
        this.localFactory = localFactory;
        this.wellKnownFileLocations = wellKnownFileLocations;
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable((Object[])new Object[]{this.localFactory}).stop();
    }

    public <V> FileContentCache<V> newCache(String name, int normalizedCacheSize, FileContentCacheFactory.Calculator<? extends V> calculator, Serializer<V> serializer) {
        FileContentCache globalCache = this.globalFactory.newCache(name, normalizedCacheSize, calculator, serializer);
        FileContentCache localCache = this.localFactory.newCache(name, normalizedCacheSize, calculator, serializer);
        return new SplitFileContentCache(globalCache, localCache, this.wellKnownFileLocations);
    }

    private static final class SplitFileContentCache<V>
    implements FileContentCache<V> {
        private final FileContentCache<V> globalCache;
        private final FileContentCache<V> localCache;
        private final WellKnownFileLocations wellKnownFileLocations;

        private SplitFileContentCache(FileContentCache<V> globalCache, FileContentCache<V> localCache, WellKnownFileLocations wellKnownFileLocations) {
            this.globalCache = globalCache;
            this.localCache = localCache;
            this.wellKnownFileLocations = wellKnownFileLocations;
        }

        public V get(File file) {
            if (this.wellKnownFileLocations.isImmutable(file.getPath())) {
                return (V)this.globalCache.get(file);
            }
            return (V)this.localCache.get(file);
        }
    }
}

