/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.ImplementationConflictException;
import org.jetbrains.kotlin.com.intellij.lang.MetaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class Language
extends UserDataHolderBase {
    private static final Map<Class<? extends Language>, Language> ourRegisteredLanguages = ContainerUtil.newConcurrentMap();
    private static final ConcurrentMap<String, List<Language>> ourRegisteredMimeTypes = ContainerUtil.newConcurrentMap();
    private static final Map<String, Language> ourRegisteredIDs = ContainerUtil.newConcurrentMap();
    private final Language myBaseLanguage;
    private final String myID;
    private final String[] myMimeTypes;
    private final List<Language> myDialects;
    public static final Language ANY = new Language(""){

        @Override
        public String toString() {
            return "Language: ANY";
        }

        @Override
        @Nullable
        public LanguageFileType getAssociatedFileType() {
            return null;
        }
    };

    protected Language(@NotNull String ID2) {
        if (ID2 == null) {
            Language.$$$reportNull$$$0(0);
        }
        this(ID2, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    protected Language(@NotNull String ID2, String ... mimeTypes) {
        if (ID2 == null) {
            Language.$$$reportNull$$$0(1);
        }
        if (mimeTypes == null) {
            Language.$$$reportNull$$$0(2);
        }
        this((Language)null, ID2, mimeTypes);
    }

    protected Language(@Nullable Language baseLanguage, @NotNull String ID2, String ... mimeTypes) {
        if (ID2 == null) {
            Language.$$$reportNull$$$0(3);
        }
        if (mimeTypes == null) {
            Language.$$$reportNull$$$0(4);
        }
        this.myDialects = ContainerUtil.createLockFreeCopyOnWriteList();
        if (baseLanguage instanceof MetaLanguage) {
            throw new ImplementationConflictException("MetaLanguage cannot be a base language.\nThis language: '" + ID2 + "'\nBase language: '" + baseLanguage.getID() + "'", null, this, baseLanguage);
        }
        this.myBaseLanguage = baseLanguage;
        this.myID = ID2;
        this.myMimeTypes = mimeTypes.length == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : mimeTypes;
        Class<?> langClass = this.getClass();
        Language prev = ourRegisteredLanguages.put(langClass, this);
        if (prev != null) {
            throw new ImplementationConflictException("Language of '" + langClass + "' is already registered: " + prev, null, prev, this);
        }
        prev = ourRegisteredIDs.put(ID2, this);
        if (prev != null) {
            throw new ImplementationConflictException("Language with ID '" + ID2 + "' is already registered: " + prev.getClass(), null, prev, this);
        }
        for (String mimeType : mimeTypes) {
            if (StringUtil.isEmpty(mimeType)) continue;
            List languagesByMimeType = (List)ourRegisteredMimeTypes.get(mimeType);
            if (languagesByMimeType == null) {
                languagesByMimeType = ConcurrencyUtil.cacheOrGet(ourRegisteredMimeTypes, mimeType, ContainerUtil.createConcurrentList());
            }
            languagesByMimeType.add(this);
        }
        if (baseLanguage != null) {
            baseLanguage.myDialects.add(this);
        }
    }

    @NotNull
    public static Collection<Language> getRegisteredLanguages() {
        Collection<Language> languages = ourRegisteredLanguages.values();
        Collection<Language> collection = Collections.unmodifiableCollection(new ArrayList<Language>(languages));
        if (collection == null) {
            Language.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public static <T extends Language> T findInstance(@NotNull Class<T> klass2) {
        if (klass2 == null) {
            Language.$$$reportNull$$$0(6);
        }
        Language t = ourRegisteredLanguages.get(klass2);
        return (T)t;
    }

    @NotNull
    public static Collection<Language> findInstancesByMimeType(@Nullable String mimeType) {
        List result2 = mimeType == null ? null : (List)ourRegisteredMimeTypes.get(mimeType);
        Collection collection = result2 == null ? Collections.emptyList() : Collections.unmodifiableCollection(result2);
        if (collection == null) {
            Language.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public String toString() {
        return "Language: " + this.myID;
    }

    @NotNull
    public String[] getMimeTypes() {
        if (this.myMimeTypes == null) {
            Language.$$$reportNull$$$0(8);
        }
        return this.myMimeTypes;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            Language.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public LanguageFileType getAssociatedFileType() {
        FileType[] types;
        for (FileType fileType : types = FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType) || ((LanguageFileType)fileType).getLanguage() != this) continue;
            return (LanguageFileType)fileType;
        }
        for (FileType fileType : types) {
            if (!(fileType instanceof LanguageFileType) || !this.isKindOf(((LanguageFileType)fileType).getLanguage())) continue;
            return (LanguageFileType)fileType;
        }
        return null;
    }

    @Nullable
    public Language getBaseLanguage() {
        return this.myBaseLanguage;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getID();
        if (string == null) {
            Language.$$$reportNull$$$0(10);
        }
        return string;
    }

    public final boolean is(Language another) {
        return this == another;
    }

    public boolean isCaseSensitive() {
        return this.myBaseLanguage != null && this.myBaseLanguage.isCaseSensitive();
    }

    public final boolean isKindOf(Language another) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.is(another)) continue;
            return true;
        }
        return false;
    }

    public final boolean isKindOf(@NotNull String anotherLanguageId) {
        if (anotherLanguageId == null) {
            Language.$$$reportNull$$$0(11);
        }
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.getID().equals(anotherLanguageId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<Language> getDialects() {
        List<Language> list2 = this.myDialects;
        if (list2 == null) {
            Language.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @Nullable
    public static Language findLanguageByID(String id) {
        return id == null ? null : ourRegisteredIDs.get(id);
    }

    protected Language(@NotNull String ID2, boolean register) {
        if (ID2 == null) {
            Language.$$$reportNull$$$0(13);
        }
        this.myDialects = ContainerUtil.createLockFreeCopyOnWriteList();
        Language language = Language.findLanguageByID(ID2);
        if (language != null) {
            throw new IllegalArgumentException("Language with ID=" + ID2 + " already registered: " + language + "; " + language.getClass());
        }
        this.myID = ID2;
        this.myBaseLanguage = null;
        this.myMimeTypes = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mimeTypes";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/Language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherLanguageId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/Language";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredLanguages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstancesByMimeType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMimeTypes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isKindOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

