/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.util.Path;

public final class TaskIdentity<T extends Task> {
    private static final AtomicLong SEQUENCE = new AtomicLong();
    public final Class<T> type;
    public final String name;
    public final Path projectPath;
    public final Path identityPath;
    public final Path buildPath;
    public final long uniqueId;

    private TaskIdentity(Class<T> type, String name, Path projectPath, Path identityPath, Path buildPath, long uniqueId) {
        this.name = name;
        this.projectPath = projectPath;
        this.identityPath = identityPath;
        this.buildPath = buildPath;
        this.type = type;
        this.uniqueId = uniqueId;
    }

    public static <T extends Task> TaskIdentity<T> create(String name, Class<T> type, ProjectInternal project) {
        return new TaskIdentity<T>(type, name, project.projectPath(name), project.identityPath(name), project.getGradle().getIdentityPath(), SEQUENCE.getAndIncrement());
    }

    public long getId() {
        return this.uniqueId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskIdentity that = (TaskIdentity)o;
        return this.uniqueId == that.uniqueId;
    }

    public int hashCode() {
        return (int)(this.uniqueId ^ this.uniqueId >>> 32);
    }

    public String toString() {
        return "TaskIdentity{path=" + this.identityPath + ", type=" + this.type + ", uniqueId=" + this.uniqueId + '}';
    }

    public String getTaskPath() {
        return this.projectPath.getPath();
    }

    public String getProjectPath() {
        return this.projectPath.getParent().getPath();
    }
}

