/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.work.AbstractConditionalExecution;
import org.gradle.internal.work.AsyncWorkCompletion;
import org.gradle.internal.work.AsyncWorkTracker;
import org.gradle.internal.work.ConditionalExecution;
import org.gradle.internal.work.ConditionalExecutionQueue;
import org.gradle.internal.work.NoAvailableWorkerLeaseException;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.util.CollectionUtils;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutionException;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.WorkerSpec;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.AdapterWorkAction;
import org.gradle.workers.internal.AdapterWorkParameters;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.ClassLoaderStructureProvider;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.DefaultClassLoaderWorkerSpec;
import org.gradle.workers.internal.DefaultProcessWorkerSpec;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerConfiguration;
import org.gradle.workers.internal.DefaultWorkerSpec;
import org.gradle.workers.internal.IsolatedParametersActionExecutionSpec;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerExecutionQueueFactory;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerSpecInternal;

public class DefaultWorkerExecutor
implements WorkerExecutor {
    private final ConditionalExecutionQueue<DefaultWorkResult> executionQueue;
    private final WorkerFactory daemonWorkerFactory;
    private final WorkerFactory isolatedClassloaderWorkerFactory;
    private final WorkerFactory noIsolationWorkerFactory;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final WorkerLeaseRegistry workerLeaseRegistry;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker asyncWorkTracker;
    private final WorkerDirectoryProvider workerDirectoryProvider;
    private final ClassLoaderStructureProvider classLoaderStructureProvider;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;
    private final Instantiator instantiator;

    public DefaultWorkerExecutor(WorkerFactory daemonWorkerFactory, WorkerFactory isolatedClassloaderWorkerFactory, WorkerFactory noIsolationWorkerFactory, JavaForkOptionsFactory forkOptionsFactory, WorkerLeaseRegistry workerLeaseRegistry, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker, WorkerDirectoryProvider workerDirectoryProvider, WorkerExecutionQueueFactory workerExecutionQueueFactory, ClassLoaderStructureProvider classLoaderStructureProvider, ActionExecutionSpecFactory actionExecutionSpecFactory, Instantiator instantiator) {
        this.daemonWorkerFactory = daemonWorkerFactory;
        this.isolatedClassloaderWorkerFactory = isolatedClassloaderWorkerFactory;
        this.noIsolationWorkerFactory = noIsolationWorkerFactory;
        this.forkOptionsFactory = forkOptionsFactory;
        this.executionQueue = workerExecutionQueueFactory.create();
        this.workerLeaseRegistry = workerLeaseRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
        this.asyncWorkTracker = asyncWorkTracker;
        this.workerDirectoryProvider = workerDirectoryProvider;
        this.classLoaderStructureProvider = classLoaderStructureProvider;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
        this.instantiator = instantiator;
    }

    @Override
    public WorkQueue noIsolation() {
        return this.noIsolation((Action<WorkerSpec>)Actions.doNothing());
    }

    @Override
    public WorkQueue classLoaderIsolation() {
        return this.classLoaderIsolation((Action<ClassLoaderWorkerSpec>)Actions.doNothing());
    }

    @Override
    public WorkQueue processIsolation() {
        return this.processIsolation((Action<ProcessWorkerSpec>)Actions.doNothing());
    }

    @Override
    public WorkQueue noIsolation(Action<WorkerSpec> action) {
        DefaultWorkerSpec spec = (DefaultWorkerSpec)this.instantiator.newInstance(DefaultWorkerSpec.class, new Object[0]);
        action.execute((Object)spec);
        return (WorkQueue)this.instantiator.newInstance(DefaultWorkQueue.class, new Object[]{this, spec});
    }

    @Override
    public WorkQueue classLoaderIsolation(Action<ClassLoaderWorkerSpec> action) {
        DefaultClassLoaderWorkerSpec spec = (DefaultClassLoaderWorkerSpec)this.instantiator.newInstance(DefaultClassLoaderWorkerSpec.class, new Object[0]);
        action.execute((Object)spec);
        return (WorkQueue)this.instantiator.newInstance(DefaultWorkQueue.class, new Object[]{this, spec});
    }

    @Override
    public WorkQueue processIsolation(Action<ProcessWorkerSpec> action) {
        DefaultProcessWorkerSpec spec = (DefaultProcessWorkerSpec)this.instantiator.newInstance(DefaultProcessWorkerSpec.class, new Object[0]);
        File defaultWorkingDir = spec.getForkOptions().getWorkingDir();
        File workingDirectory = this.workerDirectoryProvider.getWorkingDirectory();
        action.execute((Object)spec);
        if (!defaultWorkingDir.equals(spec.getForkOptions().getWorkingDir())) {
            throw new IllegalArgumentException("Setting the working directory of a worker is not supported.");
        }
        spec.getForkOptions().setWorkingDir(workingDirectory);
        return (WorkQueue)this.instantiator.newInstance(DefaultWorkQueue.class, new Object[]{this, spec});
    }

    @Override
    public void submit(final Class<? extends Runnable> actionClass, Action<? super WorkerConfiguration> configAction) {
        WorkQueue workQueue;
        final DefaultWorkerConfiguration configuration = new DefaultWorkerConfiguration(this.forkOptionsFactory);
        configAction.execute((Object)configuration);
        Action<AdapterWorkParameters> parametersAction = new Action<AdapterWorkParameters>(){

            public void execute(AdapterWorkParameters parameters) {
                parameters.setImplementationClassName(actionClass.getName());
                parameters.setParams(configuration.getParams());
                parameters.setDisplayName(configuration.getDisplayName());
            }
        };
        switch (configuration.getIsolationMode()) {
            case NONE: 
            case AUTO: {
                workQueue = this.noIsolation(this.getWorkerSpecAdapterAction(configuration));
                break;
            }
            case CLASSLOADER: {
                workQueue = this.classLoaderIsolation(this.getWorkerSpecAdapterAction(configuration));
                break;
            }
            case PROCESS: {
                workQueue = this.processIsolation(this.getWorkerSpecAdapterAction(configuration));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown isolation mode: " + (Object)((Object)configuration.getIsolationMode()));
            }
        }
        workQueue.submit(AdapterWorkAction.class, parametersAction);
    }

    <T extends WorkerSpec> Action<T> getWorkerSpecAdapterAction(final DefaultWorkerConfiguration configuration) {
        return new Action<T>(){

            public void execute(T spec) {
                configuration.adaptTo((WorkerSpec)spec);
            }
        };
    }

    private <T extends WorkParameters> AsyncWorkCompletion submitWork(Class<? extends WorkAction<T>> workActionClass, WorkerSpecInternal workerSpec, Action<T> parameterAction) {
        IsolatedParametersActionExecutionSpec<WorkParameters> spec;
        WorkParameters parameters;
        ParameterizedType superType = (ParameterizedType)TypeToken.of(workActionClass).getSupertype(WorkAction.class).getType();
        Class parameterType = (Class)Cast.uncheckedNonnullCast((Object)TypeToken.of((Type)superType.getActualTypeArguments()[0]).getRawType());
        if (parameterType == WorkParameters.class) {
            throw new IllegalArgumentException(String.format("Could not create worker parameters: must use a sub-type of %s as parameter type. Use %s for executions without parameters.", ModelType.of(WorkParameters.class).getDisplayName(), ModelType.of(WorkParameters.None.class).getDisplayName()));
        }
        WorkParameters workParameters = parameters = parameterType == WorkParameters.None.class ? null : (WorkParameters)this.instantiator.newInstance(parameterType, new Object[0]);
        if (parameters != null) {
            parameterAction.execute((Object)parameters);
        }
        String description = DefaultWorkerExecutor.getWorkerDisplayName(workActionClass, parameters);
        DaemonForkOptions forkOptions = this.getDaemonForkOptions(workActionClass, workerSpec, parameters);
        try {
            spec = this.actionExecutionSpecFactory.newIsolatedSpec(description, workActionClass, parameters, forkOptions.getClassLoaderStructure());
        }
        catch (Throwable t) {
            throw new WorkExecutionException(description, t);
        }
        return this.submitWork(spec, workerSpec.getIsolationMode(), forkOptions);
    }

    private AsyncWorkCompletion submitWork(final ActionExecutionSpec spec, final IsolationMode isolationMode, final DaemonForkOptions daemonForkOptions) {
        WorkerLeaseRegistry.WorkerLease currentWorkerWorkerLease = this.getCurrentWorkerLease();
        final BuildOperationRef currentBuildOperation = this.buildOperationExecutor.getCurrentOperation();
        WorkItemExecution execution = new WorkItemExecution(spec.getDisplayName(), currentWorkerWorkerLease, new Callable<DefaultWorkResult>(){

            @Override
            public DefaultWorkResult call() throws Exception {
                try {
                    WorkerFactory workerFactory = DefaultWorkerExecutor.this.getWorkerFactory(isolationMode);
                    BuildOperationAwareWorker worker = workerFactory.getWorker(daemonForkOptions);
                    return worker.execute(spec, currentBuildOperation);
                }
                catch (Throwable t) {
                    throw new WorkExecutionException(spec.getDisplayName(), t);
                }
            }
        });
        this.executionQueue.submit((ConditionalExecution)execution);
        this.asyncWorkTracker.registerWork(currentBuildOperation, (AsyncWorkCompletion)execution);
        return execution;
    }

    private static String getWorkerDisplayName(Class<?> workActionClass, WorkParameters parameters) {
        if (workActionClass == AdapterWorkAction.class) {
            AdapterWorkParameters adapterWorkParameters = (AdapterWorkParameters)parameters;
            if (adapterWorkParameters.getDisplayName() != null) {
                return adapterWorkParameters.getDisplayName();
            }
            return adapterWorkParameters.getImplementationClassName();
        }
        return workActionClass.getName();
    }

    private WorkerLeaseRegistry.WorkerLease getCurrentWorkerLease() {
        try {
            return this.workerLeaseRegistry.getCurrentWorkerLease();
        }
        catch (NoAvailableWorkerLeaseException e) {
            throw new IllegalStateException("An attempt was made to submit work from a thread not managed by Gradle.  Work may only be submitted from a Gradle-managed thread.", e);
        }
    }

    private WorkerFactory getWorkerFactory(IsolationMode isolationMode) {
        switch (isolationMode) {
            case AUTO: 
            case CLASSLOADER: {
                return this.isolatedClassloaderWorkerFactory;
            }
            case NONE: {
                return this.noIsolationWorkerFactory;
            }
            case PROCESS: {
                return this.daemonWorkerFactory;
            }
        }
        throw new IllegalArgumentException("Unknown isolation mode: " + (Object)((Object)isolationMode));
    }

    @Override
    public void await() throws WorkerExecutionException {
        BuildOperationRef currentOperation = this.buildOperationExecutor.getCurrentOperation();
        try {
            if (this.asyncWorkTracker.hasUncompletedWork(currentOperation)) {
                this.executionQueue.expand();
            }
            this.asyncWorkTracker.waitForCompletion(currentOperation, AsyncWorkTracker.ProjectLockRetention.RETAIN_PROJECT_LOCKS);
        }
        catch (DefaultMultiCauseException e) {
            throw this.workerExecutionException(e.getCauses());
        }
    }

    private void await(List<AsyncWorkCompletion> workItems) throws WorkExecutionException {
        BuildOperationRef currentOperation = this.buildOperationExecutor.getCurrentOperation();
        try {
            if (CollectionUtils.any(workItems, (Spec)new Spec<AsyncWorkCompletion>(){

                public boolean isSatisfiedBy(AsyncWorkCompletion workItem) {
                    return !workItem.isComplete();
                }
            })) {
                this.executionQueue.expand();
            }
            this.asyncWorkTracker.waitForCompletion(currentOperation, workItems, AsyncWorkTracker.ProjectLockRetention.RETAIN_PROJECT_LOCKS);
        }
        catch (DefaultMultiCauseException e) {
            throw this.workerExecutionException(e.getCauses());
        }
    }

    private WorkerExecutionException workerExecutionException(List<? extends Throwable> failures) {
        if (failures.size() == 1) {
            throw new WorkerExecutionException("There was a failure while executing work items", failures);
        }
        throw new WorkerExecutionException("There were multiple failures while executing work items", failures);
    }

    DaemonForkOptions getDaemonForkOptions(Class<?> executionClass, WorkerSpec configuration, WorkParameters parameters) {
        DaemonForkOptionsBuilder builder = new DaemonForkOptionsBuilder(this.forkOptionsFactory).keepAliveMode(KeepAliveMode.DAEMON);
        if (configuration instanceof ProcessWorkerSpec) {
            ProcessWorkerSpec processConfiguration = (ProcessWorkerSpec)configuration;
            JavaForkOptionsInternal forkOptions = this.forkOptionsFactory.newJavaForkOptions();
            processConfiguration.getForkOptions().copyTo((JavaForkOptions)forkOptions);
            forkOptions.setWorkingDir(this.workerDirectoryProvider.getWorkingDirectory());
            builder.javaForkOptions((JavaForkOptions)forkOptions).withClassLoaderStructure(this.classLoaderStructureProvider.getWorkerProcessClassLoaderStructure((Iterable<File>)processConfiguration.getClasspath(), this.getParamClasses(executionClass, parameters)));
        } else if (configuration instanceof ClassLoaderWorkerSpec) {
            ClassLoaderWorkerSpec classLoaderConfiguration = (ClassLoaderWorkerSpec)configuration;
            builder.withClassLoaderStructure(this.classLoaderStructureProvider.getInProcessClassLoaderStructure((Iterable<File>)classLoaderConfiguration.getClasspath(), this.getParamClasses(executionClass, parameters)));
        }
        return builder.build();
    }

    private Class<?>[] getParamClasses(Class<?> actionClass, WorkParameters parameters) {
        Object[] params;
        Class implementationClass;
        if (parameters instanceof AdapterWorkParameters) {
            AdapterWorkParameters adapterWorkParameters = (AdapterWorkParameters)parameters;
            implementationClass = ClassLoaderUtils.classFromContextLoader((String)adapterWorkParameters.getImplementationClassName());
            params = adapterWorkParameters.getParams();
        } else {
            implementationClass = actionClass;
            params = new Object[]{parameters};
        }
        ArrayList classes = Lists.newArrayList();
        classes.add(implementationClass);
        for (Object param : params) {
            if (param == null) continue;
            classes.add(param.getClass());
        }
        return classes.toArray(new Class[0]);
    }

    @NotThreadSafe
    static class DefaultWorkQueue
    implements WorkQueue {
        private final DefaultWorkerExecutor workerExecutor;
        private final WorkerSpecInternal spec;
        private final List<AsyncWorkCompletion> workItems = Lists.newArrayList();

        public DefaultWorkQueue(DefaultWorkerExecutor workerExecutor, WorkerSpecInternal spec) {
            this.workerExecutor = workerExecutor;
            this.spec = spec;
        }

        @Override
        public <T extends WorkParameters> void submit(Class<? extends WorkAction<T>> workActionClass, Action<T> parameterAction) {
            this.workItems.add(this.workerExecutor.submitWork(workActionClass, this.spec, parameterAction));
        }

        @Override
        public void await() throws WorkerExecutionException {
            this.workerExecutor.await(this.workItems);
        }
    }

    private static class LazyChildWorkerLeaseLock
    implements ResourceLock {
        private final WorkerLeaseRegistry.WorkerLease parentWorkerLease;
        private WorkerLeaseRegistry.WorkerLease child;

        public LazyChildWorkerLeaseLock(WorkerLeaseRegistry.WorkerLease parentWorkerLease) {
            this.parentWorkerLease = parentWorkerLease;
        }

        public boolean isLocked() {
            return this.getChild().isLocked();
        }

        public boolean isLockedByCurrentThread() {
            return this.getChild().isLockedByCurrentThread();
        }

        public boolean tryLock() {
            this.child = this.parentWorkerLease.createChild();
            if (this.child.tryLock()) {
                return true;
            }
            this.child = null;
            return false;
        }

        public void unlock() {
            this.getChild().unlock();
        }

        public String getDisplayName() {
            return this.getChild().getDisplayName();
        }

        private WorkerLeaseRegistry.WorkerLease getChild() {
            if (this.child == null) {
                throw new IllegalStateException("Detected attempt to access LazyChildWorkerLeaseLock before tryLock() has succeeded.  tryLock must be succeed before other methods are called.");
            }
            return this.child;
        }
    }

    private static class WorkItemExecution
    extends AbstractConditionalExecution<DefaultWorkResult>
    implements AsyncWorkCompletion {
        private final String description;

        public WorkItemExecution(String description, WorkerLeaseRegistry.WorkerLease parentWorkerLease, Callable<DefaultWorkResult> callable) {
            super(callable, (ResourceLock)new LazyChildWorkerLeaseLock(parentWorkerLease));
            this.description = description;
        }

        public void waitForCompletion() {
            DefaultWorkResult result = (DefaultWorkResult)this.await();
            if (!result.isSuccess()) {
                throw new WorkExecutionException(this.description, result.getException());
            }
        }
    }

    @Contextual
    private static class WorkExecutionException
    extends RuntimeException {
        WorkExecutionException(String description) {
            super(WorkExecutionException.toMessage(description));
        }

        WorkExecutionException(String description, Throwable cause) {
            super(WorkExecutionException.toMessage(description), cause);
        }

        private static String toMessage(String description) {
            return "A failure occurred while executing " + description;
        }
    }
}

