/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompilerSupport;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationNotNecessary;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.language.base.internal.compile.Compiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SelectiveCompiler<T extends JavaCompileSpec>
implements Compiler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SelectiveCompiler.class);
    private final PreviousCompilation previousCompilation;
    private final CleaningJavaCompilerSupport<T> cleaningCompiler;
    private final Compiler<T> rebuildAllCompiler;
    private final RecompilationSpecProvider recompilationSpecProvider;
    private final ClasspathSnapshotProvider classpathSnapshotProvider;

    public SelectiveCompiler(PreviousCompilation previousCompilation, CleaningJavaCompilerSupport<T> cleaningCompiler, Compiler<T> rebuildAllCompiler, RecompilationSpecProvider recompilationSpecProvider, ClasspathSnapshotProvider classpathSnapshotProvider) {
        this.previousCompilation = previousCompilation;
        this.cleaningCompiler = cleaningCompiler;
        this.rebuildAllCompiler = rebuildAllCompiler;
        this.recompilationSpecProvider = recompilationSpecProvider;
        this.classpathSnapshotProvider = classpathSnapshotProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkResult execute(T spec) {
        if (spec.getSourceRoots().isEmpty()) {
            LOG.info("Full recompilation is required because the source roots could not be inferred.");
            return this.rebuildAllCompiler.execute(spec);
        }
        Timer clock = Time.startTimer();
        CurrentCompilation currentCompilation = new CurrentCompilation((JavaCompileSpec)spec, this.classpathSnapshotProvider);
        RecompilationSpec recompilationSpec = this.recompilationSpecProvider.provideRecompilationSpec(currentCompilation, this.previousCompilation);
        if (recompilationSpec.isFullRebuildNeeded()) {
            LOG.info("Full recompilation is required because {}. Analysis took {}.", (Object)recompilationSpec.getFullRebuildCause(), (Object)clock.getElapsed());
            return this.rebuildAllCompiler.execute(spec);
        }
        this.recompilationSpecProvider.initializeCompilation((JavaCompileSpec)spec, recompilationSpec);
        if (Iterables.isEmpty((Iterable)spec.getSourceFiles()) && spec.getClasses().isEmpty()) {
            LOG.info("None of the classes needs to be compiled! Analysis took {}. ", (Object)clock.getElapsed());
            return new RecompilationNotNecessary();
        }
        try {
            WorkResult workResult = this.recompilationSpecProvider.decorateResult(recompilationSpec, this.cleaningCompiler.getCompiler().execute(spec));
            return workResult;
        }
        finally {
            Collection<String> classesToCompile = recompilationSpec.getClassesToCompile();
            LOG.info("Incremental compilation of {} classes completed in {}.", (Object)classesToCompile.size(), (Object)clock.getElapsed());
            LOG.debug("Recompiled classes {}", classesToCompile);
        }
    }
}

