/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import com.google.common.io.Closer;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.caching.BuildCacheEntryReader;

public class LoadTarget
implements BuildCacheEntryReader {
    private final File file;
    private boolean loaded;

    public LoadTarget(File file) {
        this.file = file;
    }

    public void readFrom(InputStream input) throws IOException {
        Closer closer = Closer.create();
        closer.register((Closeable)input);
        try {
            if (this.loaded) {
                throw new IllegalStateException("Build cache entry has already been read");
            }
            Files.asByteSink((File)this.file, (FileWriteMode[])new FileWriteMode[0]).writeFrom(input);
            this.loaded = true;
        }
        catch (Exception e) {
            throw closer.rethrow((Throwable)e);
        }
        finally {
            closer.close();
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public long getLoadedSize() {
        if (this.loaded) {
            return this.file.length();
        }
        return -1L;
    }
}

