/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.tasks;

import java.io.File;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.publish.internal.PublishOperation;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.ValidatingMavenPublisher;
import org.gradle.api.publish.maven.tasks.AbstractPublishToMaven;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Factory;

public class PublishToMavenRepository
extends AbstractPublishToMaven {
    private MavenArtifactRepository repository;

    @Internal
    public MavenArtifactRepository getRepository() {
        return this.repository;
    }

    public void setRepository(MavenArtifactRepository repository) {
        this.repository = repository;
    }

    @TaskAction
    public void publish() {
        MavenPublicationInternal publicationInternal = this.getPublicationInternal();
        if (publicationInternal == null) {
            throw new InvalidUserDataException("The 'publication' property is required");
        }
        MavenArtifactRepository repository = this.getRepository();
        if (repository == null) {
            throw new InvalidUserDataException("The 'repository' property is required");
        }
        this.getDuplicatePublicationTracker().checkCanPublish(publicationInternal, repository.getUrl(), repository.getName());
        this.doPublish(publicationInternal, repository);
    }

    private void doPublish(final MavenPublicationInternal publication, final MavenArtifactRepository repository) {
        new PublishOperation(publication, repository.getName()){

            protected void publish() {
                MavenPublisher remotePublisher = PublishToMavenRepository.this.getMavenPublishers().getRemotePublisher((Factory<File>)PublishToMavenRepository.this.getTemporaryDirFactory());
                remotePublisher = new ValidatingMavenPublisher(remotePublisher);
                remotePublisher.publish(publication.asNormalisedPublication(), repository);
            }
        }.run();
    }
}

