/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.CacheableInvocation;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.artifacts.transform.TransformerInvocationFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.internal.Try;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.model.ModelContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationStep
implements Transformation,
TaskDependencyContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformationStep.class);
    public static final Equivalence<? super TransformationStep> FOR_SCHEDULING = Equivalence.identity();
    private final Transformer transformer;
    private final TransformerInvocationFactory transformerInvocationFactory;
    private final ProjectStateRegistry.SafeExclusiveLock isolationLock;
    private final WorkNodeAction isolateAction;
    private final ProjectInternal owningProject;
    private final FileCollectionFingerprinterRegistry globalFingerprinterRegistry;
    private final ModelContainer owner;

    public TransformationStep(final Transformer transformer, TransformerInvocationFactory transformerInvocationFactory, DomainObjectContext owner, ProjectStateRegistry projectRegistry, FileCollectionFingerprinterRegistry globalFingerprinterRegistry) {
        this.transformer = transformer;
        this.transformerInvocationFactory = transformerInvocationFactory;
        this.globalFingerprinterRegistry = globalFingerprinterRegistry;
        this.isolationLock = projectRegistry.newExclusiveOperationLock();
        this.owningProject = owner.getProject();
        this.owner = owner.getModel();
        this.isolateAction = transformer.isIsolated() ? null : new WorkNodeAction(){

            public String toString() {
                return "isolate parameters of transform " + transformer.getDisplayName();
            }

            @Nullable
            public Project getProject() {
                return TransformationStep.this.owningProject;
            }

            public void run(NodeExecutionContext context) {
                FileCollectionFingerprinterRegistry fingerprinterRegistry = (FileCollectionFingerprinterRegistry)context.getService(FileCollectionFingerprinterRegistry.class);
                TransformationStep.this.isolateTransformerParameters(fingerprinterRegistry);
            }
        };
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    @Nullable
    public ProjectInternal getOwningProject() {
        return this.owningProject;
    }

    @Override
    public boolean endsWith(Transformation otherTransform) {
        return this == otherTransform;
    }

    @Override
    public int stepsCount() {
        return 1;
    }

    @Override
    public CacheableInvocation<TransformationSubject> createInvocation(TransformationSubject subjectToTransform, ExecutionGraphDependenciesResolver dependenciesResolver, @Nullable NodeExecutionContext context) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transforming {} with {}", (Object)subjectToTransform.getDisplayName(), (Object)this.transformer.getDisplayName());
        }
        FileCollectionFingerprinterRegistry fingerprinterRegistry = context != null ? (FileCollectionFingerprinterRegistry)context.getService(FileCollectionFingerprinterRegistry.class) : this.globalFingerprinterRegistry;
        this.isolateTransformerParameters(fingerprinterRegistry);
        Try<ArtifactTransformDependencies> resolvedDependencies = dependenciesResolver.forTransformer(this.transformer);
        return (CacheableInvocation)resolvedDependencies.map(dependencies -> {
            ImmutableList<File> inputArtifacts = subjectToTransform.getFiles();
            if (inputArtifacts.isEmpty()) {
                return CacheableInvocation.cached(Try.successful((Object)subjectToTransform.createSubjectFromResult((ImmutableList<File>)ImmutableList.of())));
            }
            if (inputArtifacts.size() > 1) {
                return CacheableInvocation.nonCached(() -> this.doTransform(subjectToTransform, fingerprinterRegistry, (ArtifactTransformDependencies)dependencies, inputArtifacts));
            }
            File inputArtifact = (File)inputArtifacts.iterator().next();
            return this.transformerInvocationFactory.createInvocation(this.transformer, inputArtifact, (ArtifactTransformDependencies)dependencies, subjectToTransform, fingerprinterRegistry).map(subjectToTransform::createSubjectFromResult);
        }).getOrMapFailure(failure -> CacheableInvocation.cached(Try.failure((Throwable)failure)));
    }

    private Try<TransformationSubject> doTransform(TransformationSubject subjectToTransform, FileCollectionFingerprinterRegistry fingerprinterRegistry, ArtifactTransformDependencies dependencies, ImmutableList<File> inputArtifacts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (File inputArtifact : inputArtifacts) {
            Try<ImmutableList<File>> result = this.transformerInvocationFactory.createInvocation(this.transformer, inputArtifact, dependencies, subjectToTransform, fingerprinterRegistry).invoke();
            if (result.getFailure().isPresent()) {
                return Try.failure((Throwable)((Throwable)result.getFailure().get()));
            }
            builder.addAll((Iterable)result.get());
        }
        return Try.successful((Object)subjectToTransform.createSubjectFromResult((ImmutableList<File>)builder.build()));
    }

    private void isolateTransformerParameters(FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        if (!this.transformer.isIsolated()) {
            if (!this.owner.hasMutableState()) {
                this.owner.withLenientState(() -> this.isolateExclusively(fingerprinterRegistry));
            } else {
                this.isolateExclusively(fingerprinterRegistry);
            }
        }
    }

    private void isolateExclusively(FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        this.isolationLock.withLock(() -> {
            if (!this.transformer.isIsolated()) {
                this.transformer.isolateParameters(fingerprinterRegistry);
            }
        });
    }

    @Override
    public boolean requiresDependencies() {
        return this.transformer.requiresDependencies();
    }

    public String getDisplayName() {
        return this.transformer.getDisplayName();
    }

    @Override
    public void visitTransformationSteps(Action<? super TransformationStep> action) {
        action.execute((Object)this);
    }

    public ImmutableAttributes getFromAttributes() {
        return this.transformer.getFromAttributes();
    }

    public String toString() {
        return String.format("%s@%s", this.transformer.getDisplayName(), this.transformer.getSecondaryInputHash());
    }

    public TaskDependencyContainer getDependencies() {
        return this.transformer;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        if (!this.transformer.isIsolated()) {
            context.add((Object)this.isolateAction);
        }
        this.transformer.visitDependencies(context);
    }
}

