/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.MapCollector;
import org.gradle.api.internal.provider.MapEntryCollector;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

public class MapCollectors {

    public static class EntriesFromMapProvider<K, V>
    implements MapCollector<K, V> {
        private final ProviderInternal<? extends Map<? extends K, ? extends V>> providerOfEntries;

        public EntriesFromMapProvider(ProviderInternal<? extends Map<? extends K, ? extends V>> providerOfEntries) {
            this.providerOfEntries = providerOfEntries;
        }

        @Override
        public boolean isPresent() {
            return this.providerOfEntries.isPresent();
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            ValueSupplier.Value<Map<K, V>> value = this.providerOfEntries.calculateValue();
            if (value.isMissing()) {
                return value.asType();
            }
            collector.addAll(value.get().entrySet(), dest);
            return ValueSupplier.Value.present();
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            Map entries = (Map)this.providerOfEntries.getOrNull();
            if (entries != null) {
                collector.addAll(entries.keySet(), dest);
                return ValueSupplier.Value.present();
            }
            return ValueSupplier.Value.missing();
        }

        @Override
        public void visit(List<ProviderInternal<? extends Map<? extends K, ? extends V>>> sources) {
            sources.add(this.providerOfEntries);
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return this.providerOfEntries.maybeVisitBuildDependencies(context);
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            this.providerOfEntries.visitProducerTasks(visitor);
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.providerOfEntries.isValueProducedByTask();
        }
    }

    public static class EntriesFromMap<K, V>
    implements MapCollector<K, V> {
        private final Map<? extends K, ? extends V> entries;

        public EntriesFromMap(Map<? extends K, ? extends V> entries) {
            this.entries = entries;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            collector.addAll(this.entries.entrySet(), dest);
            return ValueSupplier.Value.present();
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            collector.addAll(this.entries.keySet(), dest);
            return ValueSupplier.Value.present();
        }

        @Override
        public void visit(List<ProviderInternal<? extends Map<? extends K, ? extends V>>> sources) {
            sources.add(Providers.of(this.entries));
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }
    }

    public static class EntryWithValueFromProvider<K, V>
    implements MapCollector<K, V> {
        private final K key;
        private final ProviderInternal<? extends V> providerOfValue;

        public EntryWithValueFromProvider(K key, ProviderInternal<? extends V> providerOfValue) {
            this.key = key;
            this.providerOfValue = providerOfValue;
        }

        @Override
        public boolean isPresent() {
            return this.providerOfValue.isPresent();
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            ValueSupplier.Value<V> value = this.providerOfValue.calculateValue();
            if (value.isMissing()) {
                return value.asType();
            }
            collector.add(this.key, value.get(), dest);
            return ValueSupplier.Value.present();
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            if (this.providerOfValue.isPresent()) {
                collector.add(this.key, dest);
                return ValueSupplier.Value.present();
            }
            return ValueSupplier.Value.missing();
        }

        @Override
        public void visit(List<ProviderInternal<? extends Map<? extends K, ? extends V>>> sources) {
            sources.add((ProviderInternal<Map<K, V>>)this.providerOfValue.map(v -> ImmutableMap.of(this.key, (Object)v)));
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return this.providerOfValue.maybeVisitBuildDependencies(context);
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            this.providerOfValue.visitProducerTasks(visitor);
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.providerOfValue.isValueProducedByTask();
        }
    }

    public static class SingleEntry<K, V>
    implements MapCollector<K, V> {
        private final K key;
        private final V value;

        public SingleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            collector.add(this.key, this.value, dest);
            return ValueSupplier.Value.present();
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            collector.add(this.key, dest);
            return ValueSupplier.Value.present();
        }

        @Override
        public void visit(List<ProviderInternal<? extends Map<? extends K, ? extends V>>> sources) {
            sources.add(Providers.of(ImmutableMap.of(this.key, this.value)));
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleEntry that = (SingleEntry)o;
            return Objects.equal(this.key, that.key) && Objects.equal(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.key, this.value});
        }
    }
}

