/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import org.gradle.util.GradleVersion;

final class Messages {
    private static String isScheduledToBeRemovedMessage;
    private static String willBecomeErrorMessage;
    private static String thisIsScheduledToBeRemoved;
    private static String thisBehaviourHasBeenDeprecatedAndIsScheduledToBeRemoved;

    private Messages() {
    }

    static String xHasBeenDeprecated(String x) {
        return String.format("%s has been deprecated.", x);
    }

    static String pleaseUseThisMethodInstead(String replacement) {
        return String.format("Please use the %s method instead.", replacement);
    }

    static String thisBehaviourHasBeenDeprecatedAndIsScheduledToBeRemoved() {
        if (thisBehaviourHasBeenDeprecatedAndIsScheduledToBeRemoved == null) {
            thisBehaviourHasBeenDeprecatedAndIsScheduledToBeRemoved = String.format("This behaviour has been deprecated and %s", Messages.isScheduledToBeRemoved());
        }
        return thisBehaviourHasBeenDeprecatedAndIsScheduledToBeRemoved;
    }

    static String thisIsScheduledToBeRemoved() {
        if (thisIsScheduledToBeRemoved == null) {
            thisIsScheduledToBeRemoved = String.format("This %s", Messages.isScheduledToBeRemoved());
        }
        return thisIsScheduledToBeRemoved;
    }

    static String isScheduledToBeRemoved() {
        if (isScheduledToBeRemovedMessage == null) {
            isScheduledToBeRemovedMessage = String.format("is scheduled to be removed in Gradle %s.", GradleVersion.current().getNextMajor().getVersion());
        }
        return isScheduledToBeRemovedMessage;
    }

    static String thisWillBecomeAnError() {
        if (willBecomeErrorMessage == null) {
            willBecomeErrorMessage = String.format("This will fail with an error in Gradle %s.", GradleVersion.current().getNextMajor().getVersion());
        }
        return willBecomeErrorMessage;
    }
}

