/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedVariantFiles;
import org.gradle.api.internal.artifacts.transform.DefaultTransformationDependency;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformCompletion;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.api.internal.artifacts.transform.TransformationNodeRegistry;
import org.gradle.api.internal.artifacts.transform.TransformingAsyncArtifactListener;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class ConsumerProvidedResolvedVariant
implements ResolvedArtifactSet,
ConsumerProvidedVariantFiles {
    private final ComponentIdentifier componentIdentifier;
    private final ResolvedArtifactSet delegate;
    private final AttributeContainerInternal attributes;
    private final Transformation transformation;
    private final ExtraExecutionGraphDependenciesResolverFactory resolverFactory;
    private final TransformationNodeRegistry transformationNodeRegistry;

    public ConsumerProvidedResolvedVariant(ComponentIdentifier componentIdentifier, ResolvedArtifactSet delegate, AttributeContainerInternal target, Transformation transformation, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolverFactory, TransformationNodeRegistry transformationNodeRegistry) {
        this.componentIdentifier = componentIdentifier;
        this.delegate = delegate;
        this.attributes = target;
        this.transformation = transformation;
        this.resolverFactory = dependenciesResolverFactory;
        this.transformationNodeRegistry = transformationNodeRegistry;
    }

    @Override
    public ImmutableAttributes getTargetVariantAttributes() {
        return this.attributes.asImmutable();
    }

    @Override
    public DisplayName getTargetVariantName() {
        return Describables.of((Object)this.componentIdentifier, (Object)this.attributes);
    }

    public String toString() {
        return this.getTargetVariantName().getCapitalizedDisplayName();
    }

    @Override
    public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
        FileCollectionStructureVisitor.VisitType visitType = listener.prepareForVisit(this);
        if (visitType == FileCollectionStructureVisitor.VisitType.NoContents) {
            return visitor -> visitor.endVisitCollection(this);
        }
        ConcurrentMap artifactResults = Maps.newConcurrentMap();
        ResolvedArtifactSet.Completion result = this.delegate.startVisit(actions, new TransformingAsyncArtifactListener(this.transformation, actions, artifactResults, this.getDependenciesResolver(), this.transformationNodeRegistry));
        return new TransformCompletion(result, this.attributes, artifactResults);
    }

    @Override
    public void visitLocalArtifacts(ResolvedArtifactSet.LocalArtifactVisitor listener) {
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        Collection<TransformationNode> scheduledNodes = this.transformationNodeRegistry.getOrCreate(this.delegate, this.transformation, this.getDependenciesResolver());
        if (!scheduledNodes.isEmpty()) {
            context.add((Object)new DefaultTransformationDependency(scheduledNodes));
        }
    }

    @Override
    public Collection<TransformationNode> getScheduledNodes() {
        AtomicReference<Boolean> hasProjectArtifacts = new AtomicReference<Boolean>(false);
        this.delegate.visitLocalArtifacts(artifact -> {
            if (artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) {
                hasProjectArtifacts.set(true);
            }
        });
        if (hasProjectArtifacts.get().booleanValue()) {
            return this.transformationNodeRegistry.getOrCreate(this.delegate, this.transformation, this.getDependenciesResolver());
        }
        return Collections.emptySet();
    }

    private ExecutionGraphDependenciesResolver getDependenciesResolver() {
        return this.resolverFactory.create(this.componentIdentifier);
    }
}

