/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.text;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtilRt {
    @Contract(value="null,!null,_ -> false; !null,null,_ -> false; null,null,_ -> true")
    public static boolean equal(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean caseSensitive) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        if (caseSensitive) {
            for (int i = 0; i < s1.length(); ++i) {
                if (s1.charAt(i) == s2.charAt(i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < s1.length(); ++i) {
                if (StringUtilRt.charsEqualIgnoreCase(s1.charAt(i), s2.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || StringUtilRt.toUpperCase(a) == StringUtilRt.toUpperCase(b) || StringUtilRt.toLowerCase(a) == StringUtilRt.toLowerCase(b);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        if (a <= 'z') {
            return (char)(a + -32);
        }
        return Character.toUpperCase(a);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        if (a < 'A' || a >= 'a' && a <= 'z') {
            return a;
        }
        if (a <= 'Z') {
            return (char)(a + 32);
        }
        return Character.toLowerCase(a);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2) {
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(0);
        }
        String string2 = StringUtilRt.convertLineSeparators(text2, false);
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2, boolean keepCarriageReturn) {
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(2);
        }
        String string2 = StringUtilRt.convertLineSeparators(text2, "\n", null, keepCarriageReturn);
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator) {
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(4);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(5);
        }
        String string2 = StringUtilRt.convertLineSeparators(text2, newSeparator, null);
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(10);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(11);
        }
        String string2 = StringUtilRt.convertLineSeparators(text2, newSeparator, offsetsToKeep, false);
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(13);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(14);
        }
        String string2 = StringUtilRt.unifyLineSeparators(text2, newSeparator, offsetsToKeep, keepCarriageReturn).toString();
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @NotNull
    private static CharSequence unifyLineSeparators(@NotNull CharSequence text2, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(16);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(17);
        }
        StringBuilder buffer = null;
        int intactLength = 0;
        boolean newSeparatorIsSlashN = "\n".equals(newSeparator);
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == '\n') {
                if (!newSeparatorIsSlashN) {
                    if (buffer == null) {
                        buffer = new StringBuilder(text2.length());
                        buffer.append(text2, 0, intactLength);
                    }
                    buffer.append(newSeparator);
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                    continue;
                }
                if (buffer == null) {
                    ++intactLength;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == '\r') {
                boolean followedByLineFeed;
                boolean bl = followedByLineFeed = i < text2.length() - 1 && text2.charAt(i + 1) == '\n';
                if (!followedByLineFeed && keepCarriageReturn) {
                    if (buffer == null) {
                        ++intactLength;
                        continue;
                    }
                    buffer.append(c);
                    continue;
                }
                if (buffer == null) {
                    buffer = new StringBuilder(text2.length());
                    buffer.append(text2, 0, intactLength);
                }
                buffer.append(newSeparator);
                if (followedByLineFeed) {
                    ++i;
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 2, newSeparator.length());
                    continue;
                }
                StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                continue;
            }
            if (buffer == null) {
                ++intactLength;
                continue;
            }
            buffer.append(c);
        }
        CharSequence charSequence = buffer == null ? text2 : buffer;
        if (charSequence == null) {
            StringUtilRt.$$$reportNull$$$0(18);
        }
        return charSequence;
    }

    private static void shiftOffsets(int[] offsets, int changeOffset, int oldLength, int newLength) {
        if (offsets == null) {
            return;
        }
        int shift = newLength - oldLength;
        if (shift == 0) {
            return;
        }
        for (int i = 0; i < offsets.length; ++i) {
            int offset2 = offsets[i];
            if (offset2 < changeOffset + oldLength) continue;
            int n = i;
            offsets[n] = offsets[n] + shift;
        }
    }

    @Contract(pure=true)
    public static int parseInt(@Nullable String string2, int defaultValue2) {
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue2;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName2) {
        if (fqName2 == null) {
            StringUtilRt.$$$reportNull$$$0(23);
        }
        String string2 = StringUtilRt.getShortName(fqName2, '.');
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(24);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName2, char separator) {
        int lastPointIdx;
        if (fqName2 == null) {
            StringUtilRt.$$$reportNull$$$0(25);
        }
        if ((lastPointIdx = fqName2.lastIndexOf(separator)) >= 0) {
            String string2 = fqName2.substring(lastPointIdx + 1);
            if (string2 == null) {
                StringUtilRt.$$$reportNull$$$0(26);
            }
            return string2;
        }
        String string3 = fqName2;
        if (string3 == null) {
            StringUtilRt.$$$reportNull$$$0(27);
        }
        return string3;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return s != null && s.length() != 0 && s.charAt(s.length() - 1) == suffix;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text2, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(28);
        }
        if (suffix == null) {
            StringUtilRt.$$$reportNull$$$0(29);
        }
        if ((l1 = text2.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text2.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String prefix) {
        int prefixLength;
        int stringLength;
        if (str == null) {
            StringUtilRt.$$$reportNull$$$0(30);
        }
        if (prefix == null) {
            StringUtilRt.$$$reportNull$$$0(31);
        }
        return (stringLength = str.length()) >= (prefixLength = prefix.length()) && str.regionMatches(true, 0, prefix, 0, prefixLength);
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull CharSequence text2, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtilRt.$$$reportNull$$$0(32);
        }
        if (suffix == null) {
            StringUtilRt.$$$reportNull$$$0(33);
        }
        if ((l1 = text2.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (StringUtilRt.charsEqualIgnoreCase(text2.charAt(i), suffix.charAt(i + l2 - l1))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(34);
        }
        start = Math.max(start, 0);
        for (int i = Math.min(end, s.length()) - 1; i >= start; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        if (StringUtilRt.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s) {
        String string2 = StringUtilRt.notNullize(s, "");
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(35);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s, @NotNull String defaultValue2) {
        if (defaultValue2 == null) {
            StringUtilRt.$$$reportNull$$$0(36);
        }
        String string2 = s == null ? defaultValue2 : s;
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(37);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(44);
        }
        return s.length() > 1 && (s.charAt(0) == '\'' || s.charAt(0) == '\"') && s.charAt(0) == s.charAt(s.length() - 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(45);
        }
        String string2 = StringUtilRt.isQuotedString(s) ? s.substring(1, s.length() - 1) : s;
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(46);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/StringUtilRt";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 34: 
            case 38: 
            case 44: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/StringUtilRt";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyLineSeparators";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 40: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 46: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unifyLineSeparators";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

