/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

final class IntObjectHashMap {
    private int size;
    private int[] keys = new int[4];
    private Object[] values = new Object[this.keys.length];
    private Object specialZeroValue;
    private boolean hasZeroValue;

    IntObjectHashMap() {
    }

    public void put(int key, Object value2) {
        Object previousValue;
        if (key == 0) {
            this.specialZeroValue = value2;
            this.hasZeroValue = true;
            return;
        }
        if (this.size >= 2 * this.values.length / 3) {
            this.rehash();
        }
        if ((previousValue = IntObjectHashMap.doPut(this.keys, this.values, key, value2)) == null) {
            ++this.size;
        }
    }

    private static Object doPut(int[] keys, Object[] values2, int key, Object value2) {
        int index2 = IntObjectHashMap.hashIndex(keys, key);
        Object obj = values2[index2];
        values2[index2] = value2;
        if (keys[index2] == 0) {
            keys[index2] = key;
        }
        return obj;
    }

    private static int hashIndex(int[] keys, int key) {
        int candidate2;
        int hash = (int)((long)key * 2654435769L & Integer.MAX_VALUE);
        int index2 = hash & keys.length - 1;
        while ((candidate2 = keys[index2]) != 0) {
            if (candidate2 == key) {
                return index2;
            }
            if (index2 == 0) {
                index2 = keys.length;
            }
            --index2;
        }
        return index2;
    }

    private void rehash() {
        int[] newKeys = new int[this.keys.length << 1];
        Object[] newValues = new Object[newKeys.length];
        for (int i = this.keys.length - 1; i >= 0; --i) {
            int key = this.keys[i];
            if (key == 0) continue;
            IntObjectHashMap.doPut(newKeys, newValues, key, this.values[i]);
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    public Object get(int key) {
        return key == 0 ? this.specialZeroValue : this.values[IntObjectHashMap.hashIndex(this.keys, key)];
    }
}

