/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.deprecation.Deprecation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/DeprecatedCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "PROPERTY_SET_OPERATIONS", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "shouldCheckPropertyGetter", "", "expression", "shouldCheckPropertyGetter$frontend", "frontend"})
public final class DeprecatedCallChecker
implements CallChecker {
    private static final TokenSet PROPERTY_SET_OPERATIONS;
    public static final DeprecatedCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.resultingDescriptor");
        this.check((CallableDescriptor)obj, context2.getTrace(), reportOn, context2.getLanguageVersionSettings(), context2.getDeprecationResolver());
    }

    private final void check(CallableDescriptor targetDescriptor, BindingTrace trace, PsiElement element, LanguageVersionSettings languageVersionSettings, DeprecationResolver deprecationResolver) {
        block5: {
            boolean bl;
            boolean bl2;
            Object object;
            block4: {
                if (targetDescriptor instanceof FakeCallableDescriptorForObject) {
                    return;
                }
                List deprecations2 = CollectionsKt.toMutableList((Collection)deprecationResolver.getDeprecations(targetDescriptor));
                if (targetDescriptor instanceof PropertySetterDescriptor) {
                    object = deprecations2;
                    PropertyDescriptor propertyDescriptor2 = ((PropertySetterDescriptor)targetDescriptor).getCorrespondingProperty();
                    Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor2, (String)"targetDescriptor.correspondingProperty");
                    Iterable iterable = deprecationResolver.getDeprecations(propertyDescriptor2);
                    bl2 = false;
                    CollectionsKt.removeAll((Collection)object, (Iterable)iterable);
                }
                object = deprecations2;
                bl = false;
                if (!(!object.isEmpty())) break block4;
                for (Deprecation deprecation : deprecations2) {
                    trace.report(DeprecationUtilKt.createDeprecationDiagnostic(element, deprecation, languageVersionSettings));
                }
                break block5;
            }
            if (!(targetDescriptor instanceof PropertyDescriptor) || !this.shouldCheckPropertyGetter$frontend(element)) break block5;
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)targetDescriptor).getGetter();
            if (propertyGetterDescriptor != null) {
                object = propertyGetterDescriptor;
                bl = false;
                bl2 = false;
                Object it = object;
                boolean bl3 = false;
                Object object2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
                INSTANCE.check((CallableDescriptor)object2, trace, element, languageVersionSettings, deprecationResolver);
            }
        }
    }

    public final boolean shouldCheckPropertyGetter$frontend(@NotNull PsiElement expression2) {
        KtUnaryExpression unaryExpression;
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtBinaryExpression binaryExpression = PsiTreeUtil.getParentOfType(expression2, KtBinaryExpression.class);
        if (binaryExpression != null) {
            KtExpression left = binaryExpression.getLeft();
            if (Intrinsics.areEqual((Object)left, (Object)expression2) && PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) {
                return false;
            }
            KtReferenceExpression[] referenceExpressions = (KtReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)left, KtReferenceExpression.class);
            if (referenceExpressions != null) {
                for (KtReferenceExpression expr : referenceExpressions) {
                    if (!Intrinsics.areEqual((Object)expr, (Object)expression2) || !PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) continue;
                    return false;
                }
            }
        }
        if (PROPERTY_SET_OPERATIONS.contains((ktExpression = (unaryExpression = PsiTreeUtil.getParentOfType(expression2, KtUnaryExpression.class))) != null && (ktExpression = ((KtUnaryExpression)ktExpression).getOperationReference()) != null ? ktExpression.getReferencedNameElementType() : null)) {
            return false;
        }
        KtCallableReferenceExpression callableExpression = PsiTreeUtil.getParentOfType(expression2, KtCallableReferenceExpression.class);
        return callableExpression == null || !Intrinsics.areEqual((Object)callableExpression.getCallableReference(), (Object)expression2);
    }

    private DeprecatedCallChecker() {
    }

    static {
        DeprecatedCallChecker deprecatedCallChecker;
        INSTANCE = deprecatedCallChecker = new DeprecatedCallChecker();
        SpreadBuilder spreadBuilder2 = new SpreadBuilder(3);
        TokenSet tokenSet = KtTokens.ALL_ASSIGNMENTS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"KtTokens.ALL_ASSIGNMENTS");
        spreadBuilder2.addSpread((Object)tokenSet.getTypes());
        spreadBuilder2.add((Object)KtTokens.PLUSPLUS);
        spreadBuilder2.add((Object)KtTokens.MINUSMINUS);
        TokenSet tokenSet2 = TokenSet.create((IElementType[])spreadBuilder2.toArray((Object[])new IElementType[spreadBuilder2.size()]));
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet2, (String)"TokenSet.create(*KtToken\u2026LUS, KtTokens.MINUSMINUS)");
        PROPERTY_SET_OPERATIONS = tokenSet2;
    }
}

